/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.ListFragment;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;
import java.util.ArrayList;

public class ChannelListFragment
extends ListFragment
implements NetworkConnection.IRCEventHandler {
    ArrayList<ChannelsAdapter.Channel> channels;
    ChannelsAdapter adapter;
    NetworkConnection conn;
    ListView listView;
    TextView empty;
    ServersDataSource.Server server;

    @Override
    public View onCreateView(LayoutInflater i, ViewGroup container, Bundle savedInstanceState) {
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        FragmentActivity ctx = this.getActivity();
        if (ctx == null) {
            return null;
        }
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        this.empty = (TextView)v.findViewById(16908292);
        this.empty.setText((CharSequence)"Loading channel list\u2026");
        this.listView.setEmptyView((View)this.empty);
        return v;
    }

    @Override
    public void setArguments(Bundle args) {
        this.server = ServersDataSource.getInstance().getServer(args.getInt("cid", -1));
        this.channels = null;
        if (this.listView != null && this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChannelListFragment.this.empty.setText((CharSequence)"Loading channel list\u2026");
                    ChannelListFragment.this.adapter = new ChannelsAdapter(ChannelListFragment.this);
                    ChannelListFragment.this.listView.setAdapter((ListAdapter)ChannelListFragment.this.adapter);
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.conn == null) {
            this.conn = NetworkConnection.getInstance();
            this.conn.addHandler(this);
        }
        if (this.adapter == null) {
            this.adapter = new ChannelsAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
        this.conn = null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
        refWatcher.watch(this.channels);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 36: {
                final IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListFragment.this.adapter.set(o.getJsonNode("channels"));
                        ChannelListFragment.this.adapter.notifyDataSetChanged();
                    }
                });
                break;
            }
            case 37: {
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListFragment.this.empty.setText((CharSequence)"Too many channels to list");
                    }
                });
                break;
            }
        }
    }

    private class ChannelsAdapter
    extends BaseAdapter {
        private ListFragment ctx;

        public ChannelsAdapter(ListFragment context) {
            this.ctx = context;
        }

        public void set(JsonNode json) {
            ChannelListFragment.this.channels = new ArrayList(json.size());
            for (int i = 0; i < json.size(); ++i) {
                Channel c = new Channel();
                JsonNode o = json.get(i);
                String channel = o.get("name").asText() + " (" + o.get("num_members").asInt() + " member";
                if (o.get("num_members").asInt() != 1) {
                    channel = channel + "s";
                }
                channel = channel + ")";
                c.channel = ColorFormatter.html_to_spanned(channel, true, ChannelListFragment.this.server);
                String topic = o.get("topic").asText();
                c.topic = topic.length() > 0 ? ColorFormatter.html_to_spanned(topic, true, ChannelListFragment.this.server) : null;
                ChannelListFragment.this.channels.add(c);
            }
        }

        public int getCount() {
            if (ChannelListFragment.this.channels == null) {
                return 0;
            }
            return ChannelListFragment.this.channels.size();
        }

        public Object getItem(int pos) {
            try {
                return ChannelListFragment.this.channels.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903117, null);
                holder = new ViewHolder();
                holder.channel = (TextView)row.findViewById(2131624192);
                holder.topic = (TextView)row.findViewById(2131624122);
                holder.channel.setMovementMethod(LinkMovementMethod.getInstance());
                holder.topic.setMovementMethod(LinkMovementMethod.getInstance());
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                Channel c = ChannelListFragment.this.channels.get(position);
                holder.channel.setText((CharSequence)c.channel);
                if (c.topic != null && c.topic.length() > 0) {
                    holder.topic.setText((CharSequence)c.topic);
                    holder.topic.setVisibility(0);
                } else {
                    holder.topic.setText((CharSequence)"");
                    holder.topic.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class Channel {
            Spanned channel;
            Spanned topic;

            private Channel() {
            }
        }

        private class ViewHolder {
            TextView channel;
            TextView topic;

            private ViewHolder() {
            }
        }
    }
}

