/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.Html;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import com.squareup.leakcanary.RefWatcher;

public class ChannelModeListFragment
extends DialogFragment
implements NetworkConnection.IRCEventHandler {
    JsonNode data;
    int cid;
    int bid;
    IRCCloudJSONObject event;
    Adapter adapter;
    NetworkConnection conn;
    ListView listView;
    String mode;
    String placeholder;
    String mask;
    String list;
    String title;
    boolean canChangeMode = false;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        if (ctx == null) {
            return null;
        }
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        TextView empty = (TextView)v.findViewById(16908292);
        empty.setText((CharSequence)this.placeholder);
        this.listView.setEmptyView((View)empty);
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.cid = savedInstanceState.getInt("cid");
            this.bid = savedInstanceState.getInt("bid");
            this.event = new IRCCloudJSONObject(savedInstanceState.getString("event"));
            this.list = savedInstanceState.getString("list");
            this.mask = savedInstanceState.getString("mask");
            this.placeholder = savedInstanceState.getString("placeholder");
            this.title = savedInstanceState.getString("title");
            this.mode = savedInstanceState.getString("mode");
            this.data = this.event.getJsonNode(this.list);
            this.adapter = new Adapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        AlertDialog.Builder b = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle(this.title).setView(v).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        try {
            if (this.canChangeMode) {
                b.setPositiveButton("Add", new AddClickListener());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AlertDialog d = b.create();
        d.getWindow().setSoftInputMode(16);
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putInt("cid", this.cid);
        state.putInt("bid", this.bid);
        state.putString("event", this.event.toString());
        state.putString("list", this.list);
        state.putString("mask", this.mask);
        state.putString("placeholder", this.placeholder);
        state.putString("title", this.title);
        state.putString("mode", this.mode);
    }

    @Override
    public void setArguments(Bundle args) {
        this.cid = args.getInt("cid", 0);
        this.bid = args.getInt("bid", 0);
        this.event = new IRCCloudJSONObject(args.getString("event"));
        this.list = args.getString("list");
        this.mask = args.getString("mask");
        this.placeholder = args.getString("placeholder");
        this.title = args.getString("title");
        this.mode = args.getString("mode");
        this.data = this.event.getJsonNode(this.list);
        ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
        UsersDataSource.User self_user = UsersDataSource.getInstance().getUser(this.bid, s.nick);
        boolean bl = this.canChangeMode = self_user != null && (self_user.mode.contains(s.MODE_OWNER) || self_user.mode.contains(s.MODE_ADMIN) || self_user.mode.contains(s.MODE_OP));
        if (this.getActivity() != null && this.cid > 0 && this.listView != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ChannelModeListFragment.this.adapter == null) {
                        ChannelModeListFragment.this.adapter = new Adapter(ChannelModeListFragment.this);
                        ChannelModeListFragment.this.listView.setAdapter((ListAdapter)ChannelModeListFragment.this.adapter);
                    } else {
                        ChannelModeListFragment.this.adapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    @Override
    public void onResume() {
        UsersDataSource.User self_user;
        ServersDataSource.Server s;
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        if (this.cid > 0) {
            this.adapter = new Adapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        this.canChangeMode = (s = ServersDataSource.getInstance().getServer(this.cid)) != null ? (self_user = UsersDataSource.getInstance().getUser(this.bid, s.nick)) != null && (self_user.mode.contains(s.MODE_OWNER) || self_user.mode.contains(s.MODE_ADMIN) || self_user.mode.contains(s.MODE_OP) || self_user.mode.contains(s.MODE_HALFOP)) : false;
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
        refWatcher.watch(this.data);
        refWatcher.watch(this.event);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 14: {
                ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
                UsersDataSource.User self_user = UsersDataSource.getInstance().getUser(this.bid, s.nick);
                this.canChangeMode = self_user != null && (self_user.mode.contains(s.MODE_OWNER) || self_user.mode.contains(s.MODE_ADMIN) || self_user.mode.contains(s.MODE_OP));
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ChannelModeListFragment.this.adapter != null) {
                            ChannelModeListFragment.this.adapter.notifyDataSetChanged();
                        }
                    }
                });
                break;
            }
            case 5: {
                EventsDataSource.Event e = (EventsDataSource.Event)obj;
                if (e.bid != this.bid || !e.type.equals("channel_mode_list_change")) break;
                this.conn.mode(this.cid, this.event.getString("channel"), this.mode);
                break;
            }
        }
    }

    class AddClickListener
    implements DialogInterface.OnClickListener {
        AddClickListener() {
        }

        public void onClick(DialogInterface d, int which) {
            FragmentActivity ctx = ChannelModeListFragment.this.getActivity();
            ServersDataSource s = ServersDataSource.getInstance();
            ServersDataSource.Server server = s.getServer(ChannelModeListFragment.this.cid);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)ctx);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
            View view = inflater.inflate(2130903091, null);
            TextView prompt = (TextView)view.findViewById(2131624120);
            final EditText input = (EditText)view.findViewById(2131624121);
            input.setHint((CharSequence)"nickname!user@host.name");
            prompt.setText((CharSequence)"Add this hostmask");
            builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
            builder.setView(view);
            builder.setPositiveButton("Add", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ChannelModeListFragment.this.conn.mode(ChannelModeListFragment.this.cid, ChannelModeListFragment.this.event.getString("channel"), "+" + ChannelModeListFragment.this.mode + " " + input.getText().toString());
                    dialog.dismiss();
                }
            });
            builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(ChannelModeListFragment.this.getActivity());
            dialog.getWindow().setSoftInputMode(5);
            dialog.show();
        }
    }

    private class Adapter
    extends BaseAdapter {
        private DialogFragment ctx;
        View.OnClickListener removeClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                Integer position = (Integer)v.getTag();
                try {
                    ChannelModeListFragment.this.conn.mode(ChannelModeListFragment.this.cid, ChannelModeListFragment.this.event.getString("channel"), "-" + ChannelModeListFragment.this.mode + " " + ChannelModeListFragment.this.data.get(position).get(ChannelModeListFragment.this.mask).asText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };

        public Adapter(DialogFragment context) {
            this.ctx = context;
        }

        public int getCount() {
            return ChannelModeListFragment.this.data.size();
        }

        public Object getItem(int pos) {
            try {
                return ChannelModeListFragment.this.data.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (this.ctx == null) {
                return null;
            }
            View row = convertView;
            if (row != null && ((ViewHolder)row.getTag()).position != position) {
                row = null;
            }
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903115, null);
                holder = new ViewHolder();
                holder.position = position;
                holder.mask = (TextView)row.findViewById(2131624136);
                holder.setBy = (TextView)row.findViewById(2131624123);
                holder.removeBtn = (Button)row.findViewById(2131624187);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                holder.mask.setText((CharSequence)Html.fromHtml((String)ChannelModeListFragment.this.data.get(position).get(ChannelModeListFragment.this.mask).asText()));
                holder.setBy.setText((CharSequence)("Set " + DateUtils.getRelativeTimeSpanString((long)(ChannelModeListFragment.this.data.get(position).get("time").asLong() * 1000L), (long)System.currentTimeMillis(), (long)1000L) + " by " + ChannelModeListFragment.this.data.get(position).get("usermask").asText()));
                if (ChannelModeListFragment.this.canChangeMode) {
                    holder.removeBtn.setVisibility(0);
                    holder.removeBtn.setOnClickListener(this.removeClickListener);
                    holder.removeBtn.setTag((Object)position);
                } else {
                    holder.removeBtn.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            int position;
            TextView mask;
            TextView setBy;
            Button removeBtn;

            private ViewHolder() {
            }
        }
    }
}

