/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.squareup.leakcanary.RefWatcher;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ValidFragment"})
public class ChannelOptionsFragment
extends DialogFragment {
    SwitchCompat members;
    SwitchCompat unread;
    SwitchCompat joinpart;
    SwitchCompat collapse;
    SwitchCompat notifyAll;
    SwitchCompat autosuggest;
    int cid;
    int bid;

    public ChannelOptionsFragment() {
        this.cid = -1;
        this.bid = -1;
    }

    public ChannelOptionsFragment(int cid, int bid) {
        this.cid = cid;
        this.bid = bid;
    }

    public JSONObject updatePref(JSONObject prefs, SwitchCompat control, String key) throws JSONException {
        boolean checked = control.isChecked();
        if (control == this.notifyAll) {
            boolean bl = checked = !checked;
        }
        if (!checked) {
            JSONObject map = prefs.has(key) ? prefs.getJSONObject(key) : new JSONObject();
            map.put(String.valueOf(this.bid), true);
            prefs.put(key, (Object)map);
        } else if (prefs.has(key)) {
            JSONObject map = prefs.getJSONObject(key);
            map.remove(String.valueOf(this.bid));
            prefs.put(key, (Object)map);
        }
        return prefs;
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (NetworkConnection.getInstance().getUserInfo() != null) {
                JSONObject prefs = NetworkConnection.getInstance().getUserInfo().prefs;
                if (prefs != null) {
                    if (prefs.has("channel-hideJoinPart")) {
                        JSONObject hiddenMap = prefs.getJSONObject("channel-hideJoinPart");
                        if (hiddenMap.has(String.valueOf(this.bid)) && hiddenMap.getBoolean(String.valueOf(this.bid))) {
                            this.joinpart.setChecked(false);
                        } else {
                            this.joinpart.setChecked(true);
                        }
                    } else {
                        this.joinpart.setChecked(true);
                    }
                    if (prefs.has("channel-disableTrackUnread")) {
                        JSONObject unreadMap = prefs.getJSONObject("channel-disableTrackUnread");
                        if (unreadMap.has(String.valueOf(this.bid)) && unreadMap.getBoolean(String.valueOf(this.bid))) {
                            this.unread.setChecked(false);
                        } else {
                            this.unread.setChecked(true);
                        }
                    } else {
                        this.unread.setChecked(true);
                    }
                    if (prefs.has("channel-hiddenMembers")) {
                        JSONObject membersMap = prefs.getJSONObject("channel-hiddenMembers");
                        if (membersMap.has(String.valueOf(this.bid)) && membersMap.getBoolean(String.valueOf(this.bid))) {
                            this.members.setChecked(false);
                        } else {
                            this.members.setChecked(true);
                        }
                    } else {
                        this.members.setChecked(true);
                    }
                    if (prefs.has("channel-expandJoinPart")) {
                        JSONObject expandMap = prefs.getJSONObject("channel-expandJoinPart");
                        if (expandMap.has(String.valueOf(this.bid)) && expandMap.getBoolean(String.valueOf(this.bid))) {
                            this.collapse.setChecked(false);
                        } else {
                            this.collapse.setChecked(true);
                        }
                    } else {
                        this.collapse.setChecked(true);
                    }
                    if (prefs.has("channel-notifications-all")) {
                        JSONObject notifyAllMap = prefs.getJSONObject("channel-notifications-all");
                        if (notifyAllMap.has(String.valueOf(this.bid)) && notifyAllMap.getBoolean(String.valueOf(this.bid))) {
                            this.notifyAll.setChecked(true);
                        } else {
                            this.notifyAll.setChecked(false);
                        }
                    } else {
                        this.notifyAll.setChecked(false);
                    }
                    if (prefs.has("channel-disableAutoSuggest")) {
                        JSONObject suggestMap = prefs.getJSONObject("channel-disableAutoSuggest");
                        if (suggestMap.has(String.valueOf(this.bid)) && suggestMap.getBoolean(String.valueOf(this.bid))) {
                            this.autosuggest.setChecked(false);
                        } else {
                            this.autosuggest.setChecked(true);
                        }
                    } else {
                        this.autosuggest.setChecked(true);
                    }
                } else {
                    this.notifyAll.setChecked(false);
                    this.joinpart.setChecked(true);
                    this.unread.setChecked(true);
                    this.members.setChecked(true);
                    this.collapse.setChecked(true);
                    this.autosuggest.setChecked(true);
                }
            } else {
                this.notifyAll.setChecked(false);
                this.joinpart.setChecked(true);
                this.unread.setChecked(true);
                this.members.setChecked(true);
                this.collapse.setChecked(true);
                this.autosuggest.setChecked(true);
            }
            if (!this.getActivity().getResources().getBoolean(2131361795)) {
                this.members.setVisibility(8);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey("cid") && this.cid == -1) {
            this.cid = savedInstanceState.getInt("cid");
            this.bid = savedInstanceState.getInt("bid");
        }
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903084, null);
        this.members = (SwitchCompat)v.findViewById(2131624094);
        this.unread = (SwitchCompat)v.findViewById(2131624090);
        this.notifyAll = (SwitchCompat)v.findViewById(2131624095);
        this.joinpart = (SwitchCompat)v.findViewById(2131624091);
        this.collapse = (SwitchCompat)v.findViewById(2131624092);
        this.autosuggest = (SwitchCompat)v.findViewById(2131624096);
        return new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("Display Options").setView(v).setPositiveButton("Save", new SaveClickListener()).setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putInt("cid", this.cid);
        state.putInt("bid", this.bid);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    class SaveClickListener
    implements DialogInterface.OnClickListener {
        SaveClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
            JSONObject prefs = null;
            try {
                if (NetworkConnection.getInstance().getUserInfo() != null) {
                    prefs = NetworkConnection.getInstance().getUserInfo().prefs;
                    if (prefs == null) {
                        prefs = new JSONObject();
                        Crashlytics.logException(new Exception("Users prefs was null, creating new object"));
                    }
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.members, "channel-hiddenMembers");
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.unread, "channel-disableTrackUnread");
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.joinpart, "channel-hideJoinPart");
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.collapse, "channel-expandJoinPart");
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.notifyAll, "channel-notifications-all");
                    prefs = ChannelOptionsFragment.this.updatePref(prefs, ChannelOptionsFragment.this.autosuggest, "channel-disableAutoSuggest");
                    NetworkConnection.getInstance().set_prefs(prefs.toString());
                } else {
                    Toast.makeText((Context)ChannelOptionsFragment.this.getActivity(), (CharSequence)"An error occurred while saving preferences.  Please try again shortly", (int)0).show();
                }
            }
            catch (Exception e) {
                Crashlytics.logException(e);
                Toast.makeText((Context)ChannelOptionsFragment.this.getActivity(), (CharSequence)"An error occurred while saving preferences.  Please try again shortly", (int)0).show();
            }
            ChannelOptionsFragment.this.dismiss();
        }
    }
}

