/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EditConnectionFragment
extends DialogFragment
implements NetworkConnection.IRCEventHandler {
    PresetServersAdapter adapter;
    ServersDataSource.Server server;
    LinearLayout channelsWrapper;
    Spinner presets;
    EditText hostname;
    EditText port;
    SwitchCompat ssl;
    EditText nickname;
    EditText realname;
    EditText channels;
    EditText nickserv_pass;
    EditText join_commands;
    EditText server_pass;
    EditText network;
    public String default_hostname = null;
    public int default_port = 6667;
    public String default_channels = null;
    private int reqid = -1;

    private void init(View v) {
        this.channelsWrapper = (LinearLayout)v.findViewById(2131624105);
        this.presets = (Spinner)v.findViewById(2131624101);
        this.hostname = (EditText)v.findViewById(2131624109);
        this.port = (EditText)v.findViewById(2131624110);
        this.ssl = (SwitchCompat)v.findViewById(2131624111);
        this.nickname = (EditText)v.findViewById(2131624103);
        this.realname = (EditText)v.findViewById(2131624104);
        this.channels = (EditText)v.findViewById(2131624089);
        this.nickserv_pass = (EditText)v.findViewById(2131624106);
        this.join_commands = (EditText)v.findViewById(2131624108);
        this.server_pass = (EditText)v.findViewById(2131624107);
        this.network = (EditText)v.findViewById(2131624102);
        this.presets.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                if (position == 0) {
                    if (EditConnectionFragment.this.server != null) {
                        EditConnectionFragment.this.hostname.setText((CharSequence)EditConnectionFragment.this.server.hostname);
                        EditConnectionFragment.this.port.setText((CharSequence)String.valueOf(EditConnectionFragment.this.server.port));
                        EditConnectionFragment.this.ssl.setChecked(EditConnectionFragment.this.server.ssl == 1);
                    } else {
                        if (EditConnectionFragment.this.default_hostname != null) {
                            EditConnectionFragment.this.hostname.setText((CharSequence)EditConnectionFragment.this.default_hostname);
                        } else {
                            EditConnectionFragment.this.hostname.setText((CharSequence)"");
                        }
                        EditConnectionFragment.this.port.setText((CharSequence)String.valueOf(EditConnectionFragment.this.default_port));
                        EditConnectionFragment.this.ssl.setChecked(EditConnectionFragment.this.default_port == 6697);
                    }
                } else {
                    PresetServersAdapter.PresetServer s = (PresetServersAdapter.PresetServer)EditConnectionFragment.this.adapter.getItem(position);
                    EditConnectionFragment.this.hostname.setText((CharSequence)s.host);
                    EditConnectionFragment.this.port.setText((CharSequence)String.valueOf(s.port));
                    EditConnectionFragment.this.ssl.setChecked(s.port == 6697);
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
                if (EditConnectionFragment.this.server != null) {
                    EditConnectionFragment.this.hostname.setText((CharSequence)EditConnectionFragment.this.server.hostname);
                    EditConnectionFragment.this.port.setText((CharSequence)String.valueOf(EditConnectionFragment.this.server.port));
                    EditConnectionFragment.this.ssl.setChecked(EditConnectionFragment.this.server.ssl == 1);
                } else {
                    if (EditConnectionFragment.this.default_hostname != null) {
                        EditConnectionFragment.this.hostname.setText((CharSequence)EditConnectionFragment.this.default_hostname);
                    } else {
                        EditConnectionFragment.this.hostname.setText((CharSequence)"");
                    }
                    EditConnectionFragment.this.port.setText((CharSequence)String.valueOf(EditConnectionFragment.this.default_port));
                    EditConnectionFragment.this.ssl.setChecked(EditConnectionFragment.this.default_port == 6697);
                }
            }
        });
        if (NetworkConnection.getInstance().getUserInfo() != null && !NetworkConnection.getInstance().getUserInfo().verified) {
            Button b = (Button)v.findViewById(2131624100);
            b.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NetworkConnection.getInstance().resend_verify_email();
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)EditConnectionFragment.this.getActivity());
                    builder.setTitle("Confirmation Sent");
                    builder.setMessage("You should shortly receive an email with a link to confirm your address.");
                    builder.setNeutralButton("Close", null);
                    builder.show();
                }
            });
            v.findViewById(2131624098).setVisibility(0);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        View v = inflater.inflate(2130903086, container, false);
        this.init(v);
        return v;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903086, null);
        this.init(v);
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.server = ServersDataSource.getInstance().getServer(savedInstanceState.getInt("cid"));
        }
        final AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle(this.server == null ? "Add A Network" : "Edit Connection").setView(v).setPositiveButton(this.server == null ? "Add" : "Save", null).setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NetworkConnection.getInstance().removeHandler(EditConnectionFragment.this);
            }
        }).create();
        d.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                Button b = d.getButton(-1);
                b.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        NetworkConnection.getInstance().removeHandler(EditConnectionFragment.this);
                        NetworkConnection.getInstance().addHandler(EditConnectionFragment.this);
                        EditConnectionFragment.this.reqid = EditConnectionFragment.this.save();
                    }
                });
            }
        });
        d.getWindow().setSoftInputMode(16);
        return d;
    }

    public void setCid(int cid) {
        this.server = ServersDataSource.getInstance().getServer(cid);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.server != null) {
            this.presets.setSelection(0);
            this.presets.setVisibility(8);
            this.network.setVisibility(0);
            this.network.setText((CharSequence)this.server.name);
            this.channelsWrapper.setVisibility(8);
            this.hostname.setText((CharSequence)this.server.hostname);
            this.port.setText((CharSequence)String.valueOf(this.server.port));
            this.ssl.setChecked(this.server.ssl > 0);
            this.nickname.setText((CharSequence)this.server.nick);
            this.realname.setText((CharSequence)this.server.realname);
            this.join_commands.setText((CharSequence)this.server.join_commands);
            this.nickserv_pass.setText((CharSequence)this.server.nickserv_pass);
            this.server_pass.setText((CharSequence)this.server.server_pass);
        } else {
            if (this.adapter == null) {
                new LoadNetworkPresets().execute(new Void[]{null});
            }
            if (this.default_hostname != null) {
                this.hostname.setText((CharSequence)this.default_hostname);
            }
            this.port.setText((CharSequence)String.valueOf(this.default_port));
            this.ssl.setChecked(this.default_port == 6697);
            if (this.default_channels != null) {
                this.channels.setText((CharSequence)this.default_channels);
            }
            if (NetworkConnection.getInstance().getUserInfo() != null) {
                String name = NetworkConnection.getInstance().getUserInfo().name;
                String nick = name.contains(" ") ? name.substring(0, name.indexOf(" ")) : name;
                this.realname.setText((CharSequence)name);
                this.nickname.setText((CharSequence)nick.toLowerCase());
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.presets != null) {
            this.presets.setOnItemSelectedListener(null);
        }
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (this.server != null) {
            savedInstanceState.putInt("cid", this.server.cid);
        }
    }

    public int save() {
        int portValue = 6667;
        try {
            portValue = Integer.parseInt(this.port.getText().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.server == null) {
            String netname = null;
            if (this.presets.getSelectedItemPosition() > 0) {
                netname = ((PresetServersAdapter.PresetServer)this.adapter.getItem((int)this.presets.getSelectedItemPosition())).network;
            }
            return NetworkConnection.getInstance().addServer(this.hostname.getText().toString(), portValue, this.ssl.isChecked() ? 1 : 0, netname, this.nickname.getText().toString(), this.realname.getText().toString(), this.server_pass.getText().toString(), this.nickserv_pass.getText().toString(), this.join_commands.getText().toString(), this.channels.getText().toString());
        }
        String netname = this.network.getText().toString();
        if (this.hostname.getText().toString().equalsIgnoreCase(netname)) {
            netname = null;
        }
        return NetworkConnection.getInstance().editServer(this.server.cid, this.hostname.getText().toString(), portValue, this.ssl.isChecked() ? 1 : 0, netname, this.nickname.getText().toString(), this.realname.getText().toString(), this.server_pass.getText().toString(), this.nickserv_pass.getText().toString(), this.join_commands.getText().toString());
    }

    @Override
    public void onIRCEvent(int what, Object o) {
        switch (what) {
            case 104: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                NetworkConnection.getInstance().removeHandler(this);
                try {
                    this.dismiss();
                }
                catch (Exception exception) {}
                break;
            }
            case 103: {
                IRCCloudJSONObject obj = (IRCCloudJSONObject)o;
                if (obj.getInt("_reqid") != this.reqid) break;
                final String message = obj.getString("message");
                if (this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (message.equals("passworded_servers")) {
                            Toast.makeText((Context)IRCCloudApplication.getInstance().getApplicationContext(), (CharSequence)"You can\u2019t connect to passworded servers with free accounts.", (int)0).show();
                        } else if (message.equals("networks")) {
                            Toast.makeText((Context)IRCCloudApplication.getInstance().getApplicationContext(), (CharSequence)"You've exceeded the connection limit for free accounts.", (int)0).show();
                        } else if (message.equals("unverified")) {
                            Toast.makeText((Context)IRCCloudApplication.getInstance().getApplicationContext(), (CharSequence)"You can\u2019t connect to external servers until you confirm your email address.", (int)0).show();
                        } else {
                            Toast.makeText((Context)IRCCloudApplication.getInstance().getApplicationContext(), (CharSequence)("Unable to add connection: invalid " + message), (int)0).show();
                        }
                    }
                });
                break;
            }
            case 1: {
                try {
                    this.dismiss();
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    private class LoadNetworkPresets
    extends AsyncTaskEx<Void, Void, JSONArray> {
        private LoadNetworkPresets() {
        }

        @Override
        protected void onPreExecute() {
            EditConnectionFragment.this.presets.setEnabled(false);
            EditConnectionFragment.this.presets.setAdapter((SpinnerAdapter)new ArrayAdapter((Context)EditConnectionFragment.this.getActivity(), 2130903097, 2131624157, (Object[])new String[]{"Loading networks"}));
        }

        protected JSONArray doInBackground(Void ... params) {
            try {
                return NetworkConnection.getInstance().networkPresets();
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        protected void onPostExecute(JSONArray networks) {
            EditConnectionFragment.this.adapter = networks != null && networks.length() > 0 ? new PresetServersAdapter(EditConnectionFragment.this.getActivity(), networks) : new PresetServersAdapter(EditConnectionFragment.this.getActivity());
            EditConnectionFragment.this.presets.setAdapter((SpinnerAdapter)EditConnectionFragment.this.adapter);
            EditConnectionFragment.this.presets.setEnabled(true);
        }
    }

    private class PresetServersAdapter
    extends BaseAdapter {
        private Activity ctx;
        private ArrayList<PresetServer> data;

        public PresetServersAdapter(Activity context, JSONArray networks) {
            this.ctx = context;
            this.data = new ArrayList();
            this.data.add(new PresetServer(null, null, 0));
            for (int i = 0; i < networks.length(); ++i) {
                try {
                    JSONObject o = networks.getJSONObject(i);
                    String name = o.getString("name");
                    JSONObject server = o.getJSONArray("servers").getJSONObject(0);
                    this.data.add(new PresetServer(name, server.getString("hostname"), server.getInt("port")));
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }

        public PresetServersAdapter(Activity context) {
            this.ctx = context;
            this.data = new ArrayList();
            this.data.add(new PresetServer(null, null, 0));
            this.data.add(new PresetServer("IRCCloud", "irc.irccloud.com", 6667));
            this.data.add(new PresetServer("Freenode", "irc.freenode.net", 6697));
            this.data.add(new PresetServer("QuakeNet", "blacklotus.ca.us.quakenet.org", 6667));
            this.data.add(new PresetServer("IRCNet", "ircnet.blacklotus.net", 6667));
            this.data.add(new PresetServer("Undernet", "losangeles.ca.us.undernet.org", 6667));
            this.data.add(new PresetServer("DALNet", "dalnet.blacklotus.net", 6667));
            this.data.add(new PresetServer("OFTC", "irc.oftc.net", 6667));
            this.data.add(new PresetServer("GameSurge", "irc.gamesurge.net", 6667));
            this.data.add(new PresetServer("Efnet", "efnet.port80.se", 6667));
            this.data.add(new PresetServer("Mozilla", "irc.mozilla.org", 6697));
            this.data.add(new PresetServer("Rizon", "irc6.rizon.net", 6697));
            this.data.add(new PresetServer("Espernet", "irc.esper.net", 6667));
            this.data.add(new PresetServer("ReplayIRC", "irc.replayirc.com", 6667));
            this.data.add(new PresetServer("synIRC", "naamio.fi.eu.synirc.net", 6697));
            this.data.add(new PresetServer("fossnet", "irc.fossnet.info", 6697));
            this.data.add(new PresetServer("P2P-NET", "irc.p2p-network.net", 6697));
            this.data.add(new PresetServer("euIRCnet", "irc.euirc.net", 6697));
            this.data.add(new PresetServer("SlashNET", "irc.slashnet.org", 6697));
            this.data.add(new PresetServer("Atrum", "irc.atrum.org", 6697));
            this.data.add(new PresetServer("Indymedia", "irc.indymedia.org", 6697));
            this.data.add(new PresetServer("TWiT", "irc.twit.tv", 6697));
            this.data.add(new PresetServer("Snoonet", "irc.snoonet.org", 6697));
            this.data.add(new PresetServer("BrasIRC", "irc.brasirc.org", 6667));
            this.data.add(new PresetServer("darkscience", "irc.darkscience.net", 6697));
            this.data.add(new PresetServer("Techman's World", "irc.techmansworld.com", 6697));
        }

        public int getCount() {
            return this.data.size();
        }

        public Object getItem(int pos) {
            return this.data.get(pos);
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView label;
            View row = convertView;
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater();
                row = inflater.inflate(17367048, null);
                label = (TextView)row.findViewById(16908308);
                row.setTag((Object)label);
            } else {
                label = (TextView)row.getTag();
            }
            if (position == 0) {
                label.setText((CharSequence)"Choose a network\u2026");
            } else {
                label.setText((CharSequence)this.data.get((int)position).network);
            }
            return row;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater();
                row = inflater.inflate(2130903124, null);
                holder = new ViewHolder();
                holder.network = (TextView)row.findViewById(2131624102);
                holder.hostname = (TextView)row.findViewById(2131624109);
                holder.lock = (ImageView)row.findViewById(2131624202);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            if (position == 0) {
                holder.network.setText((CharSequence)"Choose a network\u2026");
                holder.hostname.setVisibility(8);
                holder.lock.setVisibility(8);
            } else {
                PresetServer s = this.data.get(position);
                holder.network.setText((CharSequence)s.network);
                holder.hostname.setText((CharSequence)s.host);
                holder.hostname.setVisibility(0);
                if (s.port == 6697) {
                    holder.lock.setVisibility(0);
                } else {
                    holder.lock.setVisibility(8);
                }
            }
            return row;
        }

        private class PresetServer {
            String network;
            String host;
            int port;

            public PresetServer(String network, String host, int port) {
                this.network = network;
                this.host = host;
                this.port = port;
            }
        }

        private class ViewHolder {
            TextView network;
            TextView hostname;
            ImageView lock;

            private ViewHolder() {
            }
        }
    }
}

