/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;

public class IgnoreListFragment
extends DialogFragment
implements NetworkConnection.IRCEventHandler {
    JsonNode ignores;
    int cid;
    IgnoresAdapter adapter;
    NetworkConnection conn;
    ListView listView;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        TextView empty = (TextView)v.findViewById(16908292);
        empty.setText((CharSequence)"You're not ignoring anyone at the moment.\n\nYou can ignore someone by tapping their nickname in the user list, long-pressing a message, or by using /ignore.");
        this.listView.setEmptyView((View)empty);
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.cid = savedInstanceState.getInt("cid");
            this.ignores = ServersDataSource.getInstance().getServer((int)this.cid).raw_ignores;
            this.adapter = new IgnoresAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setTitle("Ignore list for " + ServersDataSource.getInstance().getServer((int)this.cid).name).setView(v).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setPositiveButton("Add Ignore Mask", new AddClickListener()).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        d.getWindow().setSoftInputMode(16);
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putInt("cid", this.cid);
    }

    @Override
    public void setArguments(Bundle args) {
        this.cid = args.getInt("cid", 0);
        if (this.getActivity() != null && this.cid > 0 && this.listView != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    IgnoreListFragment.this.ignores = ServersDataSource.getInstance().getServer((int)IgnoreListFragment.this.cid).raw_ignores;
                    IgnoreListFragment.this.adapter = new IgnoresAdapter(IgnoreListFragment.this);
                    IgnoreListFragment.this.listView.setAdapter((ListAdapter)IgnoreListFragment.this.adapter);
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        if (this.ignores == null && this.cid > 0) {
            this.ignores = ServersDataSource.getInstance().getServer((int)this.cid).raw_ignores;
            this.adapter = new IgnoresAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
        refWatcher.watch((Object)this.adapter);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 2: {
                ServersDataSource.Server s = (ServersDataSource.Server)obj;
                if (s.cid != this.cid || this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        IgnoreListFragment.this.ignores = ServersDataSource.getInstance().getServer((int)IgnoreListFragment.this.cid).raw_ignores;
                        IgnoreListFragment.this.adapter.notifyDataSetChanged();
                    }
                });
                break;
            }
            case 27: {
                IRCCloudJSONObject o = (IRCCloudJSONObject)obj;
                if (o.cid() != this.cid || this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        IgnoreListFragment.this.ignores = ServersDataSource.getInstance().getServer((int)IgnoreListFragment.this.cid).raw_ignores;
                        IgnoreListFragment.this.adapter.notifyDataSetChanged();
                    }
                });
                break;
            }
        }
    }

    class AddClickListener
    implements DialogInterface.OnClickListener {
        AddClickListener() {
        }

        public void onClick(DialogInterface d, int which) {
            FragmentActivity ctx = IgnoreListFragment.this.getActivity();
            ServersDataSource s = ServersDataSource.getInstance();
            ServersDataSource.Server server = s.getServer(IgnoreListFragment.this.cid);
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)ctx);
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
            View view = inflater.inflate(2130903091, null);
            TextView prompt = (TextView)view.findViewById(2131624120);
            final EditText input = (EditText)view.findViewById(2131624121);
            input.setHint((CharSequence)"nickname!user@host.name");
            prompt.setText((CharSequence)"Ignore messages from this hostmask");
            builder.setTitle(server.name + " (" + server.hostname + ":" + server.port + ")");
            builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
            builder.setView(view);
            builder.setPositiveButton("Ignore", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    IgnoreListFragment.this.conn.ignore(IgnoreListFragment.this.cid, input.getText().toString());
                    dialog.dismiss();
                }
            });
            builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.setOwnerActivity(IgnoreListFragment.this.getActivity());
            dialog.getWindow().setSoftInputMode(5);
            dialog.show();
        }
    }

    private class IgnoresAdapter
    extends BaseAdapter {
        private DialogFragment ctx;
        View.OnClickListener removeClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                Integer position = (Integer)v.getTag();
                try {
                    IgnoreListFragment.this.conn.unignore(IgnoreListFragment.this.cid, IgnoreListFragment.this.ignores.get(position).asText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };

        public IgnoresAdapter(DialogFragment context) {
            this.ctx = context;
        }

        public int getCount() {
            return IgnoreListFragment.this.ignores.size();
        }

        public Object getItem(int pos) {
            try {
                return IgnoreListFragment.this.ignores.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row != null && ((ViewHolder)row.getTag()).position != position) {
                row = null;
            }
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903119, null);
                holder = new ViewHolder();
                holder.position = position;
                holder.label = (TextView)row.findViewById(2131624189);
                holder.removeBtn = (Button)row.findViewById(2131624187);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                holder.label.setText((CharSequence)IgnoreListFragment.this.ignores.get(position).asText());
                holder.removeBtn.setOnClickListener(this.removeClickListener);
                holder.removeBtn.setTag((Object)position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            int position;
            TextView label;
            Button removeBtn;

            private ViewHolder() {
            }
        }
    }
}

