/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.v4.app.ListFragment;
import android.support.v4.widget.DrawerLayout;
import android.text.Html;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.uritemplate.URITemplate;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.CollapsedEventsList;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.Ignore;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.BuffersDataSource;
import com.irccloud.android.data.EventsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.fragment.BuffersListFragment;
import com.squareup.leakcanary.RefWatcher;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageViewFragment
extends ListFragment
implements NetworkConnection.IRCEventHandler {
    private NetworkConnection conn;
    private TextView statusView;
    private View headerViewContainer;
    private View headerView;
    private TextView backlogFailed;
    private Button loadBacklogButton;
    private TextView unreadTopLabel;
    private TextView unreadBottomLabel;
    private View unreadTopView;
    private View unreadBottomView;
    private TextView highlightsTopLabel;
    private TextView highlightsBottomLabel;
    public BuffersDataSource.Buffer buffer;
    private ServersDataSource.Server server;
    private long earliest_eid;
    private long backlog_eid = 0L;
    private boolean requestingBacklog = false;
    private float avgInsertTime = 0.0f;
    private int newMsgs = 0;
    private long newMsgTime = 0L;
    private int newHighlights = 0;
    private MessageViewListener mListener;
    private View awayView = null;
    private TextView awayTxt = null;
    private int timestamp_width = -1;
    private float textSize = 14.0f;
    private View globalMsgView = null;
    private TextView globalMsg = null;
    private ProgressBar spinner = null;
    private final Handler mHandler = new Handler();
    public static final int ROW_MESSAGE = 0;
    public static final int ROW_TIMESTAMP = 1;
    public static final int ROW_BACKLOGMARKER = 2;
    public static final int ROW_SOCKETCLOSED = 3;
    public static final int ROW_LASTSEENEID = 4;
    private static final String TYPE_TIMESTAMP = "__timestamp__";
    private static final String TYPE_BACKLOGMARKER = "__backlog__";
    private static final String TYPE_LASTSEENEID = "__lastseeneid__";
    private MessageAdapter adapter;
    private long currentCollapsedEid = -1L;
    private long lastCollapsedEid = -1L;
    private CollapsedEventsList collapsedEvents = new CollapsedEventsList();
    private int lastCollapsedDay = -1;
    private HashSet<Long> expandedSectionEids = new HashSet();
    private RefreshTask refreshTask = null;
    private HeartbeatTask heartbeatTask = null;
    private Ignore ignore = new Ignore();
    private static Timer tapTimer = null;
    private TimerTask tapTimerTask = null;
    public boolean longPressOverride = false;
    private LinkMovementMethodNoLongPress linkMovementMethodNoLongPress = new LinkMovementMethodNoLongPress();
    public boolean ready = false;
    private final Object adapterLock = new Object();
    public View suggestionsContainer = null;
    public GridView suggestions = null;
    private AbsListView.OnScrollListener mOnScrollListener = new AbsListView.OnScrollListener(){

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (!MessageViewFragment.this.ready || MessageViewFragment.this.buffer == null || !((MessageViewFragment)MessageViewFragment.this).conn.ready || MessageViewFragment.this.adapter == null || MessageViewFragment.this.requestingBacklog) {
                return;
            }
            if (MessageViewFragment.this.headerView != null && MessageViewFragment.this.buffer.min_eid > 0L && firstVisibleItem == 0 && MessageViewFragment.this.headerView.getVisibility() == 0 && MessageViewFragment.this.conn.getState() == 2) {
                MessageViewFragment.this.requestingBacklog = true;
                MessageViewFragment.this.conn.request_backlog(MessageViewFragment.this.buffer.cid, MessageViewFragment.this.buffer.bid, MessageViewFragment.this.earliest_eid);
                return;
            }
            if (MessageViewFragment.this.unreadBottomView != null && ((MessageViewFragment)MessageViewFragment.this).adapter.data.size() > 0 && firstVisibleItem + visibleItemCount == totalItemCount) {
                MessageViewFragment.this.unreadBottomView.setVisibility(8);
                if (MessageViewFragment.this.unreadTopView.getVisibility() == 8 && MessageViewFragment.this.conn.getState() == 2) {
                    if (MessageViewFragment.this.heartbeatTask != null) {
                        MessageViewFragment.this.heartbeatTask.cancel(true);
                    }
                    MessageViewFragment.this.heartbeatTask = new HeartbeatTask();
                    MessageViewFragment.this.heartbeatTask.execute(new Void[]{null});
                }
                MessageViewFragment.this.newMsgs = 0;
                MessageViewFragment.this.newMsgTime = 0L;
                MessageViewFragment.this.newHighlights = 0;
            }
            if (firstVisibleItem + visibleItemCount < totalItemCount) {
                View v = view.getChildAt(0);
                MessageViewFragment.this.buffer.scrolledUp = true;
                MessageViewFragment.this.buffer.scrollPosition = firstVisibleItem;
                MessageViewFragment.this.buffer.scrollPositionOffset = v == null ? 0 : v.getTop();
            } else {
                MessageViewFragment.this.buffer.scrolledUp = false;
                MessageViewFragment.this.buffer.scrollPosition = -1;
            }
            if (MessageViewFragment.this.adapter != null && ((MessageViewFragment)MessageViewFragment.this).adapter.data.size() > 0 && MessageViewFragment.this.unreadTopView != null && MessageViewFragment.this.unreadTopView.getVisibility() == 0) {
                MessageViewFragment.this.update_top_unread(firstVisibleItem);
                int markerPos = -1;
                if (MessageViewFragment.this.adapter != null) {
                    markerPos = MessageViewFragment.this.adapter.getLastSeenEIDPosition();
                }
                if (markerPos > 1 && MessageViewFragment.this.getListView().getFirstVisiblePosition() <= markerPos) {
                    MessageViewFragment.this.unreadTopView.setVisibility(8);
                    if (MessageViewFragment.this.conn.getState() == 2) {
                        if (MessageViewFragment.this.heartbeatTask != null) {
                            MessageViewFragment.this.heartbeatTask.cancel(true);
                        }
                        MessageViewFragment.this.heartbeatTask = new HeartbeatTask();
                        MessageViewFragment.this.heartbeatTask.execute(new Void[]{null});
                    }
                }
            }
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }
    };
    private JSONObject hiddenMap = null;
    private JSONObject expandMap = null;
    UnreadRefreshRunnable unreadRefreshRunnable = null;
    StatusRefreshRunnable statusRefreshRunnable = null;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(2130903098, container, false);
        this.statusView = (TextView)v.findViewById(2131624167);
        this.statusView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageViewFragment.this.buffer != null && MessageViewFragment.this.conn != null && MessageViewFragment.this.server != null && ((MessageViewFragment)MessageViewFragment.this).server.status != null && ((MessageViewFragment)MessageViewFragment.this).server.status.equalsIgnoreCase("disconnected")) {
                    MessageViewFragment.this.conn.reconnect(MessageViewFragment.this.buffer.cid);
                }
            }
        });
        this.awayView = v.findViewById(2131624135);
        this.awayView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MessageViewFragment.this.conn.back(MessageViewFragment.this.buffer.cid);
            }
        });
        this.awayTxt = (TextView)v.findViewById(2131624166);
        this.unreadBottomView = v.findViewById(2131624162);
        this.unreadBottomView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MessageViewFragment.this.getListView().setSelection(MessageViewFragment.this.adapter.getCount() - 1);
            }
        });
        this.unreadBottomLabel = (TextView)v.findViewById(2131624090);
        this.highlightsBottomLabel = (TextView)v.findViewById(2131624163);
        this.unreadTopView = v.findViewById(2131624158);
        this.unreadTopView.setVisibility(8);
        this.unreadTopView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageViewFragment.this.adapter.getLastSeenEIDPosition() > 0) {
                    if (MessageViewFragment.this.heartbeatTask != null) {
                        MessageViewFragment.this.heartbeatTask.cancel(true);
                    }
                    MessageViewFragment.this.heartbeatTask = new HeartbeatTask();
                    MessageViewFragment.this.heartbeatTask.execute(new Void[]{null});
                    MessageViewFragment.this.hideView(MessageViewFragment.this.unreadTopView);
                }
                MessageViewFragment.this.getListView().setSelection(MessageViewFragment.this.adapter.getLastSeenEIDPosition());
            }
        });
        this.unreadTopLabel = (TextView)v.findViewById(2131624160);
        this.highlightsTopLabel = (TextView)v.findViewById(2131624159);
        Button b = (Button)v.findViewById(2131624161);
        b.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MessageViewFragment.this.hideView(MessageViewFragment.this.unreadTopView);
                if (MessageViewFragment.this.heartbeatTask != null) {
                    MessageViewFragment.this.heartbeatTask.cancel(true);
                }
                MessageViewFragment.this.heartbeatTask = new HeartbeatTask();
                MessageViewFragment.this.heartbeatTask.execute(new Void[]{null});
            }
        });
        this.globalMsgView = v.findViewById(2131624156);
        this.globalMsg = (TextView)v.findViewById(2131624154);
        b = (Button)v.findViewById(2131624155);
        b.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageViewFragment.this.conn != null) {
                    ((MessageViewFragment)MessageViewFragment.this).conn.globalMsg = null;
                }
                MessageViewFragment.this.update_global_msg();
            }
        });
        ((ListView)v.findViewById(16908298)).setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> list, View v, int pos, long id2) {
                try {
                    MessageViewFragment.this.longPressOverride = MessageViewFragment.this.mListener.onMessageLongClicked((EventsDataSource.Event)list.getItemAtPosition(pos));
                    return MessageViewFragment.this.longPressOverride;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        this.spinner = (ProgressBar)v.findViewById(2131624037);
        this.suggestionsContainer = v.findViewById(2131624164);
        this.suggestions = (GridView)v.findViewById(2131624165);
        this.headerViewContainer = this.getLayoutInflater(null).inflate(2130903099, null);
        this.headerView = this.headerViewContainer.findViewById(2131624038);
        this.backlogFailed = (TextView)this.headerViewContainer.findViewById(2131624168);
        this.loadBacklogButton = (Button)this.headerViewContainer.findViewById(2131624169);
        this.loadBacklogButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageViewFragment.this.conn != null && MessageViewFragment.this.buffer != null) {
                    MessageViewFragment.this.backlogFailed.setVisibility(8);
                    MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                    MessageViewFragment.this.headerView.setVisibility(0);
                    MessageViewFragment.this.conn.request_backlog(MessageViewFragment.this.buffer.cid, MessageViewFragment.this.buffer.bid, MessageViewFragment.this.earliest_eid);
                }
            }
        });
        ((ListView)v.findViewById(16908298)).addHeaderView(this.headerViewContainer);
        return v;
    }

    public void showSpinner(boolean show) {
        if (show) {
            if (Build.VERSION.SDK_INT < 16) {
                AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
                anim2.setDuration(150L);
                anim2.setFillAfter(true);
                this.spinner.setAnimation((Animation)anim2);
            } else {
                this.spinner.setAlpha(0.0f);
                this.spinner.animate().alpha(1.0f);
            }
            this.spinner.setVisibility(0);
        } else if (Build.VERSION.SDK_INT < 16) {
            AlphaAnimation anim3 = new AlphaAnimation(1.0f, 0.0f);
            anim3.setDuration(150L);
            anim3.setFillAfter(true);
            anim3.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MessageViewFragment.this.spinner.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.spinner.setAnimation((Animation)anim3);
        } else {
            this.spinner.animate().alpha(0.0f).withEndAction(new Runnable(){

                @Override
                public void run() {
                    MessageViewFragment.this.spinner.setVisibility(8);
                }
            });
        }
    }

    private void hideView(final View v) {
        if (v.getVisibility() != 8) {
            if (Build.VERSION.SDK_INT >= 16) {
                v.animate().alpha(0.0f).setDuration(100L).withEndAction(new Runnable(){

                    @Override
                    public void run() {
                        v.setVisibility(8);
                    }
                });
            } else {
                v.setVisibility(8);
            }
        }
    }

    private void showView(View v) {
        if (v.getVisibility() != 0) {
            if (Build.VERSION.SDK_INT >= 16) {
                v.setAlpha(0.0f);
                v.animate().alpha(1.0f).setDuration(100L);
            }
            v.setVisibility(0);
        }
    }

    public void drawerClosed() {
        try {
            ListView v = this.getListView();
            this.mOnScrollListener.onScroll((AbsListView)v, v.getFirstVisiblePosition(), v.getLastVisiblePosition() - v.getFirstVisiblePosition(), this.adapter.getCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        tapTimer = new Timer("message-tap-timer");
        this.conn = NetworkConnection.getInstance();
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (MessageViewListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement MessageViewListener");
        }
    }

    @Override
    public void setArguments(Bundle args) {
        this.ready = false;
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel(true);
        }
        this.heartbeatTask = null;
        if (this.tapTimerTask != null) {
            this.tapTimerTask.cancel();
        }
        this.tapTimerTask = null;
        if (this.buffer != null && this.buffer.bid != args.getInt("bid", -1) && this.adapter != null) {
            this.adapter.clearLastSeenEIDMarker();
        }
        this.buffer = BuffersDataSource.getInstance().getBuffer(args.getInt("bid", -1));
        if (this.buffer != null) {
            this.server = ServersDataSource.getInstance().getServer(this.buffer.cid);
            Crashlytics.log(3, "IRCCloud", "MessageViewFragment: switched to bid: " + this.buffer.bid);
        } else {
            Crashlytics.log(5, "IRCCloud", "MessageViewFragment: couldn't find buffer to switch to");
        }
        this.requestingBacklog = false;
        this.avgInsertTime = 0.0f;
        this.newMsgs = 0;
        this.newMsgTime = 0L;
        this.newHighlights = 0;
        this.earliest_eid = 0L;
        this.backlog_eid = 0L;
        this.currentCollapsedEid = -1L;
        this.lastCollapsedDay = -1;
        if (this.server != null) {
            this.ignore.setIgnores(this.server.ignores);
            if (this.server.away != null && this.server.away.length() > 0) {
                this.awayTxt.setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)("Away (" + this.server.away + ")")))).toString());
                this.awayView.setVisibility(0);
            } else {
                this.awayView.setVisibility(8);
            }
            this.collapsedEvents.setServer(this.server);
            this.update_status(this.server.status, this.server.fail_info);
        }
        if (this.unreadTopView != null) {
            this.unreadTopView.setVisibility(8);
        }
        this.backlogFailed.setVisibility(8);
        this.loadBacklogButton.setVisibility(8);
        try {
            if (this.getListView().getHeaderViewsCount() == 0) {
                this.getListView().addHeaderView(this.headerViewContainer);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.headerView.getLayoutParams();
        lp.topMargin = 0;
        this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
        lp = (ViewGroup.MarginLayoutParams)this.backlogFailed.getLayoutParams();
        lp.topMargin = 0;
        this.backlogFailed.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (this.buffer != null && EventsDataSource.getInstance().getEventsForBuffer(this.buffer.bid) != null) {
            this.requestingBacklog = true;
            if (this.refreshTask != null) {
                this.refreshTask.cancel(true);
            }
            this.refreshTask = new RefreshTask();
            if (args.getBoolean("fade")) {
                Crashlytics.log(3, "IRCCloud", "MessageViewFragment: Loading message contents in the background");
                this.refreshTask.execute(new Void[]{null});
            } else {
                Crashlytics.log(3, "IRCCloud", "MessageViewFragment: Loading message contents");
                this.refreshTask.onPreExecute();
                this.refreshTask.onPostExecute(this.refreshTask.doInBackground(new Void[0]));
            }
        } else {
            if (this.buffer == null || this.buffer.min_eid == 0L || this.earliest_eid == this.buffer.min_eid || this.conn.getState() != 2 || !this.conn.ready) {
                this.headerView.setVisibility(8);
            } else {
                this.headerView.setVisibility(0);
            }
            if (this.adapter != null) {
                this.adapter.clear();
                this.adapter.notifyDataSetInvalidated();
            }
            this.mListener.onMessageViewReady();
            this.ready = true;
        }
    }

    private void runOnUiThread(Runnable r) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(r);
        }
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        Crashlytics.log(3, "IRCCloud", "Received low memory warning in the foreground, cleaning backlog in other buffers");
        for (BuffersDataSource.Buffer b : BuffersDataSource.getInstance().getBuffers()) {
            if (b == this.buffer) continue;
            EventsDataSource.getInstance().pruneEvents(b.bid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void insertEvent(final MessageAdapter adapter, EventsDataSource.Event event, boolean backlog, boolean nextIsGrouped) {
        Object object = this.adapterLock;
        synchronized (object) {
            try {
                int markerPos;
                String usermask;
                boolean colors = false;
                if (!event.self && this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null && this.conn.getUserInfo().prefs.has("nick-colors") && this.conn.getUserInfo().prefs.getBoolean("nick-colors")) {
                    colors = true;
                }
                long start = System.currentTimeMillis();
                if (event.eid <= this.buffer.min_eid) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.headerView.setVisibility(8);
                            MessageViewFragment.this.backlogFailed.setVisibility(8);
                            MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        }
                    });
                }
                if (this.earliest_eid == 0L || event.eid < this.earliest_eid) {
                    this.earliest_eid = event.eid;
                }
                String type = event.type;
                long eid = event.eid;
                if (type.startsWith("you_")) {
                    type = type.substring(4);
                }
                if (type.equals("joined_channel") || type.equals("parted_channel") || type.equals("nickchange") || type.equals("quit") || type.equals("user_channel_mode") || type.equals("socket_closed") || type.equals("connecting_cancelled") || type.equals("connecting_failed")) {
                    String msg;
                    EventsDataSource.Event last;
                    boolean shouldExpand = false;
                    boolean bl = this.collapsedEvents.showChan = !this.buffer.type.equals("channel");
                    if (this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null) {
                        if (this.hiddenMap == null) {
                            if (this.buffer.type.equals("channel")) {
                                if (this.conn.getUserInfo().prefs.has("channel-hideJoinPart")) {
                                    this.hiddenMap = this.conn.getUserInfo().prefs.getJSONObject("channel-hideJoinPart");
                                }
                            } else if (this.conn.getUserInfo().prefs.has("buffer-hideJoinPart")) {
                                this.hiddenMap = this.conn.getUserInfo().prefs.getJSONObject("buffer-hideJoinPart");
                            }
                        }
                        if (this.hiddenMap != null && this.hiddenMap.has(String.valueOf(this.buffer.bid)) && this.hiddenMap.getBoolean(String.valueOf(this.buffer.bid))) {
                            adapter.removeItem(event.eid);
                            if (!backlog) {
                                adapter.notifyDataSetChanged();
                            }
                            return;
                        }
                        if (this.expandMap == null) {
                            if (this.buffer.type.equals("channel")) {
                                if (this.conn.getUserInfo().prefs.has("channel-expandJoinPart")) {
                                    this.expandMap = this.conn.getUserInfo().prefs.getJSONObject("channel-expandJoinPart");
                                }
                            } else if (this.buffer.type.equals("console")) {
                                if (this.conn.getUserInfo().prefs.has("buffer-expandDisco")) {
                                    this.expandMap = this.conn.getUserInfo().prefs.getJSONObject("buffer-expandDisco");
                                }
                            } else if (this.conn.getUserInfo().prefs.has("buffer-expandJoinPart")) {
                                this.expandMap = this.conn.getUserInfo().prefs.getJSONObject("buffer-expandJoinPart");
                            }
                        }
                        if (this.expandMap != null && this.expandMap.has(String.valueOf(this.buffer.bid)) && this.expandMap.getBoolean(String.valueOf(this.buffer.bid))) {
                            shouldExpand = true;
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(eid / 1000L);
                    if (shouldExpand) {
                        this.expandedSectionEids.clear();
                    }
                    if (event.type.equals("socket_closed") || event.type.equals("connecting_failed") || event.type.equals("connecting_cancelled")) {
                        last = EventsDataSource.getInstance().getEvent(this.lastCollapsedEid, this.buffer.bid);
                        if (!(last == null || last.type.equals("socket_closed") || last.type.equals("connecting_failed") || last.type.equals("connecting_cancelled"))) {
                            this.currentCollapsedEid = -1L;
                        }
                    } else {
                        last = EventsDataSource.getInstance().getEvent(this.lastCollapsedEid, this.buffer.bid);
                        if (last != null && (last.type.equals("socket_closed") || last.type.equals("connecting_failed") || last.type.equals("connecting_cancelled"))) {
                            this.currentCollapsedEid = -1L;
                        }
                    }
                    if (this.currentCollapsedEid == -1L || calendar.get(6) != this.lastCollapsedDay || shouldExpand) {
                        this.collapsedEvents.clear();
                        this.currentCollapsedEid = eid;
                        this.lastCollapsedDay = calendar.get(6);
                    }
                    if (!this.collapsedEvents.showChan) {
                        event.chan = this.buffer.name;
                    }
                    if (!this.collapsedEvents.addEvent(event)) {
                        this.collapsedEvents.clear();
                    }
                    if ((this.currentCollapsedEid == event.eid || shouldExpand) && type.equals("user_channel_mode")) {
                        event.color = 2131492976;
                        event.bg_color = 2131492950;
                    } else {
                        event.color = 2131492956;
                        event.bg_color = 2131492930;
                    }
                    if (this.expandedSectionEids.contains(this.currentCollapsedEid)) {
                        CollapsedEventsList c = new CollapsedEventsList();
                        c.showChan = this.collapsedEvents.showChan;
                        c.setServer(this.server);
                        c.addEvent(event);
                        msg = c.getCollapsedMessage();
                        if (!nextIsGrouped) {
                            String group_msg = this.collapsedEvents.getCollapsedMessage();
                            if (group_msg == null && type.equals("nickchange")) {
                                group_msg = event.old_nick + " \u2192 <b>" + event.nick + "</b>";
                            }
                            if (group_msg == null && type.equals("user_channel_mode")) {
                                msg = event.from != null && event.from.length() > 0 ? this.collapsedEvents.formatNick(event.nick, event.target_mode, false) + " was set to <b>" + event.diff + "</b> by <b>" + this.collapsedEvents.formatNick(event.from, event.from_mode, false) + "</b>" : this.collapsedEvents.formatNick(event.nick, event.target_mode, false) + " was set to <b>" + event.diff + "</b> by the server <b>" + event.server + "</b>";
                                this.currentCollapsedEid = eid;
                            }
                            EventsDataSource.Event heading = new EventsDataSource.Event();
                            heading.type = "__expanded_group_heading__";
                            heading.cid = event.cid;
                            heading.bid = event.bid;
                            heading.eid = this.currentCollapsedEid - 1L;
                            heading.group_msg = group_msg;
                            heading.color = 2131492956;
                            heading.bg_color = 2131492930;
                            heading.linkify = false;
                            adapter.addItem(this.currentCollapsedEid - 1L, heading);
                            if (event.type.equals("socket_closed") || event.type.equals("connecting_failed") || event.type.equals("connecting_cancelled")) {
                                EventsDataSource.Event last2 = EventsDataSource.getInstance().getEvent(this.lastCollapsedEid, this.buffer.bid);
                                if (last2 != null) {
                                    last2.row_type = 0;
                                }
                                event.row_type = 3;
                            }
                        }
                        event.timestamp = null;
                    } else {
                        String string2 = msg = nextIsGrouped && this.currentCollapsedEid != event.eid ? "" : this.collapsedEvents.getCollapsedMessage();
                    }
                    if (msg == null && type.equals("nickchange")) {
                        msg = event.old_nick + " \u2192 <b>" + event.nick + "</b>";
                    }
                    if (msg == null && type.equals("user_channel_mode")) {
                        msg = event.from != null && event.from.length() > 0 ? this.collapsedEvents.formatNick(event.nick, event.target_mode, false) + " was set to <b>" + event.diff + "</b> by <b>" + this.collapsedEvents.formatNick(event.from, event.from_mode, false) + "</b>" : this.collapsedEvents.formatNick(event.nick, event.target_mode, false) + " was set to <b>" + event.diff + "</b> by the server <b>" + event.server + "</b>";
                        this.currentCollapsedEid = eid;
                    }
                    if (!this.expandedSectionEids.contains(this.currentCollapsedEid)) {
                        if (eid != this.currentCollapsedEid) {
                            event.color = 2131492956;
                            event.bg_color = 2131492930;
                        }
                        eid = this.currentCollapsedEid;
                    }
                    event.group_msg = msg;
                    event.html = null;
                    event.formatted = null;
                    event.linkify = false;
                    this.lastCollapsedEid = event.eid;
                    if (this.buffer.type.equals("console") && !event.type.equals("socket_closed") && !event.type.equals("connecting_failed") && !event.type.equals("connecting_cancelled")) {
                        this.currentCollapsedEid = -1L;
                        this.lastCollapsedEid = -1L;
                        this.collapsedEvents.clear();
                    }
                } else {
                    this.currentCollapsedEid = -1L;
                    this.lastCollapsedEid = -1L;
                    this.collapsedEvents.clear();
                    if (event.html == null) {
                        event.html = event.from != null && event.from.length() > 0 ? "<b>" + this.collapsedEvents.formatNick(event.from, event.from_mode, colors) + "</b> " + event.msg : (event.type.equals("buffer_msg") && event.server != null && event.server.length() > 0 ? "<b>" + event.server + "</b> " + event.msg : event.msg);
                    }
                }
                String from = event.from;
                if (from == null || from.length() == 0) {
                    from = event.nick;
                }
                if (from != null && event.hostmask != null && (type.equals("buffer_msg") || type.equals("buffer_me_msg") || type.equals("notice") || type.equals("channel_invite") || type.equals("callerid") || type.equals("wallops")) && this.buffer.type != null && !this.buffer.type.equals("conversation") && this.ignore.match(usermask = from + "!" + event.hostmask)) {
                    if (this.unreadTopView != null && this.unreadTopView.getVisibility() == 8 && this.unreadBottomView != null && this.unreadBottomView.getVisibility() == 8) {
                        if (this.heartbeatTask != null) {
                            this.heartbeatTask.cancel(true);
                        }
                        this.heartbeatTask = new HeartbeatTask();
                        this.heartbeatTask.execute(new Void[]{null});
                    }
                    return;
                }
                switch (type) {
                    case "channel_mode": {
                        if (event.nick != null && event.nick.length() > 0) {
                            event.html = event.msg + " by <b>" + this.collapsedEvents.formatNick(event.nick, event.from_mode, false) + "</b>";
                            break;
                        }
                        if (event.server == null || event.server.length() <= 0) break;
                        event.html = event.msg + " by the server <b>" + event.server + "</b>";
                        break;
                    }
                    case "buffer_me_msg": {
                        event.html = "\u2014 <i><b>" + this.collapsedEvents.formatNick(event.nick, event.from_mode, colors) + "</b> " + event.msg + "</i>";
                        break;
                    }
                    case "notice": {
                        event.html = event.from != null && event.from.length() > 0 ? "<b>" + this.collapsedEvents.formatNick(event.from, event.from_mode, false) + "</b> " : "";
                        if (this.buffer.type.equals("console") && event.to_chan && event.chan != null && event.chan.length() > 0) {
                            event.html = event.html + event.chan + "&#xfe55; " + event.msg;
                            break;
                        }
                        event.html = event.html + event.msg;
                        break;
                    }
                    case "kicked_channel": {
                        event.html = "\u2190 ";
                        event.html = event.type.startsWith("you_") ? event.html + "You" : event.html + "<b>" + this.collapsedEvents.formatNick(event.old_nick, null, false) + "</b>";
                        event.html = event.type.startsWith("you_") ? event.html + " were" : event.html + " was";
                        event.html = event.hostmask != null && event.hostmask.length() > 0 ? event.html + " kicked by <b>" + this.collapsedEvents.formatNick(event.nick, event.from_mode, false) + "</b> (" + event.hostmask + ")" : event.html + " kicked by the server <b>" + event.nick + "</b>";
                        if (event.msg == null || event.msg.length() <= 0) break;
                        event.html = event.html + ": " + event.msg;
                        break;
                    }
                    case "callerid": {
                        event.html = "<b>" + this.collapsedEvents.formatNick(event.from, event.from_mode, false) + "</b> (" + event.hostmask + ") " + event.msg + " Tap to accept.";
                        break;
                    }
                    case "channel_mode_list_change": {
                        if (event.from.length() != 0) break;
                        if (event.nick != null && event.nick.length() > 0) {
                            event.html = "<b>" + this.collapsedEvents.formatNick(event.nick, event.from_mode, false) + "</b> " + event.msg;
                            break;
                        }
                        if (event.server == null || event.server.length() <= 0) break;
                        event.html = "The server <b>" + event.server + "</b> " + event.msg;
                    }
                }
                adapter.addItem(eid, event);
                if (!backlog) {
                    adapter.notifyDataSetChanged();
                }
                long time = System.currentTimeMillis() - start;
                if (this.avgInsertTime == 0.0f) {
                    this.avgInsertTime = time;
                }
                this.avgInsertTime += (float)time;
                this.avgInsertTime = (float)((double)this.avgInsertTime / 2.0);
                if (!backlog && this.buffer.scrolledUp && !event.self && event.isImportant(type)) {
                    if (this.newMsgTime == 0L) {
                        this.newMsgTime = System.currentTimeMillis();
                    }
                    ++this.newMsgs;
                    if (event.highlight) {
                        ++this.newHighlights;
                    }
                    this.update_unread();
                    adapter.insertLastSeenEIDMarker();
                    adapter.notifyDataSetChanged();
                }
                if (!backlog && !this.buffer.scrolledUp) {
                    this.getListView().setSelection(adapter.getCount() - 1);
                    if (tapTimer != null) {
                        tapTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                MessageViewFragment.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            MessageViewFragment.this.getListView().setSelection(adapter.getCount() - 1);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        }, 200L);
                    }
                }
                if (!backlog && event.highlight && !this.getActivity().getSharedPreferences("prefs", 0).getBoolean("mentionTip", false)) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)"Double-tap a message to quickly reply to the sender", (int)1).show();
                    SharedPreferences.Editor editor = this.getActivity().getSharedPreferences("prefs", 0).edit();
                    editor.putBoolean("mentionTip", true);
                    editor.commit();
                }
                if (!backlog && (markerPos = adapter.getLastSeenEIDPosition()) > 0 && this.getListView().getFirstVisiblePosition() > markerPos) {
                    this.unreadTopLabel.setText((CharSequence)(this.getListView().getFirstVisiblePosition() - markerPos + " unread messages"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn.addHandler(this);
        this.getListView().requestFocus();
        this.getListView().setOnScrollListener(this.mOnScrollListener);
        this.update_global_msg();
        if (this.buffer != null && this.adapter != null && this.buffer.unread == 0 && !this.buffer.scrolledUp) {
            this.adapter.clearLastSeenEIDMarker();
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
        if (tapTimer != null) {
            tapTimer.cancel();
            tapTimer = null;
        }
        this.mListener = null;
        this.heartbeatTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh(MessageAdapter adapter, TreeMap<Long, EventsDataSource.Event> events) {
        Object object = this.adapterLock;
        synchronized (object) {
            try {
                ColorFormatter.file_uri_template = new URITemplate(NetworkConnection.getInstance().config.getString("file_uri_template"));
                ColorFormatter.pastebin_uri_template = new URITemplate(NetworkConnection.getInstance().config.getString("pastebin_uri_template"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.hiddenMap = null;
            this.expandMap = null;
            if (this.getActivity() != null) {
                this.textSize = PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity()).getInt("textSize", this.getActivity().getResources().getInteger(2131427330));
            }
            this.timestamp_width = -1;
            if (this.conn.getReconnectTimestamp() == 0L) {
                this.conn.cancel_idle_timer();
            }
            this.collapsedEvents.clear();
            this.currentCollapsedEid = -1L;
            this.lastCollapsedDay = -1;
            if (events == null || events.size() == 0 && this.buffer.min_eid > 0L) {
                if (this.buffer != null && this.conn != null && this.conn.getState() == 2) {
                    this.requestingBacklog = true;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.conn.request_backlog(MessageViewFragment.this.buffer.cid, MessageViewFragment.this.buffer.bid, 0L);
                        }
                    });
                } else {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.headerView.setVisibility(8);
                            MessageViewFragment.this.backlogFailed.setVisibility(8);
                            MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        }
                    });
                }
            } else if (events.size() > 0) {
                if (this.server != null) {
                    this.ignore.setIgnores(this.server.ignores);
                } else {
                    this.ignore.setIgnores(null);
                }
                this.collapsedEvents.setServer(this.server);
                this.earliest_eid = events.firstKey();
                if (events.firstKey() > this.buffer.min_eid && this.buffer.min_eid > 0L && this.conn != null && this.conn.getState() == 2) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.headerView.setVisibility(0);
                            MessageViewFragment.this.backlogFailed.setVisibility(8);
                            MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        }
                    });
                } else {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.headerView.setVisibility(8);
                            MessageViewFragment.this.backlogFailed.setVisibility(8);
                            MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        }
                    });
                }
                if (events.size() > 0) {
                    this.avgInsertTime = 0.0f;
                    long start = System.currentTimeMillis();
                    Iterator<EventsDataSource.Event> i = events.values().iterator();
                    EventsDataSource.Event next = i.next();
                    Calendar calendar = Calendar.getInstance();
                    while (next != null) {
                        String type;
                        EventsDataSource.Event e = next;
                        next = i.hasNext() ? i.next() : null;
                        String string2 = type = next == null ? "" : next.type;
                        if (next != null && this.currentCollapsedEid != -1L && !this.expandedSectionEids.contains(this.currentCollapsedEid) && (type.equalsIgnoreCase("joined_channel") || type.equalsIgnoreCase("parted_channel") || type.equalsIgnoreCase("nickchange") || type.equalsIgnoreCase("quit") || type.equalsIgnoreCase("user_channel_mode"))) {
                            calendar.setTimeInMillis(next.eid / 1000L);
                            this.insertEvent(adapter, e, true, calendar.get(6) == this.lastCollapsedDay);
                            continue;
                        }
                        this.insertEvent(adapter, e, true, false);
                    }
                    adapter.insertLastSeenEIDMarker();
                    Log.i((String)"IRCCloud", (String)("Backlog rendering took: " + (System.currentTimeMillis() - start) + "ms"));
                    this.avgInsertTime = 0.0f;
                }
            }
            if (this.conn.getReconnectTimestamp() == 0L && this.conn.getState() == 2) {
                this.conn.schedule_idle_timer();
            }
        }
    }

    private void update_top_unread(int first) {
        if (this.adapter != null) {
            try {
                int markerPos = this.adapter.getLastSeenEIDPosition();
                if (markerPos >= 0 && first > markerPos + 1 && this.buffer.unread > 0) {
                    if (this.shouldTrackUnread()) {
                        int highlights = this.adapter.getUnreadHighlightsAbovePosition(first);
                        int count = first - markerPos - 1 - highlights;
                        StringBuilder txt = new StringBuilder();
                        if (highlights > 0) {
                            if (highlights == 1) {
                                txt.append("mention");
                            } else if (highlights > 0) {
                                txt.append("mentions");
                            }
                            this.highlightsTopLabel.setText((CharSequence)String.valueOf(highlights));
                            this.highlightsTopLabel.setVisibility(0);
                            if (count > 0) {
                                txt.append(" and ");
                            }
                        } else {
                            this.highlightsTopLabel.setVisibility(8);
                        }
                        if (markerPos == 0) {
                            long seconds = (long)Math.ceil((double)(this.earliest_eid - this.buffer.last_seen_eid) / 1000000.0);
                            if (seconds < 0L) {
                                if (count < 0) {
                                    this.hideView(this.unreadTopView);
                                    return;
                                }
                                if (count == 1) {
                                    txt.append(count).append(" unread message");
                                } else if (count > 0) {
                                    txt.append(count).append(" unread messages");
                                }
                            } else {
                                int minutes = (int)Math.ceil((double)seconds / 60.0);
                                int hours = (int)Math.ceil((double)seconds / 60.0 / 60.0);
                                int days = (int)Math.ceil((double)seconds / 60.0 / 60.0 / 24.0);
                                if (hours >= 24) {
                                    if (days == 1) {
                                        txt.append(days).append(" day of unread messages");
                                    } else {
                                        txt.append(days).append(" days of unread messages");
                                    }
                                } else if (hours > 0) {
                                    if (hours == 1) {
                                        txt.append(hours).append(" hour of unread messages");
                                    } else {
                                        txt.append(hours).append(" hours of unread messages");
                                    }
                                } else if (minutes > 0) {
                                    if (minutes == 1) {
                                        txt.append(minutes).append(" minute of unread messages");
                                    } else {
                                        txt.append(minutes).append(" minutes of unread messages");
                                    }
                                } else if (seconds == 1L) {
                                    txt.append(seconds).append(" second of unread messages");
                                } else {
                                    txt.append(seconds).append(" seconds of unread messages");
                                }
                            }
                        } else if (count == 1) {
                            txt.append(count).append(" unread message");
                        } else if (count > 0) {
                            txt.append(count).append(" unread messages");
                        }
                        this.unreadTopLabel.setText((CharSequence)txt);
                        this.showView(this.unreadTopView);
                    } else {
                        this.hideView(this.unreadTopView);
                    }
                } else if (markerPos > 0) {
                    this.hideView(this.unreadTopView);
                    if (this.adapter.data.size() > 0 && this.ready) {
                        if (this.heartbeatTask != null) {
                            this.heartbeatTask.cancel(true);
                        }
                        this.heartbeatTask = new HeartbeatTask();
                        this.heartbeatTask.execute(new Void[]{null});
                    }
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldTrackUnread() {
        if (this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null && this.conn.getUserInfo().prefs.has("channel-disableTrackUnread")) {
            try {
                JSONObject disabledMap = this.conn.getUserInfo().prefs.getJSONObject("channel-disableTrackUnread");
                if (disabledMap.has(String.valueOf(this.buffer.bid)) && disabledMap.getBoolean(String.valueOf(this.buffer.bid))) {
                    return false;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void update_unread() {
        if (this.unreadRefreshRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.unreadRefreshRunnable);
            this.unreadRefreshRunnable = null;
        }
        if (this.newMsgs > 0) {
            String txt = "";
            int msgCnt = this.newMsgs - this.newHighlights;
            if (this.newHighlights > 0) {
                txt = this.newHighlights == 1 ? "mention" : "mentions";
                if (msgCnt > 0) {
                    txt = txt + " and ";
                }
                this.highlightsBottomLabel.setText((CharSequence)String.valueOf(this.newHighlights));
                this.highlightsBottomLabel.setVisibility(0);
            } else {
                this.highlightsBottomLabel.setVisibility(8);
            }
            if (msgCnt == 1) {
                txt = txt + msgCnt + " unread message";
            } else if (msgCnt > 0) {
                txt = txt + msgCnt + " unread messages";
            }
            this.unreadBottomLabel.setText((CharSequence)txt);
            this.showView(this.unreadBottomView);
            this.unreadRefreshRunnable = new UnreadRefreshRunnable();
            this.mHandler.postDelayed((Runnable)this.unreadRefreshRunnable, 10000L);
        }
    }

    public static String ordinal(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + sufixes[i % 10];
    }

    private String reason_txt(String reason) {
        String r = reason;
        switch (reason.toLowerCase()) {
            case "pool_lost": {
                r = "Connection pool failed";
            }
            case "no_pool": {
                r = "No available connection pools";
                break;
            }
            case "enetdown": {
                r = "Network down";
                break;
            }
            case "etimedout": 
            case "timeout": {
                r = "Timed out";
                break;
            }
            case "ehostunreach": {
                r = "Host unreachable";
                break;
            }
            case "econnrefused": {
                r = "Connection refused";
                break;
            }
            case "nxdomain": 
            case "einval": {
                r = "Invalid hostname";
                break;
            }
            case "server_ping_timeout": {
                r = "PING timeout";
                break;
            }
            case "ssl_certificate_error": {
                r = "SSL certificate error";
                break;
            }
            case "ssl_error": {
                r = "SSL error";
                break;
            }
            case "crash": {
                r = "Connection crashed";
                break;
            }
            case "networks": {
                r = "You've exceeded the connection limit for free accounts.";
                break;
            }
            case "passworded_servers": {
                r = "You can't connect to passworded servers with free accounts.";
                break;
            }
            case "unverified": {
                r = "You can\u2019t connect to external servers until you confirm your email address.";
            }
        }
        return r;
    }

    private void update_status(String status, JsonNode fail_info) {
        if (this.statusRefreshRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.statusRefreshRunnable);
            this.statusRefreshRunnable = null;
        }
        switch (status) {
            case "connected_ready": {
                if (this.server != null && this.server.lag >= 2000000L) {
                    this.statusView.setVisibility(0);
                    this.statusView.setText((CharSequence)("Slow ping response from " + this.server.hostname + " (" + this.server.lag / 1000L / 1000L + "s)"));
                    break;
                }
                this.statusView.setVisibility(8);
                this.statusView.setText((CharSequence)"");
                break;
            }
            case "quitting": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Disconnecting");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "disconnected": {
                this.statusView.setVisibility(0);
                if (fail_info.has("type") && fail_info.get("type").asText().length() > 0) {
                    String text = "Disconnected: ";
                    if (fail_info.get("type").asText().equals("connecting_restricted")) {
                        text = this.reason_txt(fail_info.get("reason").asText());
                        if (text.equals(fail_info.get("reason").asText())) {
                            text = "You can\u2019t connect to this server with a free account.";
                        }
                    } else if (fail_info.get("type").asText().equals("connection_blocked")) {
                        text = "Disconnected - Connections to this server have been blocked";
                    } else {
                        if (fail_info.has("type") && fail_info.get("type").asText().equals("killed")) {
                            text = "Disconnected - Killed: ";
                        } else if (fail_info.has("type") && fail_info.get("type").asText().equals("connecting_failed")) {
                            text = "Disconnected: Failed to connect - ";
                        }
                        if (fail_info.has("reason")) {
                            text = text + this.reason_txt(fail_info.get("reason").asText());
                        }
                    }
                    this.statusView.setText((CharSequence)text);
                    this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492951));
                    this.statusView.setBackgroundResource(2130837733);
                    break;
                }
                this.statusView.setText((CharSequence)"Disconnected. Tap to reconnect.");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "queued": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Connection queued");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "connecting": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Connecting");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "connected": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Connected");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "connected_joining": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Connected: Joining Channels");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
                break;
            }
            case "pool_unavailable": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Connection temporarily unavailable");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492951));
                this.statusView.setBackgroundResource(2130837733);
                break;
            }
            case "waiting_to_retry": {
                try {
                    this.statusView.setVisibility(0);
                    long seconds = fail_info.get("timestamp").asLong() + fail_info.get("retry_timeout").asLong() - this.conn.clockOffset - System.currentTimeMillis() / 1000L;
                    if (seconds > 0L) {
                        String text = "Disconnected";
                        if (fail_info.has("reason") && fail_info.get("reason").asText().length() > 0) {
                            String reason = fail_info.get("reason").asText();
                            reason = this.reason_txt(reason);
                            text = text + ": " + reason + ". ";
                        } else {
                            text = text + "; ";
                        }
                        text = text + "Reconnecting in ";
                        int minutes = (int)((double)seconds / 60.0);
                        int hours = (int)((double)seconds / 60.0 / 60.0);
                        int days = (int)((double)seconds / 60.0 / 60.0 / 24.0);
                        text = days > 0 ? (days == 1 ? text + days + " day." : text + days + " days.") : (hours > 0 ? (hours == 1 ? text + hours + " hour." : text + hours + " hours.") : (minutes > 0 ? (minutes == 1 ? text + minutes + " minute." : text + minutes + " minutes.") : (seconds == 1L ? text + seconds + " second." : text + seconds + " seconds.")));
                        int attempts = fail_info.get("attempts").asInt();
                        if (attempts > 1) {
                            text = text + " (" + MessageViewFragment.ordinal(attempts) + " attempt)";
                        }
                        this.statusView.setText((CharSequence)text);
                        this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492951));
                        this.statusView.setBackgroundResource(2130837733);
                        this.statusRefreshRunnable = new StatusRefreshRunnable(status, fail_info);
                    } else {
                        this.statusView.setVisibility(0);
                        this.statusView.setText((CharSequence)"Ready to connect, waiting our turn\u2026");
                        this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                        this.statusView.setBackgroundResource(2130837714);
                    }
                    this.mHandler.postDelayed((Runnable)this.statusRefreshRunnable, 500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "ip_retry": {
                this.statusView.setVisibility(0);
                this.statusView.setText((CharSequence)"Trying another IP address");
                this.statusView.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492899));
                this.statusView.setBackgroundResource(2130837714);
            }
        }
    }

    private void update_global_msg() {
        if (this.globalMsgView != null) {
            if (this.conn != null && this.conn.globalMsg != null) {
                this.globalMsg.setText((CharSequence)Html.fromHtml((String)this.conn.globalMsg));
                this.globalMsgView.setVisibility(0);
            } else {
                this.globalMsgView.setVisibility(8);
            }
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.statusRefreshRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.statusRefreshRunnable);
            this.statusRefreshRunnable = null;
        }
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
        try {
            this.getListView().setOnScrollListener(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ready = false;
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 102: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageViewFragment.this.headerView.setVisibility(8);
                        MessageViewFragment.this.backlogFailed.setVisibility(0);
                        MessageViewFragment.this.loadBacklogButton.setVisibility(0);
                    }
                });
                break;
            }
            case 0: 
            case 1: 
            case 101: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageViewFragment.this.refreshTask != null) {
                            MessageViewFragment.this.refreshTask.cancel(true);
                        }
                        MessageViewFragment.this.refreshTask = new RefreshTask();
                        MessageViewFragment.this.refreshTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 38: {
                try {
                    IRCCloudJSONObject object = (IRCCloudJSONObject)obj;
                    if (this.server == null || this.buffer == null || object.cid() != this.buffer.cid) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.update_status(((MessageViewFragment)MessageViewFragment.this).server.status, ((MessageViewFragment)MessageViewFragment.this).server.fail_info);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 18: {
                try {
                    final IRCCloudJSONObject object = (IRCCloudJSONObject)obj;
                    if (this.buffer == null || object.cid() != this.buffer.cid) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.update_status(object.getString("new_status"), object.getJsonObject("fail_info"));
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 27: {
                IRCCloudJSONObject e = (IRCCloudJSONObject)obj;
                if (this.buffer == null || e.cid() != this.buffer.cid) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageViewFragment.this.refreshTask != null) {
                            MessageViewFragment.this.refreshTask.cancel(true);
                        }
                        MessageViewFragment.this.refreshTask = new RefreshTask();
                        MessageViewFragment.this.refreshTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 6: {
                try {
                    if (this.buffer == null || this.adapter == null || this.adapter.data.size() <= 0 || this.buffer.last_seen_eid != this.adapter.data.get((int)(this.adapter.data.size() - 1)).eid && this.shouldTrackUnread()) break;
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.hideView(MessageViewFragment.this.unreadTopView);
                        }
                    });
                }
                catch (Exception ex) {}
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                IRCCloudJSONObject e = (IRCCloudJSONObject)obj;
                if (this.buffer == null || e.bid() != this.buffer.bid) break;
                final EventsDataSource.Event event = EventsDataSource.getInstance().getEvent(e.eid(), e.bid());
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageViewFragment.this.adapter != null) {
                            MessageViewFragment.this.insertEvent(MessageViewFragment.this.adapter, event, false, false);
                        }
                    }
                });
                break;
            }
            case 5: {
                BuffersDataSource.Buffer b;
                final EventsDataSource.Event event = (EventsDataSource.Event)obj;
                if (this.buffer != null && event.bid == this.buffer.bid) {
                    if (event.from != null && event.from.equalsIgnoreCase(this.buffer.name) && event.reqid == -1) {
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageViewFragment.this.adapter != null) {
                                    MessageViewFragment.this.adapter.clearPending();
                                }
                            }
                        });
                    } else if (event.reqid != -1) {
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageViewFragment.this.adapter != null && ((MessageViewFragment)MessageViewFragment.this).adapter.data != null) {
                                    for (int i = 0; i < ((MessageViewFragment)MessageViewFragment.this).adapter.data.size(); ++i) {
                                        EventsDataSource.Event e = ((MessageViewFragment)MessageViewFragment.this).adapter.data.get(i);
                                        if (e.reqid != event.reqid || !e.pending) continue;
                                        if (i > 0) {
                                            EventsDataSource.Event p = ((MessageViewFragment)MessageViewFragment.this).adapter.data.get(i - 1);
                                            if (p.row_type == 1) {
                                                ((MessageViewFragment)MessageViewFragment.this).adapter.data.remove(p);
                                                --i;
                                            }
                                        }
                                        ((MessageViewFragment)MessageViewFragment.this).adapter.data.remove(e);
                                        --i;
                                    }
                                }
                            }
                        });
                    }
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MessageViewFragment.this.insertEvent(MessageViewFragment.this.adapter, event, false, false);
                        }
                    });
                    if (event.pending && event.self && this.adapter != null && this.getListView() != null) {
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                MessageViewFragment.this.getListView().setSelection(MessageViewFragment.this.adapter.getCount() - 1);
                            }
                        });
                    }
                }
                if ((b = BuffersDataSource.getInstance().getBuffer(event.bid)) == null || b.scrolledUp || EventsDataSource.getInstance().getSizeOfBuffer(b.bid) <= 200) break;
                EventsDataSource.getInstance().pruneEvents(b.bid);
                if (this.buffer == null || b.bid != this.buffer.bid) break;
                if (b.last_seen_eid < event.eid && this.unreadTopView.getVisibility() == 8) {
                    b.last_seen_eid = event.eid;
                }
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageViewFragment.this.refreshTask != null) {
                            MessageViewFragment.this.refreshTask.cancel(true);
                        }
                        MessageViewFragment.this.refreshTask = new RefreshTask();
                        MessageViewFragment.this.refreshTask.execute(new Void[]{null});
                    }
                });
                break;
            }
            case 20: 
            case 21: {
                if (this.server == null) break;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (((MessageViewFragment)MessageViewFragment.this).server.away != null && ((MessageViewFragment)MessageViewFragment.this).server.away.length() > 0) {
                            MessageViewFragment.this.awayTxt.setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)("Away (" + ((MessageViewFragment)MessageViewFragment.this).server.away + ")")))).toString());
                            MessageViewFragment.this.awayView.setVisibility(0);
                        } else {
                            MessageViewFragment.this.awayView.setVisibility(8);
                        }
                    }
                });
                break;
            }
            case 39: {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageViewFragment.this.update_global_msg();
                    }
                });
                break;
            }
        }
    }

    public static Resources getSafeResources() {
        return IRCCloudApplication.getInstance().getApplicationContext().getResources();
    }

    public static interface MessageViewListener
    extends BuffersListFragment.OnBufferSelectedListener {
        public void onMessageViewReady();

        public boolean onMessageLongClicked(EventsDataSource.Event var1);

        public void onMessageDoubleClicked(EventsDataSource.Event var1);

        public void onFailedMessageClicked(EventsDataSource.Event var1);
    }

    private class StatusRefreshRunnable
    implements Runnable {
        String status;
        JsonNode fail_info;

        public StatusRefreshRunnable(String status, JsonNode fail_info) {
            this.status = status;
            this.fail_info = fail_info;
        }

        @Override
        public void run() {
            MessageViewFragment.this.update_status(this.status, this.fail_info);
        }
    }

    private class UnreadRefreshRunnable
    implements Runnable {
        private UnreadRefreshRunnable() {
        }

        @Override
        public void run() {
            MessageViewFragment.this.update_unread();
        }
    }

    private class RefreshTask
    extends AsyncTaskEx<Void, Void, Void> {
        private MessageAdapter adapter;
        TreeMap<Long, EventsDataSource.Event> events;
        BuffersDataSource.Buffer buffer;
        int oldPosition = -1;
        int topOffset = -1;

        private RefreshTask() {
        }

        @Override
        protected void onPreExecute() {
            try {
                this.oldPosition = MessageViewFragment.this.getListView().getFirstVisiblePosition();
                View v = MessageViewFragment.this.getListView().getChildAt(0);
                this.topOffset = v == null ? 0 : v.getTop();
                this.buffer = MessageViewFragment.this.buffer;
            }
            catch (IllegalStateException e) {
                this.cancel(true);
                MessageViewFragment.this.refreshTask = null;
            }
        }

        protected Void doInBackground(Void ... params) {
            TreeMap<Long, EventsDataSource.Event> evs = null;
            long time = System.currentTimeMillis();
            if (this.buffer != null) {
                evs = EventsDataSource.getInstance().getEventsForBuffer(this.buffer.bid);
            }
            Log.i((String)"IRCCloud", (String)("Loaded data in " + (System.currentTimeMillis() - time) + "ms"));
            if (!this.isCancelled() && evs != null && evs.size() > 0) {
                try {
                    this.events = (TreeMap)evs.clone();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                if (this.isCancelled()) {
                    return null;
                }
                if (this.events != null) {
                    try {
                        if (this.events.size() > 0 && MessageViewFragment.this.adapter != null && ((MessageViewFragment)MessageViewFragment.this).adapter.data.size() > 0 && MessageViewFragment.this.earliest_eid > this.events.firstKey()) {
                            if (this.oldPosition > 0 && this.oldPosition == ((MessageViewFragment)MessageViewFragment.this).adapter.data.size()) {
                                --this.oldPosition;
                            }
                            if ((e = ((MessageViewFragment)MessageViewFragment.this).adapter.data.get(this.oldPosition)) != null) {
                                MessageViewFragment.this.backlog_eid = e.group_eid - 1L;
                            } else {
                                MessageViewFragment.this.backlog_eid = -1L;
                            }
                            if (MessageViewFragment.this.backlog_eid < 0L) {
                                MessageViewFragment.this.backlog_eid = MessageViewFragment.this.adapter.getItemId(this.oldPosition) - 1L;
                            }
                            EventsDataSource.Event backlogMarker = new EventsDataSource.Event();
                            backlogMarker.eid = MessageViewFragment.this.backlog_eid;
                            backlogMarker.type = MessageViewFragment.TYPE_BACKLOGMARKER;
                            backlogMarker.row_type = 2;
                            backlogMarker.html = MessageViewFragment.TYPE_BACKLOGMARKER;
                            backlogMarker.bg_color = 2131492930;
                            this.events.put(MessageViewFragment.this.backlog_eid, backlogMarker);
                        }
                        this.adapter = new MessageAdapter(MessageViewFragment.this);
                        MessageViewFragment.this.refresh(this.adapter, this.events);
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                        Log.e((String)"IRCCloud", (String)"Tried to refresh the message list, but it didn't exist.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            } else if (this.buffer != null && this.buffer.min_eid > 0L && ((MessageViewFragment)MessageViewFragment.this).conn.ready && MessageViewFragment.this.conn.getState() == 2 && !this.isCancelled()) {
                MessageViewFragment.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageViewFragment.this.headerView.setVisibility(0);
                        MessageViewFragment.this.backlogFailed.setVisibility(8);
                        MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        RefreshTask.this.adapter = new MessageAdapter(MessageViewFragment.this);
                        MessageViewFragment.this.setListAdapter((ListAdapter)RefreshTask.this.adapter);
                        MessageViewFragment.this.adapter = RefreshTask.this.adapter;
                        MessageViewFragment.this.requestingBacklog = true;
                        MessageViewFragment.this.conn.request_backlog(RefreshTask.this.buffer.cid, RefreshTask.this.buffer.bid, 0L);
                    }
                });
            } else {
                MessageViewFragment.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MessageViewFragment.this.headerView.setVisibility(8);
                        MessageViewFragment.this.backlogFailed.setVisibility(8);
                        MessageViewFragment.this.loadBacklogButton.setVisibility(8);
                        RefreshTask.this.adapter = new MessageAdapter(MessageViewFragment.this);
                        MessageViewFragment.this.setListAdapter((ListAdapter)RefreshTask.this.adapter);
                        MessageViewFragment.this.adapter = RefreshTask.this.adapter;
                    }
                });
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (!this.isCancelled() && this.adapter != null) {
                try {
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)MessageViewFragment.this.headerView.getLayoutParams();
                    lp.topMargin = this.adapter.getLastSeenEIDPosition() == 0 ? (int)MessageViewFragment.getSafeResources().getDimension(2131230821) : 0;
                    MessageViewFragment.this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    lp = (ViewGroup.MarginLayoutParams)MessageViewFragment.this.backlogFailed.getLayoutParams();
                    lp.topMargin = this.adapter.getLastSeenEIDPosition() == 0 ? (int)MessageViewFragment.getSafeResources().getDimension(2131230821) : 0;
                    MessageViewFragment.this.backlogFailed.setLayoutParams((ViewGroup.LayoutParams)lp);
                    MessageViewFragment.this.setListAdapter((ListAdapter)this.adapter);
                    MessageViewFragment.this.adapter = this.adapter;
                    if (this.events != null && this.events.size() > 0) {
                        int markerPos = this.adapter.getBacklogMarkerPosition();
                        if (markerPos != -1 && MessageViewFragment.this.requestingBacklog) {
                            MessageViewFragment.this.getListView().setSelectionFromTop(this.oldPosition + markerPos + 1, MessageViewFragment.this.headerViewContainer.getHeight());
                        } else if (!this.buffer.scrolledUp) {
                            MessageViewFragment.this.getListView().setSelection(this.adapter.getCount() - 1);
                        } else {
                            MessageViewFragment.this.getListView().setSelectionFromTop(this.buffer.scrollPosition, this.buffer.scrollPositionOffset);
                            if (this.adapter.getLastSeenEIDPosition() > this.buffer.scrollPosition) {
                                MessageViewFragment.this.newMsgs = 0;
                                MessageViewFragment.this.newHighlights = 0;
                                for (int i = this.adapter.data.size() - 1; i >= 0; --i) {
                                    EventsDataSource.Event e = this.adapter.data.get(i);
                                    if (e.eid <= this.buffer.last_seen_eid) break;
                                    if (!e.isImportant(this.buffer.type)) continue;
                                    if (e.highlight) {
                                        MessageViewFragment.this.newHighlights++;
                                        continue;
                                    }
                                    MessageViewFragment.this.newMsgs++;
                                }
                            }
                            MessageViewFragment.this.update_unread();
                        }
                    }
                    new FormatTask().execute(new Void[]{null});
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                MessageViewFragment.this.refreshTask = null;
                MessageViewFragment.this.requestingBacklog = false;
                MessageViewFragment.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageViewFragment.this.update_top_unread(MessageViewFragment.this.getListView().getFirstVisiblePosition());
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        if (MessageViewFragment.this.server != null) {
                            MessageViewFragment.this.update_status(((MessageViewFragment)MessageViewFragment.this).server.status, ((MessageViewFragment)MessageViewFragment.this).server.fail_info);
                        }
                        if (MessageViewFragment.this.mListener != null && !MessageViewFragment.this.ready) {
                            MessageViewFragment.this.mListener.onMessageViewReady();
                        }
                        MessageViewFragment.this.ready = true;
                        try {
                            ListView v = MessageViewFragment.this.getListView();
                            MessageViewFragment.this.mOnScrollListener.onScroll((AbsListView)v, v.getFirstVisiblePosition(), v.getLastVisiblePosition() - v.getFirstVisiblePosition(), RefreshTask.this.adapter.getCount());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 250L);
            }
        }
    }

    private class FormatTask
    extends AsyncTaskEx<Void, Void, Void> {
        private FormatTask() {
        }

        @Override
        protected void onPreExecute() {
        }

        protected Void doInBackground(Void ... params) {
            MessageViewFragment.this.adapter.format();
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
        }
    }

    private class HeartbeatTask
    extends AsyncTaskEx<Void, Void, Void> {
        BuffersDataSource.Buffer b;

        public HeartbeatTask() {
            this.b = MessageViewFragment.this.buffer;
        }

        protected Void doInBackground(Void ... params) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isCancelled() || !((MessageViewFragment)MessageViewFragment.this).conn.ready || MessageViewFragment.this.conn.getState() != 2 || this.b == null || !MessageViewFragment.this.ready || MessageViewFragment.this.requestingBacklog) {
                return null;
            }
            if (MessageViewFragment.this.getActivity() != null) {
                try {
                    DrawerLayout drawerLayout = (DrawerLayout)MessageViewFragment.this.getActivity().findViewById(2131624069);
                    if (drawerLayout != null && (drawerLayout.isDrawerOpen(3) || drawerLayout.isDrawerOpen(5))) {
                        return null;
                    }
                }
                catch (Exception drawerLayout) {
                    // empty catch block
                }
            }
            if (MessageViewFragment.this.unreadTopView.getVisibility() == 0 || MessageViewFragment.this.unreadBottomView.getVisibility() == 0) {
                return null;
            }
            try {
                Long eid;
                TreeMap<Long, EventsDataSource.Event> events = EventsDataSource.getInstance().getEventsForBuffer(MessageViewFragment.this.buffer.bid);
                if (events != null && events.size() > 0 && (eid = Long.valueOf(events.get((Object)events.lastKey()).eid)) >= this.b.last_seen_eid && MessageViewFragment.this.conn != null && MessageViewFragment.this.conn.getState() == 2) {
                    if (MessageViewFragment.this.getActivity() != null && MessageViewFragment.this.getActivity().getIntent() != null) {
                        MessageViewFragment.this.getActivity().getIntent().putExtra("last_seen_eid", (Serializable)eid);
                    }
                    NetworkConnection.getInstance().heartbeat(this.b.cid, this.b.bid, eid);
                    BuffersDataSource.getInstance().updateLastSeenEid(this.b.bid, eid);
                    this.b.unread = 0;
                    this.b.highlights = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (!this.isCancelled()) {
                MessageViewFragment.this.heartbeatTask = null;
            }
        }
    }

    private class OnItemClickListener
    implements View.OnClickListener {
        private int pos;

        OnItemClickListener(int position) {
            this.pos = position;
        }

        public void onClick(View arg0) {
            MessageViewFragment.this.longPressOverride = false;
            if (this.pos < 0 || this.pos >= ((MessageViewFragment)MessageViewFragment.this).adapter.data.size()) {
                return;
            }
            if (MessageViewFragment.this.adapter != null && tapTimer != null) {
                if (MessageViewFragment.this.tapTimerTask != null) {
                    MessageViewFragment.this.tapTimerTask.cancel();
                    MessageViewFragment.this.tapTimerTask = null;
                    MessageViewFragment.this.mListener.onMessageDoubleClicked(((MessageViewFragment)MessageViewFragment.this).adapter.data.get(this.pos));
                } else {
                    MessageViewFragment.this.tapTimerTask = new TimerTask(){
                        int position;
                        {
                            this.position = OnItemClickListener.this.pos;
                        }

                        @Override
                        public void run() {
                            MessageViewFragment.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    EventsDataSource.Event e;
                                    if (MessageViewFragment.this.adapter != null && ((MessageViewFragment)MessageViewFragment.this).adapter.data != null && position < ((MessageViewFragment)MessageViewFragment.this).adapter.data.size() && (e = ((MessageViewFragment)MessageViewFragment.this).adapter.data.get(position)) != null) {
                                        if (e.type.equals("channel_invite")) {
                                            MessageViewFragment.this.conn.join(MessageViewFragment.this.buffer.cid, e.old_nick, null);
                                        } else if (e.type.equals("callerid")) {
                                            MessageViewFragment.this.conn.say(MessageViewFragment.this.buffer.cid, null, "/accept " + e.from);
                                            BuffersDataSource.Buffer b = BuffersDataSource.getInstance().getBufferByName(MessageViewFragment.this.buffer.cid, e.from);
                                            if (b != null) {
                                                MessageViewFragment.this.mListener.onBufferSelected(b.bid);
                                            } else {
                                                MessageViewFragment.this.conn.say(MessageViewFragment.this.buffer.cid, null, "/query " + e.from);
                                            }
                                        } else if (e.failed) {
                                            MessageViewFragment.this.mListener.onFailedMessageClicked(e);
                                        } else {
                                            long group = e.group_eid;
                                            if (MessageViewFragment.this.expandedSectionEids.contains(group)) {
                                                MessageViewFragment.this.expandedSectionEids.remove(group);
                                            } else if (e.eid != group) {
                                                MessageViewFragment.this.expandedSectionEids.add(group);
                                            }
                                            if (e.eid != e.group_eid) {
                                                MessageViewFragment.this.adapter.clearLastSeenEIDMarker();
                                                if (MessageViewFragment.this.refreshTask != null) {
                                                    MessageViewFragment.this.refreshTask.cancel(true);
                                                }
                                                MessageViewFragment.this.refreshTask = new RefreshTask();
                                                MessageViewFragment.this.refreshTask.execute(new Void[]{null});
                                            }
                                        }
                                    }
                                }
                            });
                            MessageViewFragment.this.tapTimerTask = null;
                        }
                    };
                    tapTimer.schedule(MessageViewFragment.this.tapTimerTask, 300L);
                }
            }
        }
    }

    private class MessageAdapter
    extends BaseAdapter {
        ArrayList<EventsDataSource.Event> data;
        private ListFragment ctx;
        private long max_eid = 0L;
        private long min_eid = 0L;
        private int lastDay = -1;
        private int lastSeenEidMarkerPosition = -1;
        private int currentGroupPosition = -1;
        private TreeSet<Integer> unseenHighlightPositions;

        public MessageAdapter(ListFragment context) {
            this.ctx = context;
            this.data = new ArrayList();
            this.unseenHighlightPositions = new TreeSet(Collections.reverseOrder());
        }

        public void clear() {
            this.max_eid = 0L;
            this.min_eid = 0L;
            this.lastDay = -1;
            this.lastSeenEidMarkerPosition = -1;
            this.currentGroupPosition = -1;
            this.data.clear();
            this.unseenHighlightPositions.clear();
        }

        public void clearPending() {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get((int)i).reqid == -1 || this.data.get((int)i).color != 2131492956) continue;
                this.data.remove(i);
                --i;
            }
        }

        public void removeItem(long eid) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get((int)i).eid != eid) continue;
                this.data.remove(i);
                --i;
            }
        }

        public int getBacklogMarkerPosition() {
            try {
                for (int i = 0; this.data != null && i < this.data.size(); ++i) {
                    EventsDataSource.Event e = this.data.get(i);
                    if (e == null || e.row_type != 2) continue;
                    return i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }

        public int insertLastSeenEIDMarker() {
            int i;
            if (MessageViewFragment.this.buffer == null) {
                return -1;
            }
            if (this.min_eid > 0L && MessageViewFragment.this.buffer.last_seen_eid > 0L && this.min_eid >= MessageViewFragment.this.buffer.last_seen_eid) {
                this.lastSeenEidMarkerPosition = 0;
            } else {
                for (i = this.data.size() - 1; i >= 0; --i) {
                    if (this.data.get((int)i).eid > MessageViewFragment.this.buffer.last_seen_eid || this.data.get((int)i).row_type == 4) continue;
                    this.lastSeenEidMarkerPosition = i;
                    break;
                }
                if (this.lastSeenEidMarkerPosition > 0 && this.lastSeenEidMarkerPosition != this.data.size() - 1 && !this.data.get((int)this.lastSeenEidMarkerPosition).self && !this.data.get((int)this.lastSeenEidMarkerPosition).pending) {
                    if (this.data.get((int)(this.lastSeenEidMarkerPosition - 1)).row_type == 1) {
                        --this.lastSeenEidMarkerPosition;
                    }
                    if (this.lastSeenEidMarkerPosition > 0) {
                        EventsDataSource.Event e = new EventsDataSource.Event();
                        e.bid = MessageViewFragment.this.buffer.bid;
                        e.cid = MessageViewFragment.this.buffer.cid;
                        e.eid = MessageViewFragment.this.buffer.last_seen_eid + 1L;
                        e.type = MessageViewFragment.TYPE_LASTSEENEID;
                        e.row_type = 4;
                        e.bg_color = 2130837702;
                        this.data.add(this.lastSeenEidMarkerPosition + 1, e);
                        EventsDataSource.getInstance().addEvent(e);
                        for (int i2 = 0; i2 < this.data.size(); ++i2) {
                            if (this.data.get((int)i2).row_type != 4 || this.data.get(i2) == e) continue;
                            EventsDataSource.getInstance().deleteEvent(this.data.get((int)i2).eid, MessageViewFragment.this.buffer.bid);
                            this.data.remove(i2);
                        }
                    }
                } else {
                    this.lastSeenEidMarkerPosition = -1;
                }
            }
            if (this.lastSeenEidMarkerPosition > 0 && this.lastSeenEidMarkerPosition <= this.currentGroupPosition) {
                ++this.currentGroupPosition;
            }
            if (this.lastSeenEidMarkerPosition == -1) {
                for (i = this.data.size() - 1; i >= 0; --i) {
                    if (this.data.get((int)i).row_type != 4) continue;
                    this.lastSeenEidMarkerPosition = i;
                    break;
                }
            }
            return this.lastSeenEidMarkerPosition;
        }

        public void clearLastSeenEIDMarker() {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get((int)i).row_type != 4) continue;
                EventsDataSource.getInstance().deleteEvent(this.data.get((int)i).eid, MessageViewFragment.this.buffer.bid);
                this.data.remove(i);
            }
            if (this.lastSeenEidMarkerPosition > 0) {
                this.lastSeenEidMarkerPosition = -1;
            }
        }

        public int getLastSeenEIDPosition() {
            return this.lastSeenEidMarkerPosition;
        }

        public int getUnreadHighlightsAbovePosition(int pos) {
            int count = 0;
            for (Integer p : this.unseenHighlightPositions) {
                if (p < pos) break;
                ++count;
            }
            return this.unseenHighlightPositions.size() - count;
        }

        public synchronized void addItem(long eid, EventsDataSource.Event e) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(eid / 1000L);
            int insert_pos = -1;
            SimpleDateFormat formatter = null;
            if (e.timestamp == null || e.timestamp.length() == 0) {
                formatter = new SimpleDateFormat("h:mm a");
                if (MessageViewFragment.this.conn.getUserInfo() != null && ((MessageViewFragment)MessageViewFragment.this).conn.getUserInfo().prefs != null) {
                    try {
                        JSONObject prefs = ((MessageViewFragment)MessageViewFragment.this).conn.getUserInfo().prefs;
                        if (prefs.has("time-24hr") && prefs.getBoolean("time-24hr")) {
                            formatter = prefs.has("time-seconds") && prefs.getBoolean("time-seconds") ? new SimpleDateFormat("H:mm:ss") : new SimpleDateFormat("H:mm");
                        } else if (prefs.has("time-seconds") && prefs.getBoolean("time-seconds")) {
                            formatter = new SimpleDateFormat("h:mm:ss a");
                        }
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
                e.timestamp = formatter.format(calendar.getTime());
            }
            e.group_eid = MessageViewFragment.this.currentCollapsedEid;
            if (e.group_msg != null && e.html == null) {
                e.html = e.group_msg;
            }
            if (e.day < 1) {
                e.day = calendar.get(6);
            }
            if (this.currentGroupPosition > 0 && eid == MessageViewFragment.this.currentCollapsedEid && e.eid != eid) {
                calendar.setTimeInMillis(e.eid / 1000L);
                this.lastDay = e.day;
                this.data.remove(this.currentGroupPosition);
                this.data.add(this.currentGroupPosition, e);
                insert_pos = this.currentGroupPosition;
            } else if (eid > this.max_eid || this.data.size() == 0 || eid > this.data.get((int)(this.data.size() - 1)).eid) {
                this.lastDay = this.data.size() > 0 ? this.data.get((int)(this.data.size() - 1)).day : 0;
                this.max_eid = eid;
                this.data.add(e);
                insert_pos = this.data.size() - 1;
            } else if (this.min_eid > eid) {
                if (this.data.size() > 1) {
                    this.lastDay = this.data.get((int)1).day;
                    if (calendar.get(6) != this.lastDay) {
                        this.data.add(0, e);
                        insert_pos = 0;
                    } else {
                        this.data.add(1, e);
                        insert_pos = 1;
                    }
                } else {
                    this.data.add(0, e);
                    insert_pos = 0;
                }
            } else {
                int i = 0;
                for (EventsDataSource.Event e1 : this.data) {
                    if (e1.row_type != 1 && e1.eid > eid && e.eid == eid && e1.group_eid != eid) {
                        if (i > 0 && this.data.get((int)(i - 1)).row_type != 1) {
                            this.lastDay = this.data.get((int)(i - 1)).day;
                            this.data.add(i, e);
                            insert_pos = i;
                            break;
                        }
                        this.lastDay = e1.day;
                        if (calendar.get(6) != this.lastDay) {
                            this.lastDay = i > 1 ? this.data.get((int)(i - 2)).day : 0;
                            this.data.add(i - 1, e);
                            insert_pos = i - 1;
                            break;
                        }
                        this.data.add(i, e);
                        insert_pos = i;
                        break;
                    }
                    if (e1.row_type != 1 && (e1.eid == eid || e1.group_eid == eid)) {
                        this.lastDay = calendar.get(6);
                        this.data.remove(i);
                        this.data.add(i, e);
                        insert_pos = i;
                        break;
                    }
                    ++i;
                }
            }
            if (insert_pos == -1) {
                Log.e((String)"IRCCloud", (String)("Couldn't insert EID: " + eid + " MSG: " + e.html));
                this.data.add(e);
                insert_pos = this.data.size() - 1;
            }
            if (eid > MessageViewFragment.this.buffer.last_seen_eid && e.highlight) {
                this.unseenHighlightPositions.add(insert_pos);
            }
            if (eid < this.min_eid || this.min_eid == 0L) {
                this.min_eid = eid;
            }
            if (eid == MessageViewFragment.this.currentCollapsedEid && e.eid == eid) {
                this.currentGroupPosition = insert_pos;
            } else if (MessageViewFragment.this.currentCollapsedEid == -1L) {
                this.currentGroupPosition = -1;
            }
            if (calendar.get(6) != this.lastDay) {
                if (formatter == null) {
                    formatter = new SimpleDateFormat("EEEE, MMMM dd, yyyy");
                } else {
                    formatter.applyPattern("EEEE, MMMM dd, yyyy");
                }
                EventsDataSource.Event d = new EventsDataSource.Event();
                d.type = MessageViewFragment.TYPE_TIMESTAMP;
                d.row_type = 1;
                d.eid = eid - 1L;
                d.timestamp = formatter.format(calendar.getTime());
                d.bg_color = 2130837696;
                d.day = this.lastDay = calendar.get(6);
                this.data.add(insert_pos, d);
                if (this.currentGroupPosition > -1) {
                    ++this.currentGroupPosition;
                }
            }
        }

        public int getCount() {
            if (this.ctx != null) {
                return this.data.size();
            }
            return 0;
        }

        public Object getItem(int position) {
            if (position < this.data.size()) {
                return this.data.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            if (position < this.data.size()) {
                return this.data.get((int)position).eid;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void format() {
            for (int i = 0; i < this.data.size(); ++i) {
                EventsDataSource.Event e = this.data.get(i);
                if (e == null) continue;
                EventsDataSource.Event event = e;
                synchronized (event) {
                    if (e.html != null) {
                        try {
                            e.html = ColorFormatter.emojify(ColorFormatter.irc_to_html(e.html));
                            e.formatted = ColorFormatter.html_to_spanned(e.html, e.linkify, MessageViewFragment.this.server, e.entities);
                            if (e.msg != null && e.msg.length() > 0) {
                                e.contentDescription = ColorFormatter.html_to_spanned(ColorFormatter.irc_to_html(e.msg), e.linkify, MessageViewFragment.this.server).toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public View getView(int position, View convertView, ViewGroup parent) {
            EventsDataSource.Event e;
            if (position >= this.data.size() || this.ctx == null) {
                return null;
            }
            EventsDataSource.Event event = e = this.data.get(position);
            synchronized (event) {
                ViewHolder holder;
                View row = convertView;
                if (row != null && ((ViewHolder)row.getTag()).type != e.row_type) {
                    row = null;
                }
                if (row == null) {
                    LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                    row = e.row_type == 2 ? inflater.inflate(2130903114, parent, false) : (e.row_type == 1 ? inflater.inflate(2130903128, parent, false) : (e.row_type == 3 ? inflater.inflate(2130903126, parent, false) : (e.row_type == 4 ? inflater.inflate(2130903120, parent, false) : inflater.inflate(2130903121, parent, false))));
                    holder = new ViewHolder();
                    holder.timestamp = (TextView)row.findViewById(2131624198);
                    holder.message = (TextView)row.findViewById(2131624116);
                    holder.expandable = (ImageView)row.findViewById(2131624199);
                    holder.failed = (ImageView)row.findViewById(2131624200);
                    holder.type = e.row_type;
                    row.setTag((Object)holder);
                } else {
                    holder = (ViewHolder)row.getTag();
                }
                row.setOnClickListener((View.OnClickListener)new OnItemClickListener(position));
                if (e.html != null && e.formatted == null) {
                    e.html = ColorFormatter.emojify(ColorFormatter.irc_to_html(e.html));
                    e.formatted = ColorFormatter.html_to_spanned(e.html, e.linkify, MessageViewFragment.this.server, e.entities);
                    if (e.msg != null && e.msg.length() > 0) {
                        e.contentDescription = ColorFormatter.html_to_spanned(ColorFormatter.irc_to_html(e.msg), e.linkify, MessageViewFragment.this.server).toString();
                    }
                }
                if (e.row_type == 0) {
                    if (e.bg_color == 2131492930) {
                        row.setBackgroundDrawable(null);
                    } else {
                        row.setBackgroundResource(e.bg_color);
                    }
                    if (e.contentDescription != null && e.from != null && e.from.length() > 0 && e.msg != null && e.msg.length() > 0) {
                        row.setContentDescription((CharSequence)("Message from " + e.from + " at " + e.timestamp + ": " + e.contentDescription));
                    }
                }
                if (holder.timestamp != null) {
                    if (e.row_type == 1) {
                        holder.timestamp.setTextSize(MessageViewFragment.this.textSize);
                    } else {
                        holder.timestamp.setTextSize(MessageViewFragment.this.textSize - 2.0f);
                        if (MessageViewFragment.this.timestamp_width == -1) {
                            String s = "888:888";
                            if (MessageViewFragment.this.conn != null && MessageViewFragment.this.conn.getUserInfo() != null && ((MessageViewFragment)MessageViewFragment.this).conn.getUserInfo().prefs != null) {
                                try {
                                    JSONObject prefs = ((MessageViewFragment)MessageViewFragment.this).conn.getUserInfo().prefs;
                                    if (prefs.has("time-seconds") && prefs.getBoolean("time-seconds")) {
                                        s = s + ":88";
                                    }
                                    if (!prefs.has("time-24hr") || !prefs.getBoolean("time-24hr")) {
                                        s = s + " 88";
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            MessageViewFragment.this.timestamp_width = (int)holder.timestamp.getPaint().measureText(s);
                        }
                        holder.timestamp.setMinWidth(MessageViewFragment.this.timestamp_width);
                    }
                    if (e.highlight && !e.self) {
                        holder.timestamp.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492914));
                    } else if (e.row_type != 1) {
                        holder.timestamp.setTextColor(MessageViewFragment.getSafeResources().getColor(2131492956));
                    }
                    holder.timestamp.setText((CharSequence)e.timestamp);
                }
                if (e.row_type == 3) {
                    if (e.msg != null && e.msg.length() > 0) {
                        holder.timestamp.setVisibility(0);
                        holder.message.setVisibility(0);
                    } else {
                        holder.timestamp.setVisibility(8);
                        holder.message.setVisibility(8);
                    }
                }
                if (holder.message != null && e.html != null) {
                    holder.message.setMovementMethod((MovementMethod)MessageViewFragment.this.linkMovementMethodNoLongPress);
                    holder.message.setOnClickListener((View.OnClickListener)new OnItemClickListener(position));
                    if (e.msg != null && e.msg.startsWith("<pre>")) {
                        holder.message.setTypeface(Typeface.MONOSPACE);
                    } else {
                        holder.message.setTypeface(Typeface.DEFAULT);
                    }
                    try {
                        holder.message.setTextColor(MessageViewFragment.getSafeResources().getColorStateList(e.color));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (e.color == 2131492956 || e.pending) {
                        holder.message.setLinkTextColor(MessageViewFragment.getSafeResources().getColor(2131492919));
                    } else {
                        holder.message.setLinkTextColor(MessageViewFragment.getSafeResources().getColor(2131492921));
                    }
                    holder.message.setText((CharSequence)e.formatted);
                    if (e.from != null && e.from.length() > 0 && e.msg != null && e.msg.length() > 0) {
                        holder.message.setContentDescription((CharSequence)(e.from + ": " + e.contentDescription));
                    }
                    holder.message.setTextSize(MessageViewFragment.this.textSize);
                }
                if (holder.expandable != null) {
                    if (e.group_eid > 0L && (e.group_eid != e.eid || MessageViewFragment.this.expandedSectionEids.contains(e.group_eid))) {
                        if (MessageViewFragment.this.expandedSectionEids.contains(e.group_eid)) {
                            if (e.group_eid == e.eid + 1L) {
                                holder.expandable.setImageResource(2130837573);
                                holder.expandable.setContentDescription((CharSequence)"expanded");
                                row.setBackgroundResource(2130837732);
                            } else {
                                holder.expandable.setImageResource(2130837704);
                                holder.expandable.setContentDescription((CharSequence)"collapse");
                                row.setBackgroundResource(2130837717);
                            }
                        } else {
                            holder.expandable.setImageResource(2130837574);
                            holder.expandable.setContentDescription((CharSequence)"expand");
                        }
                        holder.expandable.setVisibility(0);
                    } else {
                        holder.expandable.setVisibility(8);
                    }
                }
                if (holder.failed != null) {
                    holder.failed.setVisibility(e.failed ? 0 : 8);
                }
                return row;
            }
        }

        private class ViewHolder {
            int type;
            TextView timestamp;
            TextView message;
            ImageView expandable;
            ImageView failed;

            private ViewHolder() {
            }
        }
    }

    private class LinkMovementMethodNoLongPress
    extends LinkMovementMethod {
        private LinkMovementMethodNoLongPress() {
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            if (!MessageViewFragment.this.longPressOverride && event.getAction() == 1) {
                try {
                    return super.onTouchEvent(widget, buffer, event);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

