/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.squareup.leakcanary.RefWatcher;

public class NamesListFragment
extends DialogFragment {
    JsonNode users;
    UsersAdapter adapter;
    NetworkConnection conn;
    ListView listView;
    IRCCloudJSONObject event;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        TextView empty = (TextView)v.findViewById(16908292);
        empty.setText((CharSequence)"No results found.");
        this.listView.setEmptyView((View)empty);
        if (savedInstanceState != null && savedInstanceState.containsKey("event")) {
            this.event = new IRCCloudJSONObject(savedInstanceState.getString("event"));
            this.users = this.event.getJsonNode("members");
            this.adapter = new UsersAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("NAMES response for " + this.event.getString("chan")).setView(v).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putString("event", this.event.toString());
    }

    @Override
    public void setArguments(Bundle args) {
        this.event = new IRCCloudJSONObject(args.getString("event"));
        this.users = this.event.getJsonNode("members");
        if (this.getActivity() != null && this.listView != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (NamesListFragment.this.adapter == null) {
                        NamesListFragment.this.adapter = new UsersAdapter(NamesListFragment.this);
                        NamesListFragment.this.listView.setAdapter((ListAdapter)NamesListFragment.this.adapter);
                    } else {
                        NamesListFragment.this.adapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        if (this.users != null) {
            this.adapter = new UsersAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    private class UsersAdapter
    extends BaseAdapter {
        private DialogFragment ctx;

        public UsersAdapter(DialogFragment context) {
            this.ctx = context;
        }

        public int getCount() {
            return NamesListFragment.this.users.size();
        }

        public Object getItem(int pos) {
            try {
                return NamesListFragment.this.users.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row != null && ((ViewHolder)row.getTag()).position != position) {
                row = null;
            }
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903130, null);
                holder = new ViewHolder();
                holder.position = position;
                holder.nick = (TextView)row.findViewById(2131624186);
                holder.name = (TextView)row.findViewById(2131624050);
                holder.server = (TextView)row.findViewById(2131624137);
                holder.mask = (TextView)row.findViewById(2131624136);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                holder.nick.setText((CharSequence)NamesListFragment.this.users.get(position).get("nick").asText());
                if (NamesListFragment.this.users.get(position).get("mode").asText().length() > 0) {
                    holder.name.setText((CharSequence)(" (+" + NamesListFragment.this.users.get(position).get("mode").asText() + ")"));
                } else {
                    holder.name.setText((CharSequence)"");
                }
                holder.server.setVisibility(8);
                holder.mask.setText((CharSequence)NamesListFragment.this.users.get(position).get("usermask").asText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            int position;
            TextView nick;
            TextView name;
            TextView server;
            TextView mask;

            private ViewHolder() {
            }
        }
    }
}

