/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;

public class NickservFragment
extends DialogFragment {
    ServersDataSource.Server server;
    EditText pass;
    TextView nick;

    public void setCid(int cid) {
        this.server = ServersDataSource.getInstance().getServer(cid);
        if (this.nick != null && this.server != null) {
            this.nick.setText((CharSequence)("Password for " + this.server.nick));
            if (this.server.nickserv_pass != null) {
                this.pass.setText((CharSequence)this.server.nickserv_pass);
            }
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.server == null) {
            return null;
        }
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903089, null);
        this.nick = (TextView)v.findViewById(2131624103);
        this.pass = (EditText)v.findViewById(2131624052);
        this.nick.setText((CharSequence)("Password for " + this.server.nick));
        if (this.server.nickserv_pass != null) {
            this.pass.setText((CharSequence)this.server.nickserv_pass);
        }
        String title = "Identify your nickname on ";
        title = this.server.name != null && this.server.name.length() > 0 ? title + this.server.name : title + this.server.hostname;
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle(title).setView(v).setPositiveButton("Save", new SaveClickListener()).setNeutralButton("Instructions", new InstructionsClickListener()).setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        d.getWindow().setSoftInputMode(16);
        return d;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    class InstructionsClickListener
    implements DialogInterface.OnClickListener {
        InstructionsClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
            NetworkConnection.getInstance().ns_help_register(NickservFragment.this.server.cid);
            NickservFragment.this.dismiss();
        }
    }

    class SaveClickListener
    implements DialogInterface.OnClickListener {
        SaveClickListener() {
        }

        public void onClick(DialogInterface dialog, int which) {
            if (NickservFragment.this.pass.getText() != null && NickservFragment.this.pass.getText().length() > 0) {
                NetworkConnection.getInstance().set_nspass(NickservFragment.this.server.cid, NickservFragment.this.pass.getText().toString());
                NickservFragment.this.dismiss();
            }
        }
    }
}

