/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Toast;
import com.crashlytics.android.Crashlytics;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.vars.VariableMap;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class PastebinEditorFragment
extends DialogFragment
implements NetworkConnection.IRCEventHandler {
    private EditText paste;
    private EditText filename;
    private EditText message;
    private int pastereqid = -1;
    public String pastecontents;
    public String pasteID;
    public PastebinEditorListener listener;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        NetworkConnection.getInstance().addHandler(this);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setInverseBackgroundForced(Build.VERSION.SDK_INT < 11);
        View v = this.getActivity().getLayoutInflater().inflate(2130903090, null);
        this.paste = (EditText)v.findViewById(2131624113);
        this.filename = (EditText)v.findViewById(2131624115);
        this.message = (EditText)v.findViewById(2131624116);
        CheckBox alwaysSend = (CheckBox)v.findViewById(2131624118);
        this.paste.setText((CharSequence)this.pastecontents);
        alwaysSend.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if (NetworkConnection.getInstance().getUserInfo() == null) {
                    Toast.makeText((Context)PastebinEditorFragment.this.getActivity(), (CharSequence)"An error occurred while saving settings.  Please try again shortly", (int)0).show();
                }
                JSONObject prefs = NetworkConnection.getInstance().getUserInfo().prefs;
                try {
                    if (prefs == null) {
                        NetworkConnection.getInstance().getUserInfo().prefs = prefs = new JSONObject();
                        Crashlytics.logException(new Exception("Users prefs was null, creating new object"));
                    }
                    prefs.put("pastebin-disableprompt", b);
                    NetworkConnection.getInstance().set_prefs(prefs.toString());
                }
                catch (JSONException e) {
                    Crashlytics.log(6, "IRCCloud", "Unable to set preference: pastebin-disableprompt");
                    Crashlytics.logException(e);
                    Toast.makeText((Context)PastebinEditorFragment.this.getActivity(), (CharSequence)"An error occurred while saving settings.  Please try again shortly", (int)0).show();
                }
            }
        });
        builder.setView(v);
        builder.setTitle("Pastebin");
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        if (this.pasteID != null) {
            this.message.setVisibility(8);
            alwaysSend.setVisibility(8);
            v.findViewById(2131624117).setVisibility(8);
            v.findViewById(2131624119).setVisibility(8);
            builder.setPositiveButton("Save", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PastebinEditorFragment.this.pastecontents = PastebinEditorFragment.this.paste.getText().toString();
                    PastebinEditorFragment.this.pastereqid = NetworkConnection.getInstance().edit_paste(PastebinEditorFragment.this.pasteID, PastebinEditorFragment.this.filename.getText().toString(), PastebinEditorFragment.this.extension(), PastebinEditorFragment.this.pastecontents);
                }
            });
            new FetchPastebinTask().execute(new Void[]{null});
        } else {
            builder.setPositiveButton("Pastebin", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PastebinEditorFragment.this.pastecontents = PastebinEditorFragment.this.paste.getText().toString();
                    PastebinEditorFragment.this.pastereqid = NetworkConnection.getInstance().paste(PastebinEditorFragment.this.filename.getText().toString(), PastebinEditorFragment.this.extension(), PastebinEditorFragment.this.pastecontents);
                }
            });
            builder.setNeutralButton("Send as Text", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (PastebinEditorFragment.this.listener != null) {
                        PastebinEditorFragment.this.listener.onPastebinSendAsText(PastebinEditorFragment.this.paste.getText().toString());
                    }
                    NetworkConnection.getInstance().removeHandler(PastebinEditorFragment.this);
                    dialog.dismiss();
                }
            });
        }
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (PastebinEditorFragment.this.listener != null) {
                    PastebinEditorFragment.this.listener.onPastebinCancelled();
                }
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOwnerActivity(this.getActivity());
        dialog.getWindow().setSoftInputMode(5);
        return dialog;
    }

    private String extension() {
        try {
            String extension;
            String file;
            if (this.filename != null && this.filename.getText() != null && this.filename.getText().length() > 0 && (file = this.filename.getText().toString()).contains(".") && (extension = file.substring(file.lastIndexOf(".") + 1)).length() > 0) {
                return extension;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "txt";
    }

    @Override
    public void onIRCEvent(int msg, Object obj) {
        switch (msg) {
            case 103: {
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event == null || !event.has("_reqid")) break;
                Log.e((String)"IRCCloud", (String)("Pastebin Error: " + obj.toString()));
                int reqid = event.getInt("_reqid");
                if (reqid != this.pastereqid) break;
                if (this.listener != null) {
                    this.listener.onPastebinFailed(this.pastecontents);
                }
                NetworkConnection.getInstance().removeHandler(this);
                break;
            }
            case 104: {
                int reqid;
                IRCCloudJSONObject event = (IRCCloudJSONObject)obj;
                if (event == null || !event.has("_reqid") || (reqid = event.getInt("_reqid")) != this.pastereqid) break;
                if (this.listener != null) {
                    if (this.pasteID != null) {
                        this.listener.onPastebinSaved();
                    } else if (this.message != null && this.message.getText() != null && this.message.getText().length() > 0) {
                        this.listener.onPastebinSendAsText(this.message.getText() + " " + event.getString("url"));
                    } else {
                        this.listener.onPastebinSendAsText(event.getString("url"));
                    }
                }
                NetworkConnection.getInstance().removeHandler(this);
                break;
            }
        }
    }

    private class FetchPastebinTask
    extends AsyncTaskEx<Void, Void, JSONObject> {
        private FetchPastebinTask() {
        }

        protected JSONObject doInBackground(Void ... params) {
            try {
                URITemplate uri_template = new URITemplate(NetworkConnection.getInstance().config.getString("pastebin_uri_template"));
                return NetworkConnection.getInstance().fetchJSON(uri_template.toString(VariableMap.newBuilder().addScalarValue("id", PastebinEditorFragment.this.pasteID).addScalarValue("type", "json").freeze()));
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        protected void onPostExecute(JSONObject o) {
            if (o != null) {
                try {
                    PastebinEditorFragment.this.paste.setText((CharSequence)o.getString("body"));
                    PastebinEditorFragment.this.filename.setText((CharSequence)o.getString("name"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface PastebinEditorListener {
        public void onPastebinFailed(String var1);

        public void onPastebinSaved();

        public void onPastebinSendAsText(String var1);

        public void onPastebinCancelled();
    }
}

