/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.squareup.leakcanary.RefWatcher;

public class ServerMapListFragment
extends DialogFragment {
    JsonNode servers;
    ServersAdapter adapter;
    NetworkConnection conn;
    ListView listView;
    IRCCloudJSONObject event;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903096, null);
        this.listView = (ListView)v.findViewById(16908298);
        TextView empty = (TextView)v.findViewById(16908292);
        empty.setText((CharSequence)"No results found.");
        this.listView.setEmptyView((View)empty);
        this.listView.setDividerHeight(0);
        if (savedInstanceState != null && savedInstanceState.containsKey("event")) {
            this.event = new IRCCloudJSONObject(savedInstanceState.getString("event"));
            this.servers = this.event.getJsonNode("servers");
            this.adapter = new ServersAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("Server Map").setView(v).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putString("event", this.event.toString());
    }

    @Override
    public void setArguments(Bundle args) {
        this.event = new IRCCloudJSONObject(args.getString("event"));
        this.servers = this.event.getJsonNode("servers");
        if (this.getActivity() != null && this.listView != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ServerMapListFragment.this.adapter == null) {
                        ServerMapListFragment.this.adapter = new ServersAdapter(ServerMapListFragment.this);
                        ServerMapListFragment.this.listView.setAdapter((ListAdapter)ServerMapListFragment.this.adapter);
                    } else {
                        ServerMapListFragment.this.adapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        if (this.servers != null) {
            this.adapter = new ServersAdapter(this);
            this.listView.setAdapter((ListAdapter)this.adapter);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    private class ServersAdapter
    extends BaseAdapter {
        private DialogFragment ctx;

        public ServersAdapter(DialogFragment context) {
            this.ctx = context;
        }

        public int getCount() {
            return ServerMapListFragment.this.servers.size();
        }

        public Object getItem(int pos) {
            try {
                return ServerMapListFragment.this.servers.get(pos);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getItemId(int pos) {
            return pos;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (row != null && ((ViewHolder)row.getTag()).position != position) {
                row = null;
            }
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903125, null);
                holder = new ViewHolder();
                holder.position = position;
                holder.server = (TextView)row.findViewById(2131624137);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            try {
                holder.server.setText((CharSequence)ServerMapListFragment.this.servers.get(position).asText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return row;
        }

        private class ViewHolder {
            int position;
            TextView server;

            private ViewHolder() {
            }
        }
    }
}

