/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.irccloud.android.AsyncTaskEx;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ServersDataSource;
import com.mobeta.android.dslv.DragSortListView;
import com.squareup.leakcanary.RefWatcher;
import java.util.ArrayList;
import java.util.Collections;

public class ServerReorderFragment
extends DialogFragment
implements NetworkConnection.IRCEventHandler {
    private NetworkConnection conn;
    private ServerListAdapter adapter;
    private RefreshTask refreshTask = null;
    private DragSortListView listView = null;
    private DragSortListView.DropListener dropListener = new DragSortListView.DropListener(){

        @Override
        public void drop(int from, int to) {
            ServersDataSource.Server s = ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.get(from);
            ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.remove(from);
            if (to >= ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.size()) {
                ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.add(s);
            } else {
                ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.add(to, s);
            }
            ServerReorderFragment.this.adapter.notifyDataSetChanged();
            String cids = "";
            for (int i = 0; i < ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.size(); ++i) {
                s = ((ServerReorderFragment)ServerReorderFragment.this).adapter.data.get(i);
                s.order = i + 1;
                if (cids.length() > 0) {
                    cids = cids + ",";
                }
                cids = cids + s.cid;
            }
            NetworkConnection.getInstance().reorder_connections(cids);
        }
    };

    private void refresh(ArrayList<ServersDataSource.Server> servers) {
        if (servers == null) {
            if (this.adapter != null) {
                this.adapter.data.clear();
                this.adapter.notifyDataSetInvalidated();
            }
            return;
        }
        if (this.adapter == null) {
            this.adapter = new ServerListAdapter(this);
        }
        this.adapter.setItems(servers);
        if (this.listView.getAdapter() == null) {
            this.listView.setAdapter((ListAdapter)this.adapter);
        } else {
            this.adapter.notifyDataSetChanged();
        }
    }

    private void init(View v) {
        this.listView = (DragSortListView)v.findViewById(16908298);
        this.listView.setDropListener(this.dropListener);
        TextView tv = (TextView)v.findViewById(2131624184);
        SpannableString s = new SpannableString(tv.getText());
        s.setSpan((Object)new ImageSpan((Context)this.getActivity(), 2130837676), 5, 6, 0);
        tv.setText((CharSequence)s);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        View v = inflater.inflate(2130903112, null);
        this.init(v);
        this.listView.setCacheColorHint(-2496513);
        return v;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903112, null);
        this.init(v);
        this.listView.setCacheColorHint(-789517);
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setTitle("Connections").setView(v).setNegativeButton("Done", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NetworkConnection.getInstance().removeHandler(ServerReorderFragment.this);
            }
        }).create();
        return d;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        ArrayList<ServersDataSource.Server> servers = new ArrayList<ServersDataSource.Server>();
        SparseArray<ServersDataSource.Server> s = ServersDataSource.getInstance().getServers();
        for (int i = 0; i < s.size(); ++i) {
            servers.add((ServersDataSource.Server)s.valueAt(i));
        }
        Collections.sort(servers);
        this.refresh(servers);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 2: 
            case 19: 
            case 42: {
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ServerReorderFragment.this.refreshTask != null) {
                            ServerReorderFragment.this.refreshTask.cancel(true);
                        }
                        ServerReorderFragment.this.refreshTask = new RefreshTask();
                        ServerReorderFragment.this.refreshTask.execute(new Void[]{null});
                    }
                });
                break;
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }

    private class RefreshTask
    extends AsyncTaskEx<Void, Void, Void> {
        ArrayList<ServersDataSource.Server> servers = new ArrayList();

        private RefreshTask() {
        }

        protected Void doInBackground(Void ... params) {
            SparseArray<ServersDataSource.Server> s = ServersDataSource.getInstance().getServers();
            for (int i = 0; i < s.size(); ++i) {
                this.servers.add((ServersDataSource.Server)s.valueAt(i));
            }
            Collections.sort(this.servers);
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (!this.isCancelled()) {
                ServerReorderFragment.this.refresh(this.servers);
                ServerReorderFragment.this.refreshTask = null;
            }
        }
    }

    private class ServerListAdapter
    extends BaseAdapter {
        ArrayList<ServersDataSource.Server> data;
        private DialogFragment ctx;
        int width = 0;

        public ServerListAdapter(DialogFragment context) {
            this.ctx = context;
            this.data = new ArrayList();
            WindowManager wm = (WindowManager)IRCCloudApplication.getInstance().getApplicationContext().getSystemService("window");
            this.width = wm.getDefaultDisplay().getWidth();
        }

        public void setItems(ArrayList<ServersDataSource.Server> items) {
            this.data = items;
        }

        public int getCount() {
            return this.data.size();
        }

        public Object getItem(int position) {
            return this.data.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            ServersDataSource.Server s = this.data.get(position);
            View row = convertView;
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903123, null);
                holder = new ViewHolder();
                holder.label = (TextView)row.findViewById(2131624189);
                holder.icon = (ImageView)row.findViewById(2131623993);
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            if (s.name != null && s.name.length() > 0) {
                holder.label.setText((CharSequence)s.name);
            } else {
                holder.label.setText((CharSequence)s.hostname);
            }
            if (s.ssl > 0) {
                holder.icon.setImageResource(2130837708);
            } else {
                holder.icon.setImageResource(2130837706);
            }
            if (s.status != null && s.status.equals("connected_ready")) {
                holder.label.setTextColor(ServerReorderFragment.this.getResources().getColorStateList(2131492968));
            } else {
                holder.label.setTextColor(ServerReorderFragment.this.getResources().getColorStateList(2131492973));
            }
            if (ServerReorderFragment.this.getShowsDialog()) {
                row.setBackgroundColor(-789517);
            } else {
                row.setBackgroundResource(2130837569);
            }
            holder.label.setMinimumWidth(this.width);
            return row;
        }

        private class ViewHolder {
            TextView label;
            ImageView icon;

            private ViewHolder() {
            }
        }
    }
}

