/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.NetworkConnection;
import com.irccloud.android.data.ChannelsDataSource;
import com.irccloud.android.data.ServersDataSource;
import com.irccloud.android.data.UsersDataSource;
import com.squareup.leakcanary.RefWatcher;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;

public class UsersListFragment
extends ListFragment
implements NetworkConnection.IRCEventHandler {
    private static final int TYPE_HEADING = 0;
    private static final int TYPE_USER = 1;
    private NetworkConnection conn;
    private UserListAdapter adapter;
    private OnUserSelectedListener mListener;
    private int cid = -1;
    private int bid = -1;
    private String channel;
    private static Timer tapTimer = null;
    private TimerTask tapTimerTask = null;

    private void addUsersFromList(ArrayList<UserListAdapter.UserListEntry> entries, ArrayList<UsersDataSource.User> users, String heading, String symbol, int heading_color, int bg_color, int heading_bg_color) {
        if (users.size() > 0 && symbol != null) {
            entries.add(this.adapter.buildItem(0, heading, users.size() > 0 ? symbol + String.valueOf(users.size()) : null, heading_color, heading_bg_color, heading_bg_color, false, false));
            for (int i = 0; i < users.size(); ++i) {
                UsersDataSource.User user = users.get(i);
                entries.add(this.adapter.buildItem(1, user.nick, null, 2131492977, bg_color, heading_bg_color, user.away > 0, i == users.size() - 1));
            }
        }
    }

    private void refresh(ArrayList<UsersDataSource.User> users) {
        if (users == null) {
            if (this.adapter != null) {
                this.adapter.data.clear();
                this.adapter.notifyDataSetInvalidated();
            }
            return;
        }
        ArrayList<UserListAdapter.UserListEntry> entries = new ArrayList<UserListAdapter.UserListEntry>();
        ArrayList<UsersDataSource.User> opers = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> owners = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> admins = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> ops = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> halfops = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> voiced = new ArrayList<UsersDataSource.User>();
        ArrayList<UsersDataSource.User> members = new ArrayList<UsersDataSource.User>();
        boolean showSymbol = false;
        try {
            if (this.conn != null && this.conn.getUserInfo() != null && this.conn.getUserInfo().prefs != null) {
                showSymbol = this.conn.getUserInfo().prefs.getBoolean("mode-showsymbol");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ObjectNode PREFIX = null;
        ServersDataSource.Server s = ServersDataSource.getInstance().getServer(this.cid);
        if (s != null) {
            PREFIX = s.PREFIX;
        }
        if (PREFIX == null) {
            PREFIX = new ObjectMapper().createObjectNode();
            PREFIX.put(s != null ? s.MODE_OPER : "Y", "!");
            PREFIX.put(s != null ? s.MODE_OWNER : "q", "~");
            PREFIX.put(s != null ? s.MODE_ADMIN : "a", "&");
            PREFIX.put(s != null ? s.MODE_OP : "o", "@");
            PREFIX.put(s != null ? s.MODE_HALFOP : "h", "%");
            PREFIX.put(s != null ? s.MODE_VOICED : "v", "+");
        }
        if (this.adapter == null) {
            this.adapter = new UserListAdapter(this);
        }
        for (int i = 0; i < users.size(); ++i) {
            UsersDataSource.User user = users.get(i);
            if (user.mode.contains(s != null ? s.MODE_OPER : "Y") && PREFIX.has(s != null ? s.MODE_OPER : "Y")) {
                opers.add(user);
                continue;
            }
            if (user.mode.contains(s != null ? s.MODE_OWNER : "q") && PREFIX.has(s != null ? s.MODE_OWNER : "q")) {
                owners.add(user);
                continue;
            }
            if (user.mode.contains(s != null ? s.MODE_ADMIN : "a") && PREFIX.has(s != null ? s.MODE_ADMIN : "a")) {
                admins.add(user);
                continue;
            }
            if (user.mode.contains(s != null ? s.MODE_OP : "o") && PREFIX.has(s != null ? s.MODE_OP : "o")) {
                ops.add(user);
                continue;
            }
            if (user.mode.contains(s != null ? s.MODE_HALFOP : "h") && PREFIX.has(s != null ? s.MODE_HALFOP : "h")) {
                halfops.add(user);
                continue;
            }
            if (user.mode.contains(s != null ? s.MODE_VOICED : "v") && PREFIX.has(s != null ? s.MODE_VOICED : "v")) {
                voiced.add(user);
                continue;
            }
            members.add(user);
        }
        if (opers.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_OPER : "Y")) {
                    this.addUsersFromList(entries, opers, "OPER", PREFIX.get(s != null ? s.MODE_OPER : "Y").asText() + " ", 2131492908, 2130837694, 2130837727);
                } else {
                    this.addUsersFromList(entries, opers, "OPER", "", 2131492908, 2130837694, 2130837727);
                }
            } else {
                this.addUsersFromList(entries, opers, "OPER", "\u2022 ", 2131492908, 2130837694, 2130837727);
            }
        }
        if (owners.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_OWNER : "q")) {
                    this.addUsersFromList(entries, owners, "OWNER", PREFIX.get(s != null ? s.MODE_OWNER : "q").asText() + " ", 2131492910, 2130837695, 2130837729);
                } else {
                    this.addUsersFromList(entries, owners, "OWNER", "", 2131492910, 2130837695, 2130837729);
                }
            } else {
                this.addUsersFromList(entries, owners, "OWNER", "\u2022 ", 2131492910, 2130837695, 2130837729);
            }
        }
        if (admins.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_ADMIN : "a")) {
                    this.addUsersFromList(entries, admins, "ADMINS", PREFIX.get(s != null ? s.MODE_ADMIN : "a").asText() + " ", 2131492905, 2130837679, 2130837710);
                } else {
                    this.addUsersFromList(entries, admins, "ADMINS", "", 2131492905, 2130837679, 2130837710);
                }
            } else {
                this.addUsersFromList(entries, admins, "ADMINS", "\u2022 ", 2131492905, 2130837679, 2130837710);
            }
        }
        if (ops.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_OP : "o")) {
                    this.addUsersFromList(entries, ops, "OPS", PREFIX.get(s != null ? s.MODE_OP : "o").asText() + " ", 2131492909, 2130837693, 2130837728);
                } else {
                    this.addUsersFromList(entries, ops, "OPS", "", 2131492909, 2130837693, 2130837728);
                }
            } else {
                this.addUsersFromList(entries, ops, "OPS", "\u2022 ", 2131492909, 2130837693, 2130837728);
            }
        }
        if (halfops.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_HALFOP : "h")) {
                    this.addUsersFromList(entries, halfops, "HALF OPS", PREFIX.get(s != null ? s.MODE_HALFOP : "h").asText() + " ", 2131492906, 2130837691, 2130837718);
                } else {
                    this.addUsersFromList(entries, halfops, "HALF OPS", "", 2131492906, 2130837691, 2130837718);
                }
            } else {
                this.addUsersFromList(entries, halfops, "HALF OPS", "\u2022 ", 2131492906, 2130837691, 2130837718);
            }
        }
        if (voiced.size() > 0) {
            if (showSymbol) {
                if (PREFIX.has(s != null ? s.MODE_VOICED : "v")) {
                    this.addUsersFromList(entries, voiced, "VOICED", PREFIX.get(s != null ? s.MODE_VOICED : "v").asText() + " ", 2131492911, 2130837697, 2130837735);
                } else {
                    this.addUsersFromList(entries, voiced, "VOICED", "", 2131492911, 2130837697, 2130837735);
                }
            } else {
                this.addUsersFromList(entries, voiced, "VOICED", "\u2022 ", 2131492911, 2130837697, 2130837735);
            }
        }
        if (members.size() > 0) {
            this.addUsersFromList(entries, members, "MEMBERS", "", 2131492907, 2130837692, 2130837714);
        }
        this.adapter.setItems(entries);
        if (this.getListAdapter() == null && entries.size() > 0) {
            this.setListAdapter((ListAdapter)this.adapter);
        } else {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (tapTimer == null) {
            tapTimer = new Timer("users-tap-timer");
        }
        if (savedInstanceState != null && savedInstanceState.containsKey("cid")) {
            this.cid = savedInstanceState.getInt("cid");
            this.bid = savedInstanceState.getInt("bid");
            this.channel = savedInstanceState.getString("channel");
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(2130903138, null);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conn = NetworkConnection.getInstance();
        this.conn.addHandler(this);
        ArrayList<UsersDataSource.User> users = UsersDataSource.getInstance().getUsersForBuffer(this.bid);
        this.refresh(users);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
        if (tapTimer != null) {
            tapTimer.cancel();
            tapTimer = null;
        }
    }

    @Override
    public void setArguments(Bundle args) {
        this.cid = args.getInt("cid", 0);
        this.bid = args.getInt("bid", 0);
        this.channel = args.getString("name");
        if (tapTimer == null) {
            tapTimer = new Timer("users-tap-timer");
        }
        tapTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (UsersListFragment.this.getActivity() != null) {
                    UsersListFragment.this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<UsersDataSource.User> users = null;
                            if (ChannelsDataSource.getInstance().getChannelForBuffer(UsersListFragment.this.bid) != null) {
                                users = UsersDataSource.getInstance().getUsersForBuffer(UsersListFragment.this.bid);
                            }
                            UsersListFragment.this.refresh(users);
                            try {
                                if (UsersListFragment.this.getListView() != null) {
                                    UsersListFragment.this.getListView().setSelection(0);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }, 100L);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.conn != null) {
            this.conn.removeHandler(this);
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (OnUserSelectedListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnUserSelectedListener");
        }
        if (this.cid == -1) {
            this.cid = activity.getIntent().getIntExtra("cid", 0);
            this.channel = activity.getIntent().getStringExtra("name");
        }
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putInt("cid", this.cid);
        state.putInt("bid", this.bid);
        state.putString("channel", this.channel);
    }

    @Override
    public void onIRCEvent(int what, Object obj) {
        switch (what) {
            case 0: {
                if (this.adapter == null || this.getActivity() == null) break;
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (UsersListFragment.this.adapter != null) {
                            UsersListFragment.this.adapter.notifyDataSetChanged();
                        }
                    }
                });
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 22: {
                if (((IRCCloudJSONObject)obj).bid() != this.bid) break;
            }
            case 1: 
            case 7: 
            case 13: 
            case 101: {
                if (this.getActivity() == null || ChannelsDataSource.getInstance().getChannelForBuffer(this.bid) == null) break;
                final ArrayList<UsersDataSource.User> users = UsersDataSource.getInstance().getUsersForBuffer(this.bid);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        UsersListFragment.this.refresh(users);
                    }
                });
                break;
            }
        }
    }

    public Resources getSafeResources() {
        return IRCCloudApplication.getInstance().getApplicationContext().getResources();
    }

    public static interface OnUserSelectedListener {
        public void onUserSelected(int var1, String var2, String var3);

        public void onUserDoubleClicked(String var1);
    }

    private class OnItemClickListener
    implements View.OnClickListener {
        private int pos;

        OnItemClickListener(int position) {
            this.pos = position;
        }

        public void onClick(View arg0) {
            if (this.pos < 0) {
                return;
            }
            if (UsersListFragment.this.adapter != null && tapTimer != null) {
                if (UsersListFragment.this.tapTimerTask != null) {
                    UsersListFragment.this.tapTimerTask.cancel();
                    UsersListFragment.this.tapTimerTask = null;
                    try {
                        UserListAdapter.UserListEntry e = (UserListAdapter.UserListEntry)UsersListFragment.this.adapter.getItem(this.pos);
                        if (e.type == 1) {
                            UsersListFragment.this.mListener.onUserDoubleClicked(e.text);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    UsersListFragment.this.tapTimerTask = new TimerTask(){
                        int position;
                        {
                            this.position = OnItemClickListener.this.pos;
                        }

                        @Override
                        public void run() {
                            if (UsersListFragment.this.getActivity() != null) {
                                UsersListFragment.this.getActivity().runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            UserListAdapter.UserListEntry e = (UserListAdapter.UserListEntry)UsersListFragment.this.adapter.getItem(position);
                                            if (e.type == 1) {
                                                UsersListFragment.this.mListener.onUserSelected(UsersListFragment.this.cid, UsersListFragment.this.channel, e.text);
                                                if (!UsersListFragment.this.getActivity().getSharedPreferences("prefs", 0).getBoolean("longPressTip", false)) {
                                                    Toast.makeText((Context)UsersListFragment.this.getActivity(), (CharSequence)"Long-press a message to quickly interact with the sender", (int)1).show();
                                                    SharedPreferences.Editor editor = UsersListFragment.this.getActivity().getSharedPreferences("prefs", 0).edit();
                                                    editor.putBoolean("longPressTip", true);
                                                    editor.commit();
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                            UsersListFragment.this.tapTimerTask = null;
                        }
                    };
                    tapTimer.schedule(UsersListFragment.this.tapTimerTask, 300L);
                }
            }
        }
    }

    private class OnItemLongClickListener
    implements View.OnLongClickListener {
        private int pos;

        OnItemLongClickListener(int position) {
            this.pos = position;
        }

        public boolean onLongClick(View v) {
            if (this.pos < UsersListFragment.this.adapter.getCount()) {
                UserListAdapter.UserListEntry e = (UserListAdapter.UserListEntry)UsersListFragment.this.adapter.getItem(this.pos);
                if (e.type == 1) {
                    UsersListFragment.this.mListener.onUserSelected(UsersListFragment.this.cid, UsersListFragment.this.channel, e.text);
                    return true;
                }
            }
            return false;
        }
    }

    private class UserListAdapter
    extends BaseAdapter {
        ArrayList<UserListEntry> data;
        private ListFragment ctx;

        public UserListAdapter(ListFragment context) {
            this.ctx = context;
            this.data = new ArrayList();
        }

        public void setItems(ArrayList<UserListEntry> items) {
            this.data = items;
        }

        public UserListEntry buildItem(int type, String text, String count, int color2, int bg_color, int static_bg_color, boolean away, boolean last) {
            UserListEntry e = new UserListEntry();
            e.type = type;
            e.text = text;
            e.count = count;
            e.color = color2;
            e.bg_color = bg_color;
            e.static_bg_color = static_bg_color;
            e.away = away;
            e.last = last;
            return e;
        }

        public int getCount() {
            return this.data.size();
        }

        public Object getItem(int position) {
            return this.data.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            View row = convertView;
            if (position >= this.data.size()) {
                return row;
            }
            UserListEntry e = this.data.get(position);
            if (row == null) {
                LayoutInflater inflater = this.ctx.getLayoutInflater(null);
                row = inflater.inflate(2130903129, null);
                holder = new ViewHolder();
                holder.label = (TextView)row.findViewById(2131624189);
                holder.count = (TextView)row.findViewById(2131624203);
                holder.type = e.type;
                row.setTag((Object)holder);
            } else {
                holder = (ViewHolder)row.getTag();
            }
            row.setOnLongClickListener((View.OnLongClickListener)new OnItemLongClickListener(position));
            row.setOnClickListener((View.OnClickListener)new OnItemClickListener(position));
            holder.label.setText((CharSequence)e.text);
            if (e.type == 1 && e.away) {
                holder.label.setTextColor(UsersListFragment.this.getSafeResources().getColorStateList(2131492978));
            } else {
                holder.label.setTextColor(UsersListFragment.this.getSafeResources().getColorStateList(e.color));
            }
            row.setBackgroundResource(e.static_bg_color);
            if (e.type == 0) {
                if (e.count != null) {
                    holder.count.setVisibility(0);
                    holder.count.setText((CharSequence)e.count);
                    holder.count.setTextColor(UsersListFragment.this.getSafeResources().getColorStateList(e.color));
                } else {
                    holder.count.setVisibility(8);
                    holder.count.setText((CharSequence)"");
                }
                holder.label.setBackgroundDrawable(null);
                row.setFocusable(false);
                row.setEnabled(false);
                row.setPadding(0, 0, 0, 0);
            } else {
                holder.count.setVisibility(8);
                holder.count.setText((CharSequence)"");
                holder.label.setBackgroundResource(e.bg_color);
                row.setFocusable(true);
                row.setEnabled(true);
                if (e.last) {
                    row.setPadding(0, 0, 0, (int)TypedValue.applyDimension((int)2, (float)8.0f, (DisplayMetrics)UsersListFragment.this.getSafeResources().getDisplayMetrics()));
                } else {
                    row.setPadding(0, 0, 0, 0);
                }
            }
            return row;
        }

        private class UserListEntry {
            int type;
            String text;
            String count;
            int color;
            int bg_color;
            int static_bg_color;
            boolean away;
            boolean last;

            private UserListEntry() {
            }
        }

        private class ViewHolder {
            int type;
            TextView label;
            TextView count;

            private ViewHolder() {
            }
        }
    }
}

