/*
 * Decompiled with CFR 0.152.
 */
package com.irccloud.android.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.fasterxml.jackson.databind.JsonNode;
import com.irccloud.android.ColorFormatter;
import com.irccloud.android.IRCCloudApplication;
import com.irccloud.android.IRCCloudJSONObject;
import com.irccloud.android.data.ServersDataSource;
import com.squareup.leakcanary.RefWatcher;

public class WhoisFragment
extends DialogFragment {
    IRCCloudJSONObject event;
    TextView extra;
    TextView name;
    TextView mask;
    TextView server;
    TextView time;
    TextView timeTitle;
    TextView channels;
    TextView channelsTitle;
    TextView opChannels;
    TextView opTitle;
    TextView operChannels;
    TextView operTitle;
    TextView ownerChannels;
    TextView ownerTitle;
    TextView adminChannels;
    TextView adminTitle;
    TextView halfopChannels;
    TextView halfopTitle;
    TextView voicedChannels;
    TextView voicedTitle;
    TextView awayTitle;
    TextView away;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity ctx = this.getActivity();
        if (ctx == null) {
            return null;
        }
        LayoutInflater inflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        View v = inflater.inflate(2130903094, null);
        this.extra = (TextView)v.findViewById(2131624140);
        this.name = (TextView)v.findViewById(2131624050);
        this.mask = (TextView)v.findViewById(2131624136);
        this.server = (TextView)v.findViewById(2131624137);
        this.timeTitle = (TextView)v.findViewById(2131624138);
        this.time = (TextView)v.findViewById(2131624139);
        this.awayTitle = (TextView)v.findViewById(2131624134);
        this.away = (TextView)v.findViewById(2131624135);
        this.operTitle = (TextView)v.findViewById(2131624141);
        this.operChannels = (TextView)v.findViewById(2131624142);
        this.operChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.operChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.ownerTitle = (TextView)v.findViewById(2131624143);
        this.ownerChannels = (TextView)v.findViewById(2131624144);
        this.ownerChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.ownerChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.adminTitle = (TextView)v.findViewById(2131624145);
        this.adminChannels = (TextView)v.findViewById(2131624146);
        this.adminChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.adminChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.opTitle = (TextView)v.findViewById(2131624147);
        this.opChannels = (TextView)v.findViewById(2131624148);
        this.opChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.opChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.halfopTitle = (TextView)v.findViewById(2131624149);
        this.halfopChannels = (TextView)v.findViewById(2131624150);
        this.halfopChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.halfopChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.voicedTitle = (TextView)v.findViewById(2131624151);
        this.voicedChannels = (TextView)v.findViewById(2131624152);
        this.voicedChannels.setMovementMethod(LinkMovementMethod.getInstance());
        this.voicedChannels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        this.channelsTitle = (TextView)v.findViewById(2131624153);
        this.channels = (TextView)v.findViewById(2131624089);
        this.channels.setMovementMethod(LinkMovementMethod.getInstance());
        this.channels.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WhoisFragment.this.getDialog().dismiss();
            }
        });
        if (savedInstanceState != null && savedInstanceState.containsKey("event")) {
            this.event = new IRCCloudJSONObject(savedInstanceState.getString("event"));
        }
        AlertDialog d = new AlertDialog.Builder((Context)ctx).setInverseBackgroundForced(Build.VERSION.SDK_INT < 11).setTitle("WHOIS response for " + this.event.getString("user_nick")).setView(v).setNegativeButton("Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).create();
        return d;
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        state.putString("event", this.event.toString());
    }

    @Override
    public void setArguments(Bundle args) {
        this.event = new IRCCloudJSONObject(args.getString("event"));
    }

    private String format_duration(long duration) {
        if (duration > 2592000L) {
            return (int)(duration / 2592000L) + " months";
        }
        if (duration > 86400L) {
            return (int)(duration / 86400L) + " days";
        }
        if (duration > 3600L) {
            return (int)(duration / 3600L) + " hours";
        }
        if (duration > 60L) {
            return (int)(duration / 60L) + " minutes";
        }
        return duration + " seconds";
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.event != null) {
            String nick = this.event.getString("user_nick");
            String extratxt = "";
            if (this.event.has("op_nick")) {
                extratxt = extratxt + nick + " " + this.event.getString("op_msg") + "\n\n";
            }
            if (this.event.has("opername")) {
                extratxt = extratxt + nick + " " + this.event.getString("opername_msg") + " " + this.event.getString("opername") + "\n\n";
            }
            if (this.event.has("stats_dline")) {
                extratxt = extratxt + nick + " " + this.event.getString("stats_dline") + "\n\n";
            }
            if (this.event.has("userip")) {
                extratxt = extratxt + nick + " " + this.event.getString("userip") + "\n\n";
            }
            if (this.event.has("host")) {
                extratxt = extratxt + nick + " " + this.event.getString("host") + "\n\n";
            }
            if (this.event.has("bot_msg")) {
                extratxt = extratxt + nick + " " + this.event.getString("bot_msg") + "\n\n";
            }
            if (this.event.has("cgi")) {
                extratxt = extratxt + nick + " " + this.event.getString("cgi") + "\n\n";
            }
            if (this.event.has("help")) {
                extratxt = extratxt + nick + " " + this.event.getString("help") + "\n\n";
            }
            if (this.event.has("vworld")) {
                extratxt = extratxt + nick + " " + this.event.getString("vworld") + "\n\n";
            }
            if (this.event.has("modes")) {
                extratxt = extratxt + nick + " " + this.event.getString("modes") + "\n\n";
            }
            if (this.event.has("client_cert")) {
                extratxt = extratxt + nick + " " + this.event.getString("client_cert") + "\n\n";
            }
            if (this.event.has("secure")) {
                extratxt = extratxt + nick + " " + this.event.getString("secure") + "\n\n";
            }
            if (extratxt.length() > 0) {
                this.extra.setVisibility(0);
                this.extra.setText((CharSequence)extratxt.substring(0, extratxt.length() - 2));
            } else {
                this.extra.setVisibility(8);
            }
            if (this.event.has("user_realname")) {
                String nametxt = this.event.getString("user_realname");
                if (this.event.has("user_logged_in_as") && this.event.getString("user_logged_in_as").length() > 0) {
                    nametxt = nametxt + " (authed as " + this.event.getString("user_logged_in_as") + ")";
                }
                this.name.setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)nametxt)))));
            } else {
                this.name.setText((CharSequence)"");
            }
            this.mask.setText((CharSequence)(this.event.getString("user_username") + "@" + this.event.getString("user_host")));
            if (this.event.has("actual_host")) {
                this.mask.setText((CharSequence)(this.mask.getText() + "/" + this.event.getString("actual_host")));
            }
            String s = this.event.getString("server_addr");
            if (this.event.has("server_extra") && this.event.getString("server_extra").length() > 0) {
                s = s + " (" + this.event.getString("server_extra") + ")";
            }
            this.server.setText((CharSequence)s);
            if (this.event.has("signon_time")) {
                String timetxt = this.format_duration(System.currentTimeMillis() / 1000L - this.event.getLong("signon_time"));
                if (this.event.has("idle_secs") && this.event.getLong("idle_secs") > 0L) {
                    timetxt = timetxt + " (idle for " + this.format_duration(this.event.getLong("idle_secs")) + ")";
                }
                this.time.setText((CharSequence)timetxt);
                this.timeTitle.setVisibility(0);
                this.time.setVisibility(0);
            } else {
                this.timeTitle.setVisibility(8);
                this.time.setVisibility(8);
            }
            if (this.event.has("away") && this.event.getString("away").length() > 0) {
                this.away.setText((CharSequence)ColorFormatter.html_to_spanned(ColorFormatter.emojify(ColorFormatter.irc_to_html(TextUtils.htmlEncode((String)this.event.getString("away"))))));
                this.awayTitle.setVisibility(0);
                this.away.setVisibility(0);
            } else {
                this.awayTitle.setVisibility(8);
                this.away.setVisibility(8);
            }
            this.buildChannelList("channels_oper", this.operTitle, this.operChannels);
            this.buildChannelList("channels_owner", this.ownerTitle, this.ownerChannels);
            this.buildChannelList("channels_admin", this.adminTitle, this.adminChannels);
            this.buildChannelList("channels_op", this.opTitle, this.opChannels);
            this.buildChannelList("channels_halfop", this.halfopTitle, this.halfopChannels);
            this.buildChannelList("channels_voiced", this.voicedTitle, this.voicedChannels);
            this.buildChannelList("channels_member", this.channelsTitle, this.channels);
        }
    }

    private void buildChannelList(String field, TextView title, TextView channels) {
        if (this.event.has(field)) {
            title.setVisibility(0);
            channels.setVisibility(0);
            String channelstxt = "";
            JsonNode c = this.event.getJsonNode(field);
            for (int i = 0; i < c.size(); ++i) {
                String chan = c.get(i).asText();
                channelstxt = channelstxt + "\u2022 " + chan + "<br/>";
            }
            channels.setText((CharSequence)ColorFormatter.html_to_spanned(channelstxt, true, ServersDataSource.getInstance().getServer(this.event.cid())));
        } else {
            title.setVisibility(8);
            channels.setVisibility(8);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RefWatcher refWatcher = IRCCloudApplication.getRefWatcher((Context)this.getActivity());
        refWatcher.watch(this);
    }
}

