/*
 * Decompiled with CFR 0.152.
 */
package com.mobeta.android.dslv;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;

public class DragSortItemView
extends ViewGroup {
    private int mGravity = 48;

    public DragSortItemView(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getGravity() {
        return this.mGravity;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View child = this.getChildAt(0);
        if (child == null) {
            return;
        }
        if (this.mGravity == 48) {
            child.layout(0, 0, this.getMeasuredWidth(), child.getMeasuredHeight());
        } else {
            child.layout(0, this.getMeasuredHeight() - child.getMeasuredHeight(), this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        View child = this.getChildAt(0);
        if (child == null) {
            this.setMeasuredDimension(0, width);
            return;
        }
        if (child.isLayoutRequested()) {
            this.measureChild(child, widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
        if (heightMode == 0) {
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            height = lp.height > 0 ? lp.height : child.getMeasuredHeight();
        }
        this.setMeasuredDimension(width, height);
    }
}

