/*
 * Decompiled with CFR 0.152.
 */
package com.mobeta.android.dslv;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mobeta.android.dslv.DragSortController;
import com.mobeta.android.dslv.DragSortItemView;
import com.mobeta.android.dslv.DragSortItemViewCheckable;
import com.mobeta.android.dslv.R;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DragSortListView
extends ListView {
    private View mFloatView;
    private Point mFloatLoc = new Point();
    private Point mTouchLoc = new Point();
    private int mFloatViewMid;
    private boolean mFloatViewOnMeasured = false;
    private DataSetObserver mObserver;
    private float mFloatAlpha = 1.0f;
    private float mCurrFloatAlpha = 1.0f;
    private int mFloatPos;
    private int mFirstExpPos;
    private int mSecondExpPos;
    private boolean mAnimate = false;
    private int mSrcPos;
    private int mDragDeltaX;
    private int mDragDeltaY;
    private int mOffsetX;
    private int mOffsetY;
    private DragListener mDragListener;
    private DropListener mDropListener;
    private RemoveListener mRemoveListener;
    private boolean mDragEnabled = true;
    private int mDragState = 0;
    private int mItemHeightCollapsed = 1;
    private int mFloatViewHeight;
    private int mFloatViewHeightHalf;
    private int mWidthMeasureSpec = 0;
    private View[] mSampleViewTypes = new View[1];
    private DragScroller mDragScroller;
    private float mDragUpScrollStartFrac = 0.33333334f;
    private float mDragDownScrollStartFrac = 0.33333334f;
    private int mUpScrollStartY;
    private int mDownScrollStartY;
    private float mDownScrollStartYF;
    private float mUpScrollStartYF;
    private float mDragUpScrollHeight;
    private float mDragDownScrollHeight;
    private float mMaxScrollSpeed = 0.5f;
    private DragScrollProfile mScrollProfile = new DragScrollProfile(){

        @Override
        public float getSpeed(float w, long t) {
            return DragSortListView.this.mMaxScrollSpeed * w;
        }
    };
    private int mX;
    private int mY;
    private int mLastX;
    private int mLastY;
    private int mDragStartY;
    private int mDragFlags = 0;
    private boolean mLastCallWasIntercept = false;
    private boolean mInTouchEvent = false;
    private FloatViewManager mFloatViewManager = null;
    private MotionEvent mCancelEvent;
    private int mCancelMethod = 0;
    private float mSlideRegionFrac = 0.25f;
    private float mSlideFrac = 0.0f;
    private AdapterWrapper mAdapterWrapper;
    private boolean mTrackDragSort = false;
    private DragSortTracker mDragSortTracker;
    private boolean mBlockLayoutRequests = false;
    private boolean mIgnoreTouchEvent = false;
    private HeightCache mChildHeightCache = new HeightCache(3);
    private RemoveAnimator mRemoveAnimator;
    private LiftAnimator mLiftAnimator;
    private DropAnimator mDropAnimator;
    private boolean mUseRemoveVelocity;
    private float mRemoveVelocityX = 0.0f;
    private boolean mListViewIntercepted = false;
    private boolean mFloatViewInvalidated = false;

    public DragSortListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int defaultDuration;
        int removeAnimDuration = defaultDuration = 150;
        int dropAnimDuration = defaultDuration;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DragSortListView, 0, 0);
            this.mItemHeightCollapsed = Math.max(1, a.getDimensionPixelSize(0, 1));
            this.mTrackDragSort = a.getBoolean(5, false);
            if (this.mTrackDragSort) {
                this.mDragSortTracker = new DragSortTracker();
            }
            this.mCurrFloatAlpha = this.mFloatAlpha = a.getFloat(6, this.mFloatAlpha);
            this.mDragEnabled = a.getBoolean(10, this.mDragEnabled);
            this.mSlideRegionFrac = Math.max(0.0f, Math.min(1.0f, 1.0f - a.getFloat(7, 0.75f)));
            this.mAnimate = this.mSlideRegionFrac > 0.0f;
            float frac = a.getFloat(1, this.mDragUpScrollStartFrac);
            this.setDragScrollStart(frac);
            this.mMaxScrollSpeed = a.getFloat(2, this.mMaxScrollSpeed);
            removeAnimDuration = a.getInt(8, removeAnimDuration);
            dropAnimDuration = a.getInt(9, dropAnimDuration);
            boolean useDefault = a.getBoolean(17, true);
            if (useDefault) {
                boolean removeEnabled = a.getBoolean(12, false);
                int removeMode = a.getInt(4, 1);
                boolean sortEnabled = a.getBoolean(11, true);
                int dragInitMode = a.getInt(13, 0);
                int dragHandleId = a.getResourceId(14, 0);
                int flingHandleId = a.getResourceId(15, 0);
                int clickRemoveId = a.getResourceId(16, 0);
                int bgColor = a.getColor(3, -16777216);
                DragSortController controller = new DragSortController(this, dragHandleId, dragInitMode, removeMode, clickRemoveId, flingHandleId);
                controller.setRemoveEnabled(removeEnabled);
                controller.setSortEnabled(sortEnabled);
                controller.setBackgroundColor(bgColor);
                this.mFloatViewManager = controller;
                this.setOnTouchListener(controller);
            }
            a.recycle();
        }
        this.mDragScroller = new DragScroller();
        float smoothness = 0.5f;
        if (removeAnimDuration > 0) {
            this.mRemoveAnimator = new RemoveAnimator(smoothness, removeAnimDuration);
        }
        if (dropAnimDuration > 0) {
            this.mDropAnimator = new DropAnimator(smoothness, dropAnimDuration);
        }
        this.mCancelEvent = MotionEvent.obtain((long)0L, (long)0L, (int)3, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0);
        this.mObserver = new DataSetObserver(){

            private void cancel() {
                if (DragSortListView.this.mDragState == 4) {
                    DragSortListView.this.cancelDrag();
                }
            }

            public void onChanged() {
                this.cancel();
            }

            public void onInvalidated() {
                this.cancel();
            }
        };
    }

    public void setFloatAlpha(float alpha) {
        this.mCurrFloatAlpha = alpha;
    }

    public float getFloatAlpha() {
        return this.mCurrFloatAlpha;
    }

    public void setMaxScrollSpeed(float max) {
        this.mMaxScrollSpeed = max;
    }

    public void setAdapter(ListAdapter adapter) {
        if (adapter != null) {
            this.mAdapterWrapper = new AdapterWrapper(adapter);
            adapter.registerDataSetObserver(this.mObserver);
            if (adapter instanceof DropListener) {
                this.setDropListener((DropListener)adapter);
            }
            if (adapter instanceof DragListener) {
                this.setDragListener((DragListener)adapter);
            }
            if (adapter instanceof RemoveListener) {
                this.setRemoveListener((RemoveListener)adapter);
            }
        } else {
            this.mAdapterWrapper = null;
        }
        super.setAdapter((ListAdapter)this.mAdapterWrapper);
    }

    public ListAdapter getInputAdapter() {
        if (this.mAdapterWrapper == null) {
            return null;
        }
        return this.mAdapterWrapper.getAdapter();
    }

    private void drawDivider(int expPosition, Canvas canvas) {
        ViewGroup expItem;
        Drawable divider = this.getDivider();
        int dividerHeight = this.getDividerHeight();
        if (divider != null && dividerHeight != 0 && (expItem = (ViewGroup)this.getChildAt(expPosition - this.getFirstVisiblePosition())) != null) {
            int b;
            int t;
            int l = this.getPaddingLeft();
            int r = this.getWidth() - this.getPaddingRight();
            int childHeight = expItem.getChildAt(0).getHeight();
            if (expPosition > this.mSrcPos) {
                t = expItem.getTop() + childHeight;
                b = t + dividerHeight;
            } else {
                b = expItem.getBottom() - childHeight;
                t = b - dividerHeight;
            }
            canvas.save();
            canvas.clipRect(l, t, r, b);
            divider.setBounds(l, t, r, b);
            divider.draw(canvas);
            canvas.restore();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mDragState != 0) {
            if (this.mFirstExpPos != this.mSrcPos) {
                this.drawDivider(this.mFirstExpPos, canvas);
            }
            if (this.mSecondExpPos != this.mFirstExpPos && this.mSecondExpPos != this.mSrcPos) {
                this.drawDivider(this.mSecondExpPos, canvas);
            }
        }
        if (this.mFloatView != null) {
            float alphaMod;
            int w = this.mFloatView.getWidth();
            int h = this.mFloatView.getHeight();
            int x = this.mFloatLoc.x;
            int width = this.getWidth();
            if (x < 0) {
                x = -x;
            }
            if (x < width) {
                alphaMod = (float)(width - x) / (float)width;
                alphaMod *= alphaMod;
            } else {
                alphaMod = 0.0f;
            }
            int alpha = (int)(255.0f * this.mCurrFloatAlpha * alphaMod);
            canvas.save();
            canvas.translate((float)this.mFloatLoc.x, (float)this.mFloatLoc.y);
            canvas.clipRect(0, 0, w, h);
            canvas.saveLayerAlpha(0.0f, 0.0f, (float)w, (float)h, alpha, 31);
            this.mFloatView.draw(canvas);
            canvas.restore();
            canvas.restore();
        }
    }

    private int getItemHeight(int position) {
        View v = this.getChildAt(position - this.getFirstVisiblePosition());
        if (v != null) {
            return v.getHeight();
        }
        return this.calcItemHeight(position, this.getChildHeight(position));
    }

    private int getShuffleEdge(int position, int top) {
        int numHeaders = this.getHeaderViewsCount();
        int numFooters = this.getFooterViewsCount();
        if (position <= numHeaders || position >= this.getCount() - numFooters) {
            return top;
        }
        int divHeight = this.getDividerHeight();
        int maxBlankHeight = this.mFloatViewHeight - this.mItemHeightCollapsed;
        int childHeight = this.getChildHeight(position);
        int itemHeight = this.getItemHeight(position);
        int otop = top;
        if (this.mSecondExpPos <= this.mSrcPos) {
            if (position == this.mSecondExpPos && this.mFirstExpPos != this.mSecondExpPos) {
                if (position == this.mSrcPos) {
                    otop = top + itemHeight - this.mFloatViewHeight;
                } else {
                    int blankHeight = itemHeight - childHeight;
                    otop = top + blankHeight - maxBlankHeight;
                }
            } else if (position > this.mSecondExpPos && position <= this.mSrcPos) {
                otop = top - maxBlankHeight;
            }
        } else if (position > this.mSrcPos && position <= this.mFirstExpPos) {
            otop = top + maxBlankHeight;
        } else if (position == this.mSecondExpPos && this.mFirstExpPos != this.mSecondExpPos) {
            int blankHeight = itemHeight - childHeight;
            otop = top + blankHeight;
        }
        int edge = position <= this.mSrcPos ? otop + (this.mFloatViewHeight - divHeight - this.getChildHeight(position - 1)) / 2 : otop + (childHeight - divHeight - this.mFloatViewHeight) / 2;
        return edge;
    }

    private boolean updatePositions() {
        int itemPos;
        int edge;
        int startPos = this.mFirstExpPos;
        int first = this.getFirstVisiblePosition();
        View startView = this.getChildAt(startPos - first);
        if (startView == null) {
            startPos = first + this.getChildCount() / 2;
            startView = this.getChildAt(startPos - first);
        }
        int startTop = startView.getTop();
        int itemHeight = startView.getHeight();
        int lastEdge = edge = this.getShuffleEdge(startPos, startTop);
        int divHeight = this.getDividerHeight();
        int itemTop = startTop;
        if (this.mFloatViewMid < edge) {
            while (itemPos >= 0) {
                itemHeight = this.getItemHeight(--itemPos);
                if (itemPos == 0) {
                    edge = itemTop - divHeight - itemHeight;
                } else {
                    edge = this.getShuffleEdge(itemPos, itemTop -= itemHeight + divHeight);
                    if (this.mFloatViewMid < edge) {
                        lastEdge = edge;
                        continue;
                    }
                }
                break;
            }
        } else {
            int count = this.getCount();
            for (itemPos = startPos; itemPos < count; ++itemPos) {
                if (itemPos == count - 1) {
                    edge = itemTop + divHeight + itemHeight;
                } else {
                    itemHeight = this.getItemHeight(itemPos + 1);
                    edge = this.getShuffleEdge(itemPos + 1, itemTop += divHeight + itemHeight);
                    if (this.mFloatViewMid >= edge) {
                        lastEdge = edge;
                        continue;
                    }
                }
                break;
            }
        }
        int numHeaders = this.getHeaderViewsCount();
        int numFooters = this.getFooterViewsCount();
        boolean updated = false;
        int oldFirstExpPos = this.mFirstExpPos;
        int oldSecondExpPos = this.mSecondExpPos;
        float oldSlideFrac = this.mSlideFrac;
        if (this.mAnimate) {
            int edgeTop;
            int edgeBottom;
            int edgeToEdge = Math.abs(edge - lastEdge);
            if (this.mFloatViewMid < edge) {
                edgeBottom = edge;
                edgeTop = lastEdge;
            } else {
                edgeTop = edge;
                edgeBottom = lastEdge;
            }
            int slideRgnHeight = (int)(0.5f * this.mSlideRegionFrac * (float)edgeToEdge);
            float slideRgnHeightF = slideRgnHeight;
            int slideEdgeTop = edgeTop + slideRgnHeight;
            int slideEdgeBottom = edgeBottom - slideRgnHeight;
            if (this.mFloatViewMid < slideEdgeTop) {
                this.mFirstExpPos = itemPos - 1;
                this.mSecondExpPos = itemPos;
                this.mSlideFrac = 0.5f * (float)(slideEdgeTop - this.mFloatViewMid) / slideRgnHeightF;
            } else if (this.mFloatViewMid < slideEdgeBottom) {
                this.mFirstExpPos = itemPos;
                this.mSecondExpPos = itemPos;
            } else {
                this.mFirstExpPos = itemPos;
                this.mSecondExpPos = itemPos + 1;
                this.mSlideFrac = 0.5f * (1.0f + (float)(edgeBottom - this.mFloatViewMid) / slideRgnHeightF);
            }
        } else {
            this.mFirstExpPos = itemPos;
            this.mSecondExpPos = itemPos;
        }
        if (this.mFirstExpPos < numHeaders) {
            this.mFirstExpPos = itemPos = numHeaders;
            this.mSecondExpPos = itemPos;
        } else if (this.mSecondExpPos >= this.getCount() - numFooters) {
            this.mFirstExpPos = itemPos = this.getCount() - numFooters - 1;
            this.mSecondExpPos = itemPos;
        }
        if (this.mFirstExpPos != oldFirstExpPos || this.mSecondExpPos != oldSecondExpPos || this.mSlideFrac != oldSlideFrac) {
            updated = true;
        }
        if (itemPos != this.mFloatPos) {
            if (this.mDragListener != null) {
                this.mDragListener.drag(this.mFloatPos - numHeaders, itemPos - numHeaders);
            }
            this.mFloatPos = itemPos;
            updated = true;
        }
        return updated;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mTrackDragSort) {
            this.mDragSortTracker.appendState();
        }
    }

    public void removeItem(int which) {
        this.mUseRemoveVelocity = false;
        this.removeItem(which, 0.0f);
    }

    public void removeItem(int which, float velocityX) {
        if (this.mDragState == 0 || this.mDragState == 4) {
            if (this.mDragState == 0) {
                this.mFirstExpPos = this.mSrcPos = this.getHeaderViewsCount() + which;
                this.mSecondExpPos = this.mSrcPos;
                this.mFloatPos = this.mSrcPos;
                View v = this.getChildAt(this.mSrcPos - this.getFirstVisiblePosition());
                if (v != null) {
                    v.setVisibility(4);
                }
            }
            this.mDragState = 1;
            this.mRemoveVelocityX = velocityX;
            if (this.mInTouchEvent) {
                switch (this.mCancelMethod) {
                    case 1: {
                        super.onTouchEvent(this.mCancelEvent);
                        break;
                    }
                    case 2: {
                        super.onInterceptTouchEvent(this.mCancelEvent);
                    }
                }
            }
            if (this.mRemoveAnimator != null) {
                this.mRemoveAnimator.start();
            } else {
                this.doRemoveItem(which);
            }
        }
    }

    public void cancelDrag() {
        if (this.mDragState == 4) {
            this.mDragScroller.stopScrolling(true);
            this.destroyFloatView();
            this.clearPositions();
            this.adjustAllItems();
            this.mDragState = this.mInTouchEvent ? 3 : 0;
        }
    }

    private void clearPositions() {
        this.mSrcPos = -1;
        this.mFirstExpPos = -1;
        this.mSecondExpPos = -1;
        this.mFloatPos = -1;
    }

    private void dropFloatView() {
        this.mDragState = 2;
        if (this.mDropListener != null && this.mFloatPos >= 0 && this.mFloatPos < this.getCount()) {
            int numHeaders = this.getHeaderViewsCount();
            this.mDropListener.drop(this.mSrcPos - numHeaders, this.mFloatPos - numHeaders);
        }
        this.destroyFloatView();
        this.adjustOnReorder();
        this.clearPositions();
        this.adjustAllItems();
        this.mDragState = this.mInTouchEvent ? 3 : 0;
    }

    private void doRemoveItem() {
        this.doRemoveItem(this.mSrcPos - this.getHeaderViewsCount());
    }

    private void doRemoveItem(int which) {
        this.mDragState = 1;
        if (this.mRemoveListener != null) {
            this.mRemoveListener.remove(which);
        }
        this.destroyFloatView();
        this.adjustOnReorder();
        this.clearPositions();
        this.mDragState = this.mInTouchEvent ? 3 : 0;
    }

    private void adjustOnReorder() {
        int firstPos = this.getFirstVisiblePosition();
        if (this.mSrcPos < firstPos) {
            View v = this.getChildAt(0);
            int top = 0;
            if (v != null) {
                top = v.getTop();
            }
            this.setSelectionFromTop(firstPos - 1, top - this.getPaddingTop());
        }
    }

    public boolean stopDrag(boolean remove) {
        this.mUseRemoveVelocity = false;
        return this.stopDrag(remove, 0.0f);
    }

    public boolean stopDragWithVelocity(boolean remove, float velocityX) {
        this.mUseRemoveVelocity = true;
        return this.stopDrag(remove, velocityX);
    }

    public boolean stopDrag(boolean remove, float velocityX) {
        if (this.mFloatView != null) {
            this.mDragScroller.stopScrolling(true);
            if (remove) {
                this.removeItem(this.mSrcPos - this.getHeaderViewsCount(), velocityX);
            } else if (this.mDropAnimator != null) {
                this.mDropAnimator.start();
            } else {
                this.dropFloatView();
            }
            if (this.mTrackDragSort) {
                this.mDragSortTracker.stopTracking();
            }
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mIgnoreTouchEvent) {
            this.mIgnoreTouchEvent = false;
            return false;
        }
        if (!this.mDragEnabled) {
            return super.onTouchEvent(ev);
        }
        boolean more = false;
        boolean lastCallWasIntercept = this.mLastCallWasIntercept;
        this.mLastCallWasIntercept = false;
        if (!lastCallWasIntercept) {
            this.saveTouchCoords(ev);
        }
        if (this.mDragState == 4) {
            this.onDragTouchEvent(ev);
            more = true;
        } else {
            if (this.mDragState == 0 && super.onTouchEvent(ev)) {
                more = true;
            }
            int action = ev.getAction() & 0xFF;
            switch (action) {
                case 1: 
                case 3: {
                    this.doActionUpOrCancel();
                    break;
                }
                default: {
                    if (!more) break;
                    this.mCancelMethod = 1;
                }
            }
        }
        return more;
    }

    private void doActionUpOrCancel() {
        this.mCancelMethod = 0;
        this.mInTouchEvent = false;
        if (this.mDragState == 3) {
            this.mDragState = 0;
        }
        this.mCurrFloatAlpha = this.mFloatAlpha;
        this.mListViewIntercepted = false;
        this.mChildHeightCache.clear();
    }

    private void saveTouchCoords(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action != 0) {
            this.mLastX = this.mX;
            this.mLastY = this.mY;
        }
        this.mX = (int)ev.getX();
        this.mY = (int)ev.getY();
        if (action == 0) {
            this.mLastX = this.mX;
            this.mLastY = this.mY;
        }
        this.mOffsetX = (int)ev.getRawX() - this.mX;
        this.mOffsetY = (int)ev.getRawY() - this.mY;
    }

    public boolean listViewIntercepted() {
        return this.mListViewIntercepted;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mDragEnabled) {
            return super.onInterceptTouchEvent(ev);
        }
        this.saveTouchCoords(ev);
        this.mLastCallWasIntercept = true;
        int action = ev.getAction() & 0xFF;
        if (action == 0) {
            if (this.mDragState != 0) {
                this.mIgnoreTouchEvent = true;
                return true;
            }
            this.mInTouchEvent = true;
        }
        boolean intercept = false;
        if (this.mFloatView != null) {
            intercept = true;
        } else {
            if (super.onInterceptTouchEvent(ev)) {
                this.mListViewIntercepted = true;
                intercept = true;
            }
            switch (action) {
                case 1: 
                case 3: {
                    this.doActionUpOrCancel();
                    break;
                }
                default: {
                    this.mCancelMethod = intercept ? 1 : 2;
                }
            }
        }
        if (action == 1 || action == 3) {
            this.mInTouchEvent = false;
        }
        return intercept;
    }

    public void setDragScrollStart(float heightFraction) {
        this.setDragScrollStarts(heightFraction, heightFraction);
    }

    public void setDragScrollStarts(float upperFrac, float lowerFrac) {
        this.mDragDownScrollStartFrac = lowerFrac > 0.5f ? 0.5f : lowerFrac;
        this.mDragUpScrollStartFrac = upperFrac > 0.5f ? 0.5f : upperFrac;
        if (this.getHeight() != 0) {
            this.updateScrollStarts();
        }
    }

    private void continueDrag(int x, int y) {
        this.mFloatLoc.x = x - this.mDragDeltaX;
        this.mFloatLoc.y = y - this.mDragDeltaY;
        this.doDragFloatView(true);
        int minY = Math.min(y, this.mFloatViewMid + this.mFloatViewHeightHalf);
        int maxY = Math.max(y, this.mFloatViewMid - this.mFloatViewHeightHalf);
        int currentScrollDir = this.mDragScroller.getScrollDir();
        if (minY > this.mLastY && minY > this.mDownScrollStartY && currentScrollDir != 1) {
            if (currentScrollDir != -1) {
                this.mDragScroller.stopScrolling(true);
            }
            this.mDragScroller.startScrolling(1);
        } else if (maxY < this.mLastY && maxY < this.mUpScrollStartY && currentScrollDir != 0) {
            if (currentScrollDir != -1) {
                this.mDragScroller.stopScrolling(true);
            }
            this.mDragScroller.startScrolling(0);
        } else if (maxY >= this.mUpScrollStartY && minY <= this.mDownScrollStartY && this.mDragScroller.isScrolling()) {
            this.mDragScroller.stopScrolling(true);
        }
    }

    private void updateScrollStarts() {
        int padTop = this.getPaddingTop();
        int listHeight = this.getHeight() - padTop - this.getPaddingBottom();
        float heightF = listHeight;
        this.mUpScrollStartYF = (float)padTop + this.mDragUpScrollStartFrac * heightF;
        this.mDownScrollStartYF = (float)padTop + (1.0f - this.mDragDownScrollStartFrac) * heightF;
        this.mUpScrollStartY = (int)this.mUpScrollStartYF;
        this.mDownScrollStartY = (int)this.mDownScrollStartYF;
        this.mDragUpScrollHeight = this.mUpScrollStartYF - (float)padTop;
        this.mDragDownScrollHeight = (float)(padTop + listHeight) - this.mDownScrollStartYF;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateScrollStarts();
    }

    private void adjustAllItems() {
        int first = this.getFirstVisiblePosition();
        int last = this.getLastVisiblePosition();
        int begin = Math.max(0, this.getHeaderViewsCount() - first);
        int end = Math.min(last - first, this.getCount() - 1 - this.getFooterViewsCount() - first);
        for (int i = begin; i <= end; ++i) {
            View v = this.getChildAt(i);
            if (v == null) continue;
            this.adjustItem(first + i, v, false);
        }
    }

    private void adjustItem(int position, View v, boolean invalidChildHeight) {
        ViewGroup.LayoutParams lp = v.getLayoutParams();
        int height = position != this.mSrcPos && position != this.mFirstExpPos && position != this.mSecondExpPos ? -2 : this.calcItemHeight(position, v, invalidChildHeight);
        if (height != lp.height) {
            lp.height = height;
            v.setLayoutParams(lp);
        }
        if (position == this.mFirstExpPos || position == this.mSecondExpPos) {
            if (position < this.mSrcPos) {
                ((DragSortItemView)v).setGravity(80);
            } else if (position > this.mSrcPos) {
                ((DragSortItemView)v).setGravity(48);
            }
        }
        int oldVis = v.getVisibility();
        int vis = 0;
        if (position == this.mSrcPos && this.mFloatView != null) {
            vis = 4;
        }
        if (vis != oldVis) {
            v.setVisibility(vis);
        }
    }

    private int getChildHeight(int position) {
        if (position == this.mSrcPos) {
            return 0;
        }
        View v = this.getChildAt(position - this.getFirstVisiblePosition());
        if (v != null) {
            return this.getChildHeight(position, v, false);
        }
        int childHeight = this.mChildHeightCache.get(position);
        if (childHeight != -1) {
            return childHeight;
        }
        ListAdapter adapter = this.getAdapter();
        int type = adapter.getItemViewType(position);
        int typeCount = adapter.getViewTypeCount();
        if (typeCount != this.mSampleViewTypes.length) {
            this.mSampleViewTypes = new View[typeCount];
        }
        if (type >= 0) {
            if (this.mSampleViewTypes[type] == null) {
                this.mSampleViewTypes[type] = v = adapter.getView(position, null, (ViewGroup)this);
            } else {
                v = adapter.getView(position, this.mSampleViewTypes[type], (ViewGroup)this);
            }
        } else {
            v = adapter.getView(position, null, (ViewGroup)this);
        }
        childHeight = this.getChildHeight(position, v, true);
        this.mChildHeightCache.add(position, childHeight);
        return childHeight;
    }

    private int getChildHeight(int position, View item, boolean invalidChildHeight) {
        if (position == this.mSrcPos) {
            return 0;
        }
        View child = position < this.getHeaderViewsCount() || position >= this.getCount() - this.getFooterViewsCount() ? item : ((ViewGroup)item).getChildAt(0);
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp != null && lp.height > 0) {
            return lp.height;
        }
        int childHeight = child.getHeight();
        if (childHeight == 0 || invalidChildHeight) {
            this.measureItem(child);
            childHeight = child.getMeasuredHeight();
        }
        return childHeight;
    }

    private int calcItemHeight(int position, View item, boolean invalidChildHeight) {
        return this.calcItemHeight(position, this.getChildHeight(position, item, invalidChildHeight));
    }

    private int calcItemHeight(int position, int childHeight) {
        int divHeight = this.getDividerHeight();
        boolean isSliding = this.mAnimate && this.mFirstExpPos != this.mSecondExpPos;
        int maxNonSrcBlankHeight = this.mFloatViewHeight - this.mItemHeightCollapsed;
        int slideHeight = (int)(this.mSlideFrac * (float)maxNonSrcBlankHeight);
        int height = position == this.mSrcPos ? (this.mSrcPos == this.mFirstExpPos ? (isSliding ? slideHeight + this.mItemHeightCollapsed : this.mFloatViewHeight) : (this.mSrcPos == this.mSecondExpPos ? this.mFloatViewHeight - slideHeight : this.mItemHeightCollapsed)) : (position == this.mFirstExpPos ? (isSliding ? childHeight + slideHeight : childHeight + maxNonSrcBlankHeight) : (position == this.mSecondExpPos ? childHeight + maxNonSrcBlankHeight - slideHeight : childHeight));
        return height;
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    private int adjustScroll(int movePos, View moveItem, int oldFirstExpPos, int oldSecondExpPos) {
        int adjust = 0;
        int childHeight = this.getChildHeight(movePos);
        int moveHeightBefore = moveItem.getHeight();
        int moveHeightAfter = this.calcItemHeight(movePos, childHeight);
        int moveBlankBefore = moveHeightBefore;
        int moveBlankAfter = moveHeightAfter;
        if (movePos != this.mSrcPos) {
            moveBlankBefore -= childHeight;
            moveBlankAfter -= childHeight;
        }
        int maxBlank = this.mFloatViewHeight;
        if (this.mSrcPos != this.mFirstExpPos && this.mSrcPos != this.mSecondExpPos) {
            maxBlank -= this.mItemHeightCollapsed;
        }
        if (movePos <= oldFirstExpPos) {
            if (movePos > this.mFirstExpPos) {
                adjust += maxBlank - moveBlankAfter;
            }
        } else if (movePos == oldSecondExpPos) {
            adjust = movePos <= this.mFirstExpPos ? (adjust += moveBlankBefore - maxBlank) : (movePos == this.mSecondExpPos ? (adjust += moveHeightBefore - moveHeightAfter) : (adjust += moveBlankBefore));
        } else if (movePos <= this.mFirstExpPos) {
            adjust -= maxBlank;
        } else if (movePos == this.mSecondExpPos) {
            adjust -= moveBlankAfter;
        }
        return adjust;
    }

    private void measureItem(View item) {
        ViewGroup.LayoutParams lp = item.getLayoutParams();
        if (lp == null) {
            lp = new AbsListView.LayoutParams(-1, -2);
            item.setLayoutParams(lp);
        }
        int wspec = ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.getListPaddingLeft() + this.getListPaddingRight()), (int)lp.width);
        int hspec = lp.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        item.measure(wspec, hspec);
    }

    private void measureFloatView() {
        if (this.mFloatView != null) {
            this.measureItem(this.mFloatView);
            this.mFloatViewHeight = this.mFloatView.getMeasuredHeight();
            this.mFloatViewHeightHalf = this.mFloatViewHeight / 2;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mFloatView != null) {
            if (this.mFloatView.isLayoutRequested()) {
                this.measureFloatView();
            }
            this.mFloatViewOnMeasured = true;
        }
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.mFloatView != null) {
            if (this.mFloatView.isLayoutRequested() && !this.mFloatViewOnMeasured) {
                this.measureFloatView();
            }
            this.mFloatView.layout(0, 0, this.mFloatView.getMeasuredWidth(), this.mFloatView.getMeasuredHeight());
            this.mFloatViewOnMeasured = false;
        }
    }

    protected boolean onDragTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        switch (ev.getAction() & 0xFF) {
            case 3: {
                if (this.mDragState == 4) {
                    this.cancelDrag();
                }
                this.doActionUpOrCancel();
                break;
            }
            case 1: {
                if (this.mDragState == 4) {
                    this.stopDrag(false);
                }
                this.doActionUpOrCancel();
                break;
            }
            case 2: {
                this.continueDrag((int)ev.getX(), (int)ev.getY());
            }
        }
        return true;
    }

    public boolean startDrag(int position, int dragFlags, int deltaX, int deltaY) {
        if (!this.mInTouchEvent || this.mFloatViewManager == null) {
            return false;
        }
        View v = this.mFloatViewManager.onCreateFloatView(position);
        if (v == null) {
            return false;
        }
        return this.startDrag(position, v, dragFlags, deltaX, deltaY);
    }

    public boolean startDrag(int position, View floatView, int dragFlags, int deltaX, int deltaY) {
        int pos;
        if (this.mDragState != 0 || !this.mInTouchEvent || this.mFloatView != null || floatView == null || !this.mDragEnabled) {
            return false;
        }
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.mFirstExpPos = pos = position + this.getHeaderViewsCount();
        this.mSecondExpPos = pos;
        this.mSrcPos = pos;
        this.mFloatPos = pos;
        this.mDragState = 4;
        this.mDragFlags = 0;
        this.mDragFlags |= dragFlags;
        this.mFloatView = floatView;
        this.measureFloatView();
        this.mDragDeltaX = deltaX;
        this.mDragDeltaY = deltaY;
        this.mDragStartY = this.mY;
        this.mFloatLoc.x = this.mX - this.mDragDeltaX;
        this.mFloatLoc.y = this.mY - this.mDragDeltaY;
        View srcItem = this.getChildAt(this.mSrcPos - this.getFirstVisiblePosition());
        if (srcItem != null) {
            srcItem.setVisibility(4);
        }
        if (this.mTrackDragSort) {
            this.mDragSortTracker.startTracking();
        }
        switch (this.mCancelMethod) {
            case 1: {
                super.onTouchEvent(this.mCancelEvent);
                break;
            }
            case 2: {
                super.onInterceptTouchEvent(this.mCancelEvent);
            }
        }
        this.requestLayout();
        if (this.mLiftAnimator != null) {
            this.mLiftAnimator.start();
        }
        return true;
    }

    private void doDragFloatView(boolean forceInvalidate) {
        int movePos = this.getFirstVisiblePosition() + this.getChildCount() / 2;
        View moveItem = this.getChildAt(this.getChildCount() / 2);
        if (moveItem == null) {
            return;
        }
        this.doDragFloatView(movePos, moveItem, forceInvalidate);
    }

    private void doDragFloatView(int movePos, View moveItem, boolean forceInvalidate) {
        this.mBlockLayoutRequests = true;
        this.updateFloatView();
        int oldFirstExpPos = this.mFirstExpPos;
        int oldSecondExpPos = this.mSecondExpPos;
        boolean updated = this.updatePositions();
        if (updated) {
            this.adjustAllItems();
            int scroll = this.adjustScroll(movePos, moveItem, oldFirstExpPos, oldSecondExpPos);
            this.setSelectionFromTop(movePos, moveItem.getTop() + scroll - this.getPaddingTop());
            this.layoutChildren();
        }
        if (updated || forceInvalidate) {
            this.invalidate();
        }
        this.mBlockLayoutRequests = false;
    }

    private void updateFloatView() {
        if (this.mFloatViewManager != null) {
            this.mTouchLoc.set(this.mX, this.mY);
            this.mFloatViewManager.onDragFloatView(this.mFloatView, this.mFloatLoc, this.mTouchLoc);
        }
        int floatX = this.mFloatLoc.x;
        int floatY = this.mFloatLoc.y;
        int padLeft = this.getPaddingLeft();
        if ((this.mDragFlags & 1) == 0 && floatX > padLeft) {
            this.mFloatLoc.x = padLeft;
        } else if ((this.mDragFlags & 2) == 0 && floatX < padLeft) {
            this.mFloatLoc.x = padLeft;
        }
        int numHeaders = this.getHeaderViewsCount();
        int numFooters = this.getFooterViewsCount();
        int firstPos = this.getFirstVisiblePosition();
        int lastPos = this.getLastVisiblePosition();
        int topLimit = this.getPaddingTop();
        if (firstPos < numHeaders) {
            topLimit = this.getChildAt(numHeaders - firstPos - 1).getBottom();
        }
        if ((this.mDragFlags & 8) == 0 && firstPos <= this.mSrcPos) {
            topLimit = Math.max(this.getChildAt(this.mSrcPos - firstPos).getTop(), topLimit);
        }
        int bottomLimit = this.getHeight() - this.getPaddingBottom();
        if (lastPos >= this.getCount() - numFooters - 1) {
            bottomLimit = this.getChildAt(this.getCount() - numFooters - 1 - firstPos).getBottom();
        }
        if ((this.mDragFlags & 4) == 0 && lastPos >= this.mSrcPos) {
            bottomLimit = Math.min(this.getChildAt(this.mSrcPos - firstPos).getBottom(), bottomLimit);
        }
        if (floatY < topLimit) {
            this.mFloatLoc.y = topLimit;
        } else if (floatY + this.mFloatViewHeight > bottomLimit) {
            this.mFloatLoc.y = bottomLimit - this.mFloatViewHeight;
        }
        this.mFloatViewMid = this.mFloatLoc.y + this.mFloatViewHeightHalf;
    }

    private void destroyFloatView() {
        if (this.mFloatView != null) {
            this.mFloatView.setVisibility(8);
            if (this.mFloatViewManager != null) {
                this.mFloatViewManager.onDestroyFloatView(this.mFloatView);
            }
            this.mFloatView = null;
            this.invalidate();
        }
    }

    public void setFloatViewManager(FloatViewManager manager) {
        this.mFloatViewManager = manager;
    }

    public void setDragListener(DragListener l) {
        this.mDragListener = l;
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setDropListener(DropListener l) {
        this.mDropListener = l;
    }

    public void setRemoveListener(RemoveListener l) {
        this.mRemoveListener = l;
    }

    public void setDragSortListener(DragSortListener l) {
        this.setDropListener(l);
        this.setDragListener(l);
        this.setRemoveListener(l);
    }

    public void setDragScrollProfile(DragScrollProfile ssp) {
        if (ssp != null) {
            this.mScrollProfile = ssp;
        }
    }

    private class DragSortTracker {
        StringBuilder mBuilder = new StringBuilder();
        File mFile;
        private int mNumInBuffer = 0;
        private int mNumFlushes = 0;
        private boolean mTracking = false;

        public DragSortTracker() {
            File root = Environment.getExternalStorageDirectory();
            this.mFile = new File(root, "dslv_state.txt");
            if (!this.mFile.exists()) {
                try {
                    this.mFile.createNewFile();
                    Log.d((String)"mobeta", (String)"file created");
                }
                catch (IOException e) {
                    Log.w((String)"mobeta", (String)"Could not create dslv_state.txt");
                    Log.d((String)"mobeta", (String)e.getMessage());
                }
            }
        }

        public void startTracking() {
            this.mBuilder.append("<DSLVStates>\n");
            this.mNumFlushes = 0;
            this.mTracking = true;
        }

        public void appendState() {
            int i;
            if (!this.mTracking) {
                return;
            }
            this.mBuilder.append("<DSLVState>\n");
            int children = DragSortListView.this.getChildCount();
            int first = DragSortListView.this.getFirstVisiblePosition();
            this.mBuilder.append("    <Positions>");
            for (i = 0; i < children; ++i) {
                this.mBuilder.append(first + i).append(",");
            }
            this.mBuilder.append("</Positions>\n");
            this.mBuilder.append("    <Tops>");
            for (i = 0; i < children; ++i) {
                this.mBuilder.append(DragSortListView.this.getChildAt(i).getTop()).append(",");
            }
            this.mBuilder.append("</Tops>\n");
            this.mBuilder.append("    <Bottoms>");
            for (i = 0; i < children; ++i) {
                this.mBuilder.append(DragSortListView.this.getChildAt(i).getBottom()).append(",");
            }
            this.mBuilder.append("</Bottoms>\n");
            this.mBuilder.append("    <FirstExpPos>").append(DragSortListView.this.mFirstExpPos).append("</FirstExpPos>\n");
            this.mBuilder.append("    <FirstExpBlankHeight>").append(DragSortListView.this.getItemHeight(DragSortListView.this.mFirstExpPos) - DragSortListView.this.getChildHeight(DragSortListView.this.mFirstExpPos)).append("</FirstExpBlankHeight>\n");
            this.mBuilder.append("    <SecondExpPos>").append(DragSortListView.this.mSecondExpPos).append("</SecondExpPos>\n");
            this.mBuilder.append("    <SecondExpBlankHeight>").append(DragSortListView.this.getItemHeight(DragSortListView.this.mSecondExpPos) - DragSortListView.this.getChildHeight(DragSortListView.this.mSecondExpPos)).append("</SecondExpBlankHeight>\n");
            this.mBuilder.append("    <SrcPos>").append(DragSortListView.this.mSrcPos).append("</SrcPos>\n");
            this.mBuilder.append("    <SrcHeight>").append(DragSortListView.this.mFloatViewHeight + DragSortListView.this.getDividerHeight()).append("</SrcHeight>\n");
            this.mBuilder.append("    <ViewHeight>").append(DragSortListView.this.getHeight()).append("</ViewHeight>\n");
            this.mBuilder.append("    <LastY>").append(DragSortListView.this.mLastY).append("</LastY>\n");
            this.mBuilder.append("    <FloatY>").append(DragSortListView.this.mFloatViewMid).append("</FloatY>\n");
            this.mBuilder.append("    <ShuffleEdges>");
            for (i = 0; i < children; ++i) {
                this.mBuilder.append(DragSortListView.this.getShuffleEdge(first + i, DragSortListView.this.getChildAt(i).getTop())).append(",");
            }
            this.mBuilder.append("</ShuffleEdges>\n");
            this.mBuilder.append("</DSLVState>\n");
            ++this.mNumInBuffer;
            if (this.mNumInBuffer > 1000) {
                this.flush();
                this.mNumInBuffer = 0;
            }
        }

        public void flush() {
            if (!this.mTracking) {
                return;
            }
            try {
                boolean append = true;
                if (this.mNumFlushes == 0) {
                    append = false;
                }
                FileWriter writer = new FileWriter(this.mFile, append);
                writer.write(this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
                writer.flush();
                writer.close();
                ++this.mNumFlushes;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void stopTracking() {
            if (this.mTracking) {
                this.mBuilder.append("</DSLVStates>\n");
                this.flush();
                this.mTracking = false;
            }
        }
    }

    private class DragScroller
    implements Runnable {
        private boolean mAbort;
        private long mPrevTime;
        private long mCurrTime;
        private int dy;
        private float dt;
        private long tStart;
        private int scrollDir;
        private float mScrollSpeed;
        private boolean mScrolling = false;

        public boolean isScrolling() {
            return this.mScrolling;
        }

        public int getScrollDir() {
            return this.mScrolling ? this.scrollDir : -1;
        }

        public void startScrolling(int dir) {
            if (!this.mScrolling) {
                this.mAbort = false;
                this.mScrolling = true;
                this.mPrevTime = this.tStart = SystemClock.uptimeMillis();
                this.scrollDir = dir;
                DragSortListView.this.post(this);
            }
        }

        public void stopScrolling(boolean now) {
            if (now) {
                DragSortListView.this.removeCallbacks(this);
                this.mScrolling = false;
            } else {
                this.mAbort = true;
            }
        }

        @Override
        public void run() {
            int movePos;
            View v;
            if (this.mAbort) {
                this.mScrolling = false;
                return;
            }
            int first = DragSortListView.this.getFirstVisiblePosition();
            int last = DragSortListView.this.getLastVisiblePosition();
            int count = DragSortListView.this.getCount();
            int padTop = DragSortListView.this.getPaddingTop();
            int listHeight = DragSortListView.this.getHeight() - padTop - DragSortListView.this.getPaddingBottom();
            int minY = Math.min(DragSortListView.this.mY, DragSortListView.this.mFloatViewMid + DragSortListView.this.mFloatViewHeightHalf);
            int maxY = Math.max(DragSortListView.this.mY, DragSortListView.this.mFloatViewMid - DragSortListView.this.mFloatViewHeightHalf);
            if (this.scrollDir == 0) {
                v = DragSortListView.this.getChildAt(0);
                if (v == null) {
                    this.mScrolling = false;
                    return;
                }
                if (first == 0 && v.getTop() == padTop) {
                    this.mScrolling = false;
                    return;
                }
                this.mScrollSpeed = DragSortListView.this.mScrollProfile.getSpeed((DragSortListView.this.mUpScrollStartYF - (float)maxY) / DragSortListView.this.mDragUpScrollHeight, this.mPrevTime);
            } else {
                v = DragSortListView.this.getChildAt(last - first);
                if (v == null) {
                    this.mScrolling = false;
                    return;
                }
                if (last == count - 1 && v.getBottom() <= listHeight + padTop) {
                    this.mScrolling = false;
                    return;
                }
                this.mScrollSpeed = -DragSortListView.this.mScrollProfile.getSpeed(((float)minY - DragSortListView.this.mDownScrollStartYF) / DragSortListView.this.mDragDownScrollHeight, this.mPrevTime);
            }
            this.mCurrTime = SystemClock.uptimeMillis();
            this.dt = this.mCurrTime - this.mPrevTime;
            this.dy = Math.round(this.mScrollSpeed * this.dt);
            if (this.dy >= 0) {
                this.dy = Math.min(listHeight, this.dy);
                movePos = first;
            } else {
                this.dy = Math.max(-listHeight, this.dy);
                movePos = last;
            }
            View moveItem = DragSortListView.this.getChildAt(movePos - first);
            int top = moveItem.getTop() + this.dy;
            if (movePos == 0 && top > padTop) {
                top = padTop;
            }
            DragSortListView.this.mBlockLayoutRequests = true;
            DragSortListView.this.setSelectionFromTop(movePos, top - padTop);
            DragSortListView.this.layoutChildren();
            DragSortListView.this.invalidate();
            DragSortListView.this.mBlockLayoutRequests = false;
            DragSortListView.this.doDragFloatView(movePos, moveItem, false);
            this.mPrevTime = this.mCurrTime;
            DragSortListView.this.post(this);
        }
    }

    public static interface DragScrollProfile {
        public float getSpeed(float var1, long var2);
    }

    public static interface DragSortListener
    extends DragListener,
    DropListener,
    RemoveListener {
    }

    public static interface RemoveListener {
        public void remove(int var1);
    }

    public static interface DropListener {
        public void drop(int var1, int var2);
    }

    public static interface DragListener {
        public void drag(int var1, int var2);
    }

    public static interface FloatViewManager {
        public View onCreateFloatView(int var1);

        public void onDragFloatView(View var1, Point var2, Point var3);

        public void onDestroyFloatView(View var1);
    }

    private class RemoveAnimator
    extends SmoothAnimator {
        private float mFloatLocX;
        private float mFirstStartBlank;
        private float mSecondStartBlank;
        private int mFirstChildHeight;
        private int mSecondChildHeight;
        private int mFirstPos;
        private int mSecondPos;
        private int srcPos;

        public RemoveAnimator(float smoothness, int duration) {
            super(smoothness, duration);
            this.mFirstChildHeight = -1;
            this.mSecondChildHeight = -1;
        }

        @Override
        public void onStart() {
            this.mFirstChildHeight = -1;
            this.mSecondChildHeight = -1;
            this.mFirstPos = DragSortListView.this.mFirstExpPos;
            this.mSecondPos = DragSortListView.this.mSecondExpPos;
            this.srcPos = DragSortListView.this.mSrcPos;
            DragSortListView.this.mDragState = 1;
            this.mFloatLocX = ((DragSortListView)DragSortListView.this).mFloatLoc.x;
            if (DragSortListView.this.mUseRemoveVelocity) {
                float minVelocity = 2.0f * (float)DragSortListView.this.getWidth();
                if (DragSortListView.this.mRemoveVelocityX == 0.0f) {
                    DragSortListView.this.mRemoveVelocityX = (float)(this.mFloatLocX < 0.0f ? -1 : 1) * minVelocity;
                } else {
                    minVelocity *= 2.0f;
                    if (DragSortListView.this.mRemoveVelocityX < 0.0f && DragSortListView.this.mRemoveVelocityX > -minVelocity) {
                        DragSortListView.this.mRemoveVelocityX = -minVelocity;
                    } else if (DragSortListView.this.mRemoveVelocityX > 0.0f && DragSortListView.this.mRemoveVelocityX < minVelocity) {
                        DragSortListView.this.mRemoveVelocityX = minVelocity;
                    }
                }
            } else {
                DragSortListView.this.destroyFloatView();
            }
        }

        @Override
        public void onUpdate(float frac, float smoothFrac) {
            ViewGroup.LayoutParams lp;
            int blank;
            float f = 1.0f - smoothFrac;
            int firstVis = DragSortListView.this.getFirstVisiblePosition();
            View item = DragSortListView.this.getChildAt(this.mFirstPos - firstVis);
            if (DragSortListView.this.mUseRemoveVelocity) {
                float dt = (float)(SystemClock.uptimeMillis() - this.mStartTime) / 1000.0f;
                if (dt == 0.0f) {
                    return;
                }
                float dx = DragSortListView.this.mRemoveVelocityX * dt;
                int w = DragSortListView.this.getWidth();
                DragSortListView.this.mRemoveVelocityX += (float)(DragSortListView.this.mRemoveVelocityX > 0.0f ? 1 : -1) * dt * (float)w;
                this.mFloatLocX += dx;
                ((DragSortListView)DragSortListView.this).mFloatLoc.x = (int)this.mFloatLocX;
                if (this.mFloatLocX < (float)w && this.mFloatLocX > (float)(-w)) {
                    this.mStartTime = SystemClock.uptimeMillis();
                    DragSortListView.this.doDragFloatView(true);
                    return;
                }
            }
            if (item != null) {
                if (this.mFirstChildHeight == -1) {
                    this.mFirstChildHeight = DragSortListView.this.getChildHeight(this.mFirstPos, item, false);
                    this.mFirstStartBlank = item.getHeight() - this.mFirstChildHeight;
                }
                blank = Math.max((int)(f * this.mFirstStartBlank), 1);
                lp = item.getLayoutParams();
                lp.height = this.mFirstChildHeight + blank;
                item.setLayoutParams(lp);
            }
            if (this.mSecondPos != this.mFirstPos && (item = DragSortListView.this.getChildAt(this.mSecondPos - firstVis)) != null) {
                if (this.mSecondChildHeight == -1) {
                    this.mSecondChildHeight = DragSortListView.this.getChildHeight(this.mSecondPos, item, false);
                    this.mSecondStartBlank = item.getHeight() - this.mSecondChildHeight;
                }
                blank = Math.max((int)(f * this.mSecondStartBlank), 1);
                lp = item.getLayoutParams();
                lp.height = this.mSecondChildHeight + blank;
                item.setLayoutParams(lp);
            }
        }

        @Override
        public void onStop() {
            DragSortListView.this.doRemoveItem();
        }
    }

    private class DropAnimator
    extends SmoothAnimator {
        private int mDropPos;
        private int srcPos;
        private float mInitDeltaY;
        private float mInitDeltaX;

        public DropAnimator(float smoothness, int duration) {
            super(smoothness, duration);
        }

        @Override
        public void onStart() {
            this.mDropPos = DragSortListView.this.mFloatPos;
            this.srcPos = DragSortListView.this.mSrcPos;
            DragSortListView.this.mDragState = 2;
            this.mInitDeltaY = ((DragSortListView)DragSortListView.this).mFloatLoc.y - this.getTargetY();
            this.mInitDeltaX = ((DragSortListView)DragSortListView.this).mFloatLoc.x - DragSortListView.this.getPaddingLeft();
        }

        private int getTargetY() {
            int first = DragSortListView.this.getFirstVisiblePosition();
            int otherAdjust = (DragSortListView.this.mItemHeightCollapsed + DragSortListView.this.getDividerHeight()) / 2;
            View v = DragSortListView.this.getChildAt(this.mDropPos - first);
            int targetY = -1;
            if (v != null) {
                targetY = this.mDropPos == this.srcPos ? v.getTop() : (this.mDropPos < this.srcPos ? v.getTop() - otherAdjust : v.getBottom() + otherAdjust - DragSortListView.this.mFloatViewHeight);
            } else {
                this.cancel();
            }
            return targetY;
        }

        @Override
        public void onUpdate(float frac, float smoothFrac) {
            int targetY = this.getTargetY();
            int targetX = DragSortListView.this.getPaddingLeft();
            float deltaY = ((DragSortListView)DragSortListView.this).mFloatLoc.y - targetY;
            float deltaX = ((DragSortListView)DragSortListView.this).mFloatLoc.x - targetX;
            float f = 1.0f - smoothFrac;
            if (f < Math.abs(deltaY / this.mInitDeltaY) || f < Math.abs(deltaX / this.mInitDeltaX)) {
                ((DragSortListView)DragSortListView.this).mFloatLoc.y = targetY + (int)(this.mInitDeltaY * f);
                ((DragSortListView)DragSortListView.this).mFloatLoc.x = DragSortListView.this.getPaddingLeft() + (int)(this.mInitDeltaX * f);
                DragSortListView.this.doDragFloatView(true);
            }
        }

        @Override
        public void onStop() {
            DragSortListView.this.dropFloatView();
        }
    }

    private class LiftAnimator
    extends SmoothAnimator {
        private float mInitDragDeltaY;
        private float mFinalDragDeltaY;
        final /* synthetic */ DragSortListView this$0;

        @Override
        public void onStart() {
            this.mInitDragDeltaY = this.this$0.mDragDeltaY;
            this.mFinalDragDeltaY = this.this$0.mFloatViewHeightHalf;
        }

        @Override
        public void onUpdate(float frac, float smoothFrac) {
            if (this.this$0.mDragState != 4) {
                this.cancel();
            } else {
                this.this$0.mDragDeltaY = (int)(smoothFrac * this.mFinalDragDeltaY + (1.0f - smoothFrac) * this.mInitDragDeltaY);
                ((DragSortListView)this.this$0).mFloatLoc.y = this.this$0.mY - this.this$0.mDragDeltaY;
                this.this$0.doDragFloatView(true);
            }
        }
    }

    private class SmoothAnimator
    implements Runnable {
        protected long mStartTime;
        private float mDurationF;
        private float mAlpha;
        private float mA;
        private float mB;
        private float mC;
        private float mD;
        private boolean mCanceled;

        public SmoothAnimator(float smoothness, int duration) {
            this.mAlpha = smoothness;
            this.mDurationF = duration;
            this.mA = this.mD = 1.0f / (2.0f * this.mAlpha * (1.0f - this.mAlpha));
            this.mB = this.mAlpha / (2.0f * (this.mAlpha - 1.0f));
            this.mC = 1.0f / (1.0f - this.mAlpha);
        }

        public float transform(float frac) {
            if (frac < this.mAlpha) {
                return this.mA * frac * frac;
            }
            if (frac < 1.0f - this.mAlpha) {
                return this.mB + this.mC * frac;
            }
            return 1.0f - this.mD * (frac - 1.0f) * (frac - 1.0f);
        }

        public void start() {
            this.mStartTime = SystemClock.uptimeMillis();
            this.mCanceled = false;
            this.onStart();
            DragSortListView.this.post(this);
        }

        public void cancel() {
            this.mCanceled = true;
        }

        public void onStart() {
        }

        public void onUpdate(float frac, float smoothFrac) {
        }

        public void onStop() {
        }

        @Override
        public void run() {
            if (this.mCanceled) {
                return;
            }
            float fraction = (float)(SystemClock.uptimeMillis() - this.mStartTime) / this.mDurationF;
            if (fraction >= 1.0f) {
                this.onUpdate(1.0f, 1.0f);
                this.onStop();
            } else {
                this.onUpdate(fraction, this.transform(fraction));
                DragSortListView.this.post(this);
            }
        }
    }

    private class HeightCache {
        private SparseIntArray mMap;
        private ArrayList<Integer> mOrder;
        private int mMaxSize;

        public HeightCache(int size) {
            this.mMap = new SparseIntArray(size);
            this.mOrder = new ArrayList(size);
            this.mMaxSize = size;
        }

        public void add(int position, int height) {
            int currHeight = this.mMap.get(position, -1);
            if (currHeight != height) {
                if (currHeight == -1) {
                    if (this.mMap.size() == this.mMaxSize) {
                        this.mMap.delete(this.mOrder.remove(0).intValue());
                    }
                } else {
                    this.mOrder.remove((Object)position);
                }
                this.mMap.put(position, height);
                this.mOrder.add(position);
            }
        }

        public int get(int position) {
            return this.mMap.get(position, -1);
        }

        public void clear() {
            this.mMap.clear();
            this.mOrder.clear();
        }
    }

    private class AdapterWrapper
    extends BaseAdapter {
        private ListAdapter mAdapter;

        public AdapterWrapper(ListAdapter adapter) {
            this.mAdapter = adapter;
            this.mAdapter.registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    AdapterWrapper.this.notifyDataSetChanged();
                }

                public void onInvalidated() {
                    AdapterWrapper.this.notifyDataSetInvalidated();
                }
            });
        }

        public ListAdapter getAdapter() {
            return this.mAdapter;
        }

        public long getItemId(int position) {
            return this.mAdapter.getItemId(position);
        }

        public Object getItem(int position) {
            return this.mAdapter.getItem(position);
        }

        public int getCount() {
            return this.mAdapter.getCount();
        }

        public boolean areAllItemsEnabled() {
            return this.mAdapter.areAllItemsEnabled();
        }

        public boolean isEnabled(int position) {
            return this.mAdapter.isEnabled(position);
        }

        public int getItemViewType(int position) {
            return this.mAdapter.getItemViewType(position);
        }

        public int getViewTypeCount() {
            return this.mAdapter.getViewTypeCount();
        }

        public boolean hasStableIds() {
            return this.mAdapter.hasStableIds();
        }

        public boolean isEmpty() {
            return this.mAdapter.isEmpty();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            DragSortItemView v;
            if (convertView != null) {
                v = (DragSortItemView)convertView;
                View oldChild = v.getChildAt(0);
                View child = this.mAdapter.getView(position, oldChild, (ViewGroup)DragSortListView.this);
                if (child != oldChild) {
                    if (oldChild != null) {
                        v.removeViewAt(0);
                    }
                    v.addView(child);
                }
            } else {
                View child = this.mAdapter.getView(position, null, (ViewGroup)DragSortListView.this);
                v = child instanceof Checkable ? new DragSortItemViewCheckable(DragSortListView.this.getContext()) : new DragSortItemView(DragSortListView.this.getContext());
                v.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
                v.addView(child);
            }
            DragSortListView.this.adjustItem(position + DragSortListView.this.getHeaderViewsCount(), (View)v, true);
            return v;
        }
    }
}

