/*
 * Decompiled with CFR 0.152.
 */
package com.robobunny;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;

public class SeekBarPreference
extends Preference
implements SeekBar.OnSeekBarChangeListener {
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private int mMaxValue = 100;
    private int mMinValue = 0;
    private int mInterval = 1;
    private int mCurrentValue;
    private String mUnitsLeft = "";
    private String mUnitsRight = "";
    private SeekBar mSeekBar;
    private TextView mStatusText;

    public SeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPreference(context, attrs);
    }

    public SeekBarPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initPreference(context, attrs);
    }

    private void initPreference(Context context, AttributeSet attrs) {
        this.setValuesFromXml(attrs);
        this.mSeekBar = new SeekBar(context, attrs);
        this.mSeekBar.setMax(this.mMaxValue - this.mMinValue);
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.setWidgetLayoutResource(2130903131);
    }

    private void setValuesFromXml(AttributeSet attrs) {
        this.mMaxValue = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "max", 100);
        this.mMinValue = attrs.getAttributeIntValue("http://robobunny.com", "min", 0);
        this.mUnitsLeft = this.getAttributeStringValue(attrs, "http://robobunny.com", "unitsLeft", "");
        String units = this.getAttributeStringValue(attrs, "http://robobunny.com", "units", "");
        this.mUnitsRight = this.getAttributeStringValue(attrs, "http://robobunny.com", "unitsRight", units);
        try {
            String newInterval = attrs.getAttributeValue("http://robobunny.com", "interval");
            if (newInterval != null) {
                this.mInterval = Integer.parseInt(newInterval);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Invalid interval value", (Throwable)e);
        }
    }

    private String getAttributeStringValue(AttributeSet attrs, String namespace, String name, String defaultValue) {
        String value = attrs.getAttributeValue(namespace, name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected View onCreateView(ViewGroup parent) {
        View view = super.onCreateView(parent);
        LinearLayout layout2 = (LinearLayout)view;
        layout2.setOrientation(1);
        return view;
    }

    public void onBindView(View view) {
        super.onBindView(view);
        if (view != null) {
            this.mSeekBar = (SeekBar)view.findViewById(2131624208);
            this.mSeekBar.setMax(this.mMaxValue - this.mMinValue);
            this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        }
        this.updateView(view);
    }

    protected void updateView(View view) {
        try {
            this.mStatusText = (TextView)view.findViewById(2131624205);
            this.mStatusText.setText((CharSequence)String.valueOf(this.mCurrentValue));
            this.mStatusText.setMinimumWidth(30);
            this.mSeekBar.setProgress(this.mCurrentValue - this.mMinValue);
            TextView unitsRight = (TextView)view.findViewById(2131624204);
            unitsRight.setText((CharSequence)this.mUnitsRight);
            TextView unitsLeft = (TextView)view.findViewById(2131624206);
            unitsLeft.setText((CharSequence)this.mUnitsLeft);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error updating seek bar preference", (Throwable)e);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        int newValue = progress + this.mMinValue;
        if (newValue > this.mMaxValue) {
            newValue = this.mMaxValue;
        } else if (newValue < this.mMinValue) {
            newValue = this.mMinValue;
        } else if (this.mInterval != 1 && newValue % this.mInterval != 0) {
            newValue = Math.round((float)newValue / (float)this.mInterval) * this.mInterval;
        }
        if (!this.callChangeListener(newValue)) {
            seekBar.setProgress(this.mCurrentValue - this.mMinValue);
            return;
        }
        this.mCurrentValue = newValue;
        this.mStatusText.setText((CharSequence)String.valueOf(newValue));
        this.persistInt(newValue);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        this.notifyChanged();
    }

    protected Object onGetDefaultValue(TypedArray ta, int index) {
        int defaultValue = ta.getInt(index, 50);
        return defaultValue;
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        if (restoreValue) {
            this.mCurrentValue = this.getPersistedInt(this.mCurrentValue);
        } else {
            int temp = 0;
            try {
                temp = (Integer)defaultValue;
            }
            catch (Exception ex) {
                Log.e((String)this.TAG, (String)("Invalid default value: " + defaultValue.toString()));
            }
            this.persistInt(temp);
            this.mCurrentValue = temp;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSeekBar.setEnabled(enabled);
    }

    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        super.onDependencyChanged(dependency, disableDependent);
        if (this.mSeekBar != null) {
            this.mSeekBar.setEnabled(!disableDependent);
        }
    }
}

