/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import com.sonyericsson.extras.liveware.aef.registration.Registration;
import com.sonyericsson.extras.liveware.extension.util.Dbg;
import com.sonyericsson.extras.liveware.extension.util.control.ControlExtension;
import com.sonyericsson.extras.liveware.extension.util.control.ControlTouchEvent;
import com.sonyericsson.extras.liveware.extension.util.registration.IRegisterCallback;
import com.sonyericsson.extras.liveware.extension.util.registration.RegisterExtensionTask;
import com.sonyericsson.extras.liveware.extension.util.registration.RegistrationInformation;
import com.sonyericsson.extras.liveware.extension.util.widget.WidgetExtension;
import java.util.HashMap;

public abstract class ExtensionService
extends Service
implements IRegisterCallback {
    public static final int INVALID_ID = -1;
    private RegisterExtensionTask mRegisterTask = null;
    private final String mExtensionKey;
    private RegistrationInformation mRegistrationInformation;
    private HashMap<String, WidgetExtension> mWidgets = new HashMap();
    private HashMap<String, ControlExtension> mControls = new HashMap();
    private int mStartId;
    private Handler mHandler;
    private boolean mPendingNewRegistration = false;
    private boolean mUpdateSourceRegistration = true;

    public ExtensionService(String extensionKey) {
        if (extensionKey == null) {
            throw new IllegalArgumentException("extensionKey == null");
        }
        this.mExtensionKey = extensionKey;
    }

    public void onCreate() {
        super.onCreate();
        this.mRegistrationInformation = this.getRegistrationInformation();
        if (this.mRegistrationInformation == null) {
            throw new IllegalArgumentException("registrationInformation == null");
        }
        this.mUpdateSourceRegistration = this.mRegistrationInformation.isSourcesToBeUpdatedAtServiceCreation();
        this.mHandler = new Handler();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onStart(Intent intent, int startId) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            IntentRunner runner = new IntentRunner(intent, startId){

                @Override
                public void run() {
                    ExtensionService.this.mStartId = this.mRunnerStartId;
                    String action = this.mIntent.getAction();
                    if ("com.sonyericsson.extras.liveware.aef.registration.EXTENSION_REGISTER_REQUEST".equals(action)) {
                        ExtensionService.this.onRegisterRequest();
                    } else if ("android.intent.action.LOCALE_CHANGED".equals(action)) {
                        ExtensionService.this.onLocaleChanged();
                        ExtensionService.this.stopSelfCheck();
                    } else if ("com.sonyericsson.extras.liveware.aef.registration.ACCESSORY_CONNECTION".equals(action)) {
                        int status = this.mIntent.getIntExtra("connnection_status", -1);
                        ExtensionService.this.onConnectionChanged(status == 1);
                        if (status == 0) {
                            ExtensionService.this.stopSelfCheck();
                        } else {
                            ExtensionService.this.stopSelfCheck(true);
                        }
                    } else if ("com.sonyericsson.extras.liveware.aef.notification.VIEW_EVENT_DETAIL".equals(action) || "com.sonyericsson.extras.liveware.aef.notification.REFRESH_REQUEST".equals(action)) {
                        ExtensionService.this.handleNotificationIntent(this.mIntent);
                        ExtensionService.this.stopSelfCheck(true);
                    } else if ("com.sonyericsson.extras.aef.widget.START_REFRESH_IMAGE_REQUEST".equals(action) || "com.sonyericsson.extras.aef.widget.STOP_REFRESH_IMAGE_REQUEST".equals(action) || "com.sonyericsson.extras.aef.widget.ONTOUCH".equals(action) || "com.sonyericsson.extras.liveware.extension.util.widget.scheduled.refresh".equals(action)) {
                        ExtensionService.this.handleWidgetIntent(this.mIntent);
                        ExtensionService.this.stopSelfCheck(true);
                    } else if ("com.sonyericsson.extras.aef.control.START".equals(action) || "com.sonyericsson.extras.aef.control.STOP".equals(action) || "com.sonyericsson.extras.aef.control.RESUME".equals(action) || "com.sonyericsson.extras.aef.control.PAUSE".equals(action) || "com.sonyericsson.extras.aef.control.ERROR".equals(action) || "com.sonyericsson.extras.aef.control.KEY_EVENT".equals(action) || "com.sonyericsson.extras.aef.control.TOUCH_EVENT".equals(action) || "com.sonyericsson.extras.aef.control.SWIPE_EVENT".equals(action)) {
                        ExtensionService.this.handleControlIntent(this.mIntent);
                        ExtensionService.this.stopSelfCheck(true);
                    }
                }
            };
            this.mHandler.post((Runnable)runner);
        }
        return 1;
    }

    public void onDestroy() {
        if (this.mRegisterTask != null) {
            this.mRegisterTask.setRegisterInterface(null);
            this.mRegisterTask.cancel(true);
            this.mRegisterTask = null;
        }
        this.destroyAllWidgets();
        this.destroyAllControls();
        super.onDestroy();
    }

    protected void onLocaleChanged() {
        this.registerOrUpdate(false);
    }

    protected void onConnectionChanged(boolean connected) {
    }

    protected void onRegisterRequest() {
        this.registerOrUpdate(false);
    }

    protected void registerOrUpdate(boolean onlySources) {
        this.mUpdateSourceRegistration = false;
        if (this.mRegisterTask != null) {
            Dbg.d("Registration already on-going. Queueing new request.");
            this.mPendingNewRegistration = true;
            return;
        }
        this.mRegisterTask = new RegisterExtensionTask((Context)this, this.mRegistrationInformation, this, onlySources);
        this.mRegisterTask.execute(new Void[0]);
        this.mPendingNewRegistration = false;
    }

    @Override
    public final void onExtensionRegisterResult(boolean onlySources, boolean success) {
        this.mRegisterTask = null;
        if (this.mPendingNewRegistration) {
            this.registerOrUpdate(false);
        } else {
            if (onlySources) {
                this.onSourceRefreshResult(success);
            } else {
                this.onRegisterResult(success);
            }
            this.stopSelfCheck();
        }
    }

    public void onRegisterResult(boolean success) {
    }

    public void onSourceRefreshResult(boolean success) {
    }

    protected void onViewEvent(Intent intent) {
    }

    protected void onRefreshRequest() {
    }

    protected abstract RegistrationInformation getRegistrationInformation();

    protected abstract boolean keepRunningWhenConnected();

    private final void stopSelfCheck(boolean accessoryConnected) {
        Dbg.d("stopSelfCheck: " + accessoryConnected);
        if (this.mRegisterTask != null) {
            Dbg.d("registration on-going not stopping");
            return;
        }
        if (this.mUpdateSourceRegistration) {
            this.registerOrUpdate(true);
            return;
        }
        if (!accessoryConnected) {
            this.stopSelf(this.mStartId);
            return;
        }
        if (this.mWidgets.size() > 0) {
            Dbg.d("widget is visible. Not stopping");
            return;
        }
        if (this.mControls.size() > 0) {
            Dbg.d("control is visible. Not stopping");
            return;
        }
        if (!this.keepRunningWhenConnected()) {
            this.stopSelf(this.mStartId);
            return;
        }
        Dbg.d("keep running when connected. Not stopping");
    }

    protected final void stopSelfCheck() {
        this.stopSelfCheck(this.areAnyAccessoriesConnected());
    }

    public WidgetExtension createWidgetExtension(String hostAppPackageName) {
        throw new IllegalArgumentException("createWidgetExtension() not implemented. Widget extensions must override this method");
    }

    public void doActionOnAllWidgets(int requestCode, Bundle bundle) {
        for (WidgetExtension widget : this.mWidgets.values()) {
            widget.onDoAction(requestCode, bundle);
        }
    }

    public boolean doActionOnWidget(int requestCode, String hostAppPackageName, Bundle bundle) {
        WidgetExtension widget = this.mWidgets.get(hostAppPackageName);
        if (widget != null) {
            widget.onDoAction(requestCode, bundle);
            return true;
        }
        return false;
    }

    public void destroyAllWidgets() {
        for (WidgetExtension widget : this.mWidgets.values()) {
            widget.destroy();
        }
    }

    public ControlExtension createControlExtension(String hostAppPackageName) {
        throw new IllegalArgumentException("createControlExtension() not implemented. Control extensions must override this method");
    }

    public void doActionOnAllControls(int requestCode, Bundle bundle) {
        for (ControlExtension control : this.mControls.values()) {
            control.onDoAction(requestCode, bundle);
        }
    }

    public boolean doActionOnControl(int requestCode, String hostAppPackageName, Bundle bundle) {
        ControlExtension control = this.mControls.get(hostAppPackageName);
        if (control != null) {
            control.onDoAction(requestCode, bundle);
            return true;
        }
        return false;
    }

    public void destroyAllControls() {
        for (ControlExtension control : this.mControls.values()) {
            control.destroy();
        }
    }

    private final void handleNotificationIntent(Intent intent) {
        String action = intent.getAction();
        if (!this.mExtensionKey.equals(intent.getStringExtra("extension_key"))) {
            Dbg.w("Invalid extension key: " + intent.getStringExtra("extension_key"));
            return;
        }
        if ("com.sonyericsson.extras.liveware.aef.notification.VIEW_EVENT_DETAIL".equals(action)) {
            this.onViewEvent(intent);
        } else if ("com.sonyericsson.extras.liveware.aef.notification.REFRESH_REQUEST".equals(action)) {
            this.onRefreshRequest();
        }
    }

    private final void handleWidgetIntent(Intent intent) {
        String action = intent.getAction();
        Dbg.d("Received intent: " + action);
        if (!this.mExtensionKey.equals(intent.getStringExtra("extension_key"))) {
            Dbg.w("Invalid extension key: " + intent.getStringExtra("extension_key"));
            return;
        }
        String hostAppPackageName = intent.getStringExtra("aha_package_name");
        WidgetExtension widget = this.mWidgets.get(hostAppPackageName);
        if (widget == null) {
            if ("com.sonyericsson.extras.aef.widget.STOP_REFRESH_IMAGE_REQUEST".equals(action)) {
                Dbg.w("No widget object for: " + hostAppPackageName + ". Ignoring stop.");
                return;
            }
            if ("com.sonyericsson.extras.liveware.extension.util.widget.scheduled.refresh".equals(action)) {
                Dbg.d("No widget object for: " + hostAppPackageName + ". Ignoring scheduled refersh.");
                return;
            }
            if (!"com.sonyericsson.extras.aef.widget.START_REFRESH_IMAGE_REQUEST".equals(action)) {
                Dbg.w("No widget object for: " + hostAppPackageName + ". Creating one.");
            }
            widget = this.createWidgetExtension(hostAppPackageName);
            this.mWidgets.put(hostAppPackageName, widget);
            widget.startRefresh();
        } else if ("com.sonyericsson.extras.aef.widget.START_REFRESH_IMAGE_REQUEST".equals(action)) {
            Dbg.w("Ignoring start for: " + hostAppPackageName + ". Already started.");
        }
        if ("com.sonyericsson.extras.aef.widget.STOP_REFRESH_IMAGE_REQUEST".equals(action)) {
            widget.stopRefresh();
            widget.destroy();
            this.mWidgets.remove(hostAppPackageName);
        } else if ("com.sonyericsson.extras.liveware.extension.util.widget.scheduled.refresh".equals(action)) {
            widget.onScheduledRefresh();
        } else if ("com.sonyericsson.extras.aef.widget.ONTOUCH".equals(action)) {
            int type = intent.getIntExtra("widget_event_type", -1);
            int x = intent.getIntExtra("widget_event_x_pos", -1);
            int y = intent.getIntExtra("widget_event_y_pos", -1);
            Dbg.v("Widget on touch type: " + type + " x: " + x + " y: " + y);
            if (type == -1) {
                Dbg.e("Invalid type: " + type);
                return;
            }
            if (x == -1) {
                Dbg.e("Invalid x pos: " + x);
                return;
            }
            if (y == -1) {
                Dbg.e("Invalid y pos: " + y);
                return;
            }
            widget.onTouch(type, x, y);
        }
    }

    private final void handleControlIntent(Intent intent) {
        if (!this.mExtensionKey.equals(intent.getStringExtra("extension_key"))) {
            Dbg.w("Invalid extension key: " + intent.getStringExtra("extension_key"));
            return;
        }
        String action = intent.getAction();
        String hostAppPackageName = intent.getStringExtra("aha_package_name");
        ControlExtension control = this.mControls.get(hostAppPackageName);
        if (control == null) {
            if ("com.sonyericsson.extras.aef.control.STOP".equals(action)) {
                Dbg.w("No control object for: " + hostAppPackageName + ". Ignoring stop.");
                return;
            }
            if ("com.sonyericsson.extras.aef.control.ERROR".equals(action)) {
                this.onControlError(hostAppPackageName, intent.getIntExtra("error_code", -1));
                return;
            }
            control = this.createControlExtension(hostAppPackageName);
            this.mControls.put(hostAppPackageName, control);
            control.start();
            if (!"com.sonyericsson.extras.aef.control.START".equals(action)) {
                Dbg.w("No control object for: " + hostAppPackageName + ". Creating one.");
                if (!"com.sonyericsson.extras.aef.control.PAUSE".equals(action)) {
                    Dbg.w("Calling faked resume");
                    control.resume();
                }
            }
        } else if ("com.sonyericsson.extras.aef.control.START".equals(action)) {
            Dbg.w("Ignoring start for: " + hostAppPackageName + ". Already started.");
        }
        if ("com.sonyericsson.extras.aef.control.STOP".equals(action)) {
            control.stop();
            control.destroy();
            this.mControls.remove(hostAppPackageName);
        } else if ("com.sonyericsson.extras.aef.control.RESUME".equals(action)) {
            control.resume();
        } else if ("com.sonyericsson.extras.aef.control.PAUSE".equals(action)) {
            control.pause();
        } else if ("com.sonyericsson.extras.aef.control.ERROR".equals(action)) {
            control.onError(intent.getIntExtra("error_code", -1));
        } else if ("com.sonyericsson.extras.aef.control.KEY_EVENT".equals(action)) {
            control.onKey(intent.getIntExtra("event_type", -1), intent.getIntExtra("key_code", -1), intent.getLongExtra("timestamp", 0L));
        } else if ("com.sonyericsson.extras.aef.control.TOUCH_EVENT".equals(action)) {
            ControlTouchEvent event = new ControlTouchEvent(intent.getIntExtra("action", -1), intent.getLongExtra("timestamp", 0L), intent.getIntExtra("x_pos", -1), intent.getIntExtra("y_pos", -1));
            control.onTouch(event);
        } else if ("com.sonyericsson.extras.aef.control.SWIPE_EVENT".equals(action)) {
            control.onSwipe(intent.getIntExtra("direction", -1));
        }
    }

    protected boolean areAnyAccessoriesConnected() {
        try (Cursor cursor = null;){
            cursor = this.getContentResolver().query(Registration.Device.URI, null, "accessory_connected = 1", null, null);
            if (cursor != null) {
                boolean bl = cursor.getCount() > 0;
                return bl;
            }
        }
        return false;
    }

    protected void controlStartRequest(String hostAppPackageName) {
        Intent intent = new Intent("com.sonyericsson.extras.aef.control.START_REQUEST");
        intent.putExtra("aea_package_name", this.getPackageName());
        intent.setPackage(hostAppPackageName);
        this.sendBroadcast(intent, "com.sonyericsson.extras.liveware.aef.HOSTAPP_PERMISSION");
    }

    protected void onControlError(String hostAppPackageName, int errorCode) {
    }

    private class IntentRunner
    implements Runnable {
        protected Intent mIntent;
        protected int mRunnerStartId;

        IntentRunner(Intent intent, int startId) {
            this.mIntent = intent;
            this.mRunnerStartId = startId;
        }

        @Override
        public void run() {
        }
    }
}

