/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import com.sonyericsson.extras.liveware.aef.registration.Registration;
import com.sonyericsson.extras.liveware.extension.util.Dbg;

public class ExtensionUtils {
    public static String getUriString(Context context, int resourceId) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        return new Uri.Builder().scheme("android.resource").authority(context.getPackageName()).appendPath(Integer.toString(resourceId)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getExtensionId(Context context) {
        Cursor cursor = null;
        long id2 = -1L;
        String selection = "packageName = ?";
        String[] selectionArgs = new String[]{context.getPackageName()};
        try {
            cursor = context.getContentResolver().query(Registration.Extension.URI, null, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int idIndex = cursor.getColumnIndex("_id");
                id2 = cursor.getLong(idIndex);
            }
        }
        catch (SQLException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        catch (SecurityException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        catch (IllegalArgumentException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRegistrationId(Context context, String hostAppPackageName, long extensionId) {
        Cursor cursor = null;
        long id2 = -1L;
        String selection = "hostAppPackageName = ? AND extensionId = ?";
        String[] selectionArgs = new String[]{hostAppPackageName, Long.toString(extensionId)};
        try {
            cursor = context.getContentResolver().query(Registration.ApiRegistration.URI, null, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int idIndex = cursor.getColumnIndex("_id");
                id2 = cursor.getLong(idIndex);
            }
        }
        catch (SQLException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        catch (SecurityException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        catch (IllegalArgumentException exception) {
            Dbg.e("Failed to query extension", exception);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return id2;
    }
}

