/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.control;

import android.os.Bundle;
import com.sonyericsson.extras.liveware.extension.util.control.ControlTouchEvent;

public abstract class ControlExtension {
    private int mState;

    public final void start() {
        this.mState = 1;
        this.onStart();
    }

    public final void resume() {
        this.mState = 2;
        this.onResume();
    }

    public final void pause() {
        this.mState = 1;
        this.onPause();
    }

    public final void stop() {
        if (this.mState == 2) {
            this.pause();
        }
        this.mState = 0;
        this.onStop();
    }

    public final void destroy() {
        if (this.mState == 2) {
            this.pause();
        }
        if (this.mState == 1) {
            this.stop();
        }
        this.onDestroy();
    }

    public void onDoAction(int requestCode, Bundle bundle) {
    }

    public void onDestroy() {
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onError(int code) {
    }

    public void onKey(int action, int keyCode, long timeStamp) {
    }

    public void onTouch(ControlTouchEvent event) {
    }

    public void onSwipe(int direction) {
    }
}

