/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.notification;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.text.TextUtils;
import com.sonyericsson.extras.liveware.aef.notification.Notification;
import java.util.ArrayList;

public class NotificationUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSourceId(Context context, String extensionSpecificId) {
        long sourceId = -1L;
        Cursor cursor = null;
        String whereClause = null;
        if (extensionSpecificId != null) {
            whereClause = "extension_specific_id = '" + extensionSpecificId + "'";
        }
        try {
            cursor = NotificationUtil.querySources(context, new String[]{"_id", "extension_specific_id"}, whereClause, null, null);
            if (cursor == null) {
                long l = -1L;
                return l;
            }
            if (cursor.moveToFirst()) {
                sourceId = cursor.getLong(cursor.getColumnIndex("_id"));
            }
        }
        catch (SQLException exception) {
            long l = -1L;
            return l;
        }
        catch (SecurityException exception) {
            long l = -1L;
            return l;
        }
        catch (IllegalArgumentException exception) {
            long l = -1L;
            return l;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return sourceId;
    }

    public static int deleteAllEvents(Context context) {
        int result = 0;
        try {
            result = NotificationUtil.deleteEvents(context, null, null);
        }
        catch (SQLException exception) {
            result = -1;
        }
        catch (SecurityException exception) {
            result = -1;
        }
        catch (IllegalArgumentException exception) {
            result = -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getExtensionSpecificIds(Context context) {
        ArrayList<String> extensionSpecificIds = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = NotificationUtil.querySources(context, new String[]{"extension_specific_id"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    extensionSpecificIds.add(cursor.getString(cursor.getColumnIndex("extension_specific_id")));
                } while (cursor.moveToNext());
            }
        }
        return extensionSpecificIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Long> getSourceIds(Context context) {
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = NotificationUtil.querySources(context, new String[]{"_id"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    sourceIds.add(cursor.getLong(cursor.getColumnIndex("_id")));
                } while (cursor.moveToNext());
            }
        }
        return sourceIds;
    }

    public static int deleteEvents(Context context, String where, String[] selectionArgs) {
        String extensionWhere = NotificationUtil.getEventsWhere(context);
        if (!TextUtils.isEmpty((CharSequence)where)) {
            extensionWhere = extensionWhere + " AND (" + where + ")";
        }
        return context.getContentResolver().delete(Notification.Event.URI, extensionWhere, selectionArgs);
    }

    public static String getEventsWhere(Context context) {
        ArrayList<Long> sourceIds = NotificationUtil.getSourceIds(context);
        if (sourceIds.size() == 0) {
            return "0";
        }
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append("sourceId IN ( ");
        for (int i = 0; i < sourceIds.size() - 1; ++i) {
            whereBuilder.append(sourceIds.get(i) + ", ");
        }
        whereBuilder.append(sourceIds.get(sourceIds.size() - 1));
        whereBuilder.append(" )");
        return whereBuilder.toString();
    }

    public static Cursor querySources(Context context, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String extensionWhere = NotificationUtil.getSourcesWhere(context);
        if (!TextUtils.isEmpty((CharSequence)selection)) {
            extensionWhere = extensionWhere + " AND (" + selection + ")";
        }
        return context.getContentResolver().query(Notification.Source.URI, projection, extensionWhere, selectionArgs, sortOrder);
    }

    public static int updateSources(Context context, ContentValues values, String where, String[] selectionArgs) {
        String extensionWhere = NotificationUtil.getSourcesWhere(context);
        if (!TextUtils.isEmpty((CharSequence)where)) {
            extensionWhere = extensionWhere + " AND (" + where + ")";
        }
        return context.getContentResolver().update(Notification.Source.URI, values, extensionWhere, selectionArgs);
    }

    public static int deleteSources(Context context, String where, String[] selectionArgs) {
        String extensionWhere = NotificationUtil.getSourcesWhere(context);
        if (!TextUtils.isEmpty((CharSequence)where)) {
            extensionWhere = extensionWhere + " AND (" + where + ")";
        }
        return context.getContentResolver().delete(Notification.Source.URI, extensionWhere, selectionArgs);
    }

    public static String getSourcesWhere(Context context) {
        return "packageName = '" + context.getPackageName() + "'";
    }
}

