/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.registration;

import android.content.Context;
import android.database.Cursor;
import com.sonyericsson.extras.liveware.aef.registration.Registration;
import com.sonyericsson.extras.liveware.extension.util.registration.DisplayInfo;
import com.sonyericsson.extras.liveware.extension.util.sensor.AccessorySensor;
import com.sonyericsson.extras.liveware.extension.util.sensor.AccessorySensorType;
import java.util.ArrayList;
import java.util.List;

public class DeviceInfo {
    private final Context mContext;
    private final String mHostAppPackageName;
    private final long mId;
    private final int mWidgetWidth;
    private final int mWidgetHeight;
    private final boolean mVibrator;
    private List<DisplayInfo> mDisplays = null;
    private List<AccessorySensor> mSensors = null;
    private List<Object> mInputs = null;

    public DeviceInfo(Context context, String hostAppPackageName, long id2, int widgetWidth, int widgetHeight, boolean vibrator) {
        this.mContext = context;
        this.mHostAppPackageName = hostAppPackageName;
        this.mId = id2;
        this.mWidgetWidth = widgetWidth;
        this.mWidgetHeight = widgetHeight;
        this.mVibrator = vibrator;
    }

    public int getWidgetWidth() {
        return this.mWidgetWidth;
    }

    public int getWidgetHeight() {
        return this.mWidgetHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DisplayInfo> getDisplays() {
        if (this.mDisplays != null) {
            return this.mDisplays;
        }
        this.mDisplays = new ArrayList<DisplayInfo>();
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Registration.Display.URI, null, "deviceId = " + this.mId, null, null);
            while (cursor != null && cursor.moveToNext()) {
                long displayId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                int height = cursor.getInt(cursor.getColumnIndexOrThrow("height"));
                int width = cursor.getInt(cursor.getColumnIndexOrThrow("width"));
                int colors = cursor.getInt(cursor.getColumnIndexOrThrow("colors"));
                int refreshRate = cursor.getInt(cursor.getColumnIndexOrThrow("refreshRate"));
                int latency = cursor.getInt(cursor.getColumnIndexOrThrow("latency"));
                boolean tapTouch = cursor.getInt(cursor.getColumnIndexOrThrow("tapTouch")) == 1;
                boolean motionTouch = cursor.getInt(cursor.getColumnIndexOrThrow("motionTouch")) == 1;
                DisplayInfo display = new DisplayInfo(displayId, width, height, colors, refreshRate, latency, tapTouch, motionTouch);
                this.mDisplays.add(display);
            }
        }
        return this.mDisplays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessorySensor> getSensors() {
        if (this.mSensors != null) {
            return this.mSensors;
        }
        this.mSensors = new ArrayList<AccessorySensor>();
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Registration.Sensor.URI, null, "deviceId = ?", new String[]{Long.toString(this.mId)}, null);
            while (cursor != null && cursor.moveToNext()) {
                int sensorId = cursor.getInt(cursor.getColumnIndexOrThrow("sensorId"));
                boolean isInterruptSupported = cursor.getInt(cursor.getColumnIndexOrThrow("sensorInterrupt")) == 1;
                String name = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                int resolution = cursor.getInt(cursor.getColumnIndexOrThrow("resolution"));
                int minimumDelay = cursor.getInt(cursor.getColumnIndexOrThrow("minimumDelay"));
                int maximumRange = cursor.getInt(cursor.getColumnIndexOrThrow("maximumRange"));
                int typeId = cursor.getInt(cursor.getColumnIndexOrThrow("sensorTypeId"));
                AccessorySensorType type = this.getSensorType(typeId);
                AccessorySensor sensor = new AccessorySensor(this.mContext, this.mHostAppPackageName, sensorId, type, isInterruptSupported, name, resolution, minimumDelay, maximumRange);
                this.mSensors.add(sensor);
            }
        }
        return this.mSensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessorySensorType getSensorType(int typeId) {
        AccessorySensorType type = null;
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Registration.SensorType.URI, null, "_id = ?", new String[]{Integer.toString(typeId)}, null);
            if (cursor != null && cursor.moveToFirst()) {
                boolean isDelicate = cursor.getInt(cursor.getColumnIndexOrThrow("delicate_data")) == 1;
                String name = cursor.getString(cursor.getColumnIndexOrThrow("type"));
                type = new AccessorySensorType(name, isDelicate, typeId);
            }
        }
        return type;
    }
}

