/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.registration;

import android.content.Context;
import android.database.Cursor;
import com.sonyericsson.extras.liveware.aef.registration.Registration;
import com.sonyericsson.extras.liveware.extension.util.registration.DeviceInfo;
import java.util.ArrayList;
import java.util.List;

public class HostApplicationInfo {
    private final long mId;
    private final String mPackageName;
    private final int mWidgetApiVersion;
    private final int mControlApiVersion;
    private final int mSensorApiVersion;
    private final int mNotificationApiVersion;
    private final int mWidgetRefreshRate;
    private final Context mContext;
    private List<DeviceInfo> mDevices = null;

    public HostApplicationInfo(Context context, String packageName, long id2, int widgetApiVersion, int controlApiVersion, int sensorApiVersion, int notificationApiVersion, int widgetRefreshRate) {
        this.mContext = context;
        this.mPackageName = packageName;
        this.mId = id2;
        this.mWidgetApiVersion = widgetApiVersion;
        this.mControlApiVersion = controlApiVersion;
        this.mSensorApiVersion = sensorApiVersion;
        this.mNotificationApiVersion = notificationApiVersion;
        this.mWidgetRefreshRate = widgetRefreshRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceInfo> getDevices() {
        if (this.mDevices != null) {
            return this.mDevices;
        }
        this.mDevices = new ArrayList<DeviceInfo>();
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Registration.Device.URI, null, "hostAppId = " + this.mId, null, null);
            while (cursor != null && cursor.moveToNext()) {
                long deviceId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                int widgetWidth = cursor.getInt(cursor.getColumnIndexOrThrow("widgetImageWidtht"));
                int widgetHeight = cursor.getInt(cursor.getColumnIndexOrThrow("widgetImageHeight"));
                boolean vibrator = cursor.getInt(cursor.getColumnIndexOrThrow("vibrator")) == 1;
                DeviceInfo device = new DeviceInfo(this.mContext, this.mPackageName, deviceId, widgetWidth, widgetHeight, vibrator);
                this.mDevices.add(device);
            }
        }
        return this.mDevices;
    }

    public int getWidgetApiVersion() {
        return this.mWidgetApiVersion;
    }

    public int getControlApiVersion() {
        return this.mControlApiVersion;
    }

    public int getSensorApiVersion() {
        return this.mSensorApiVersion;
    }
}

