/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.registration;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncTask;
import com.sonyericsson.extras.liveware.aef.notification.Notification;
import com.sonyericsson.extras.liveware.aef.registration.Registration;
import com.sonyericsson.extras.liveware.extension.util.Dbg;
import com.sonyericsson.extras.liveware.extension.util.ExtensionUtils;
import com.sonyericsson.extras.liveware.extension.util.notification.NotificationUtil;
import com.sonyericsson.extras.liveware.extension.util.registration.HostApplicationInfo;
import com.sonyericsson.extras.liveware.extension.util.registration.IRegisterCallback;
import com.sonyericsson.extras.liveware.extension.util.registration.RegistrationInformation;
import java.util.ArrayList;

public class RegisterExtensionTask
extends AsyncTask<Void, Void, Boolean> {
    private final Context mContext;
    private final RegistrationInformation mRegistrationInformation;
    private IRegisterCallback mRegisterInterface;
    private final boolean mOnlySources;

    public RegisterExtensionTask(Context context, RegistrationInformation registrationInformation, IRegisterCallback registerInterface, boolean onlySources) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        this.mContext = context;
        if (registrationInformation == null) {
            throw new IllegalArgumentException("registrationInformation == null");
        }
        this.mRegistrationInformation = registrationInformation;
        if (registerInterface == null) {
            throw new IllegalArgumentException("registerInterface == null");
        }
        this.mRegisterInterface = registerInterface;
        this.mOnlySources = onlySources;
    }

    public void setRegisterInterface(IRegisterCallback registerInterface) {
        this.mRegisterInterface = registerInterface;
    }

    protected Boolean doInBackground(Void ... params) {
        if (this.mOnlySources) {
            try {
                this.registerOrUpdateSources();
                return true;
            }
            catch (RegisterExtensionException e) {
                Dbg.e("Source refresh failed", e);
                return false;
            }
        }
        boolean registrationSuccess = this.registerOrUpdateExtension();
        if (registrationSuccess && (this.mRegistrationInformation.getRequiredWidgetApiVersion() > 0 || this.mRegistrationInformation.getRequiredControlApiVersion() > 0)) {
            this.registerWithAllHostApps();
        }
        return registrationSuccess;
    }

    protected void onPostExecute(Boolean registrationSuccess) {
        if (this.mRegisterInterface != null) {
            this.mRegisterInterface.onExtensionRegisterResult(this.mOnlySources, registrationSuccess);
        }
    }

    protected void onCancelled() {
        Dbg.d("Registration task cancelled");
    }

    private boolean registerOrUpdateExtension() {
        Dbg.d("Start registration of extension.");
        try {
            if (!this.isRegistered()) {
                this.register();
                Dbg.d("Registered extension.");
            } else {
                this.updateRegistration();
                Dbg.d("Updated extension.");
            }
            if (this.mRegistrationInformation.getRequiredNotificationApiVersion() > 0) {
                this.registerOrUpdateSources();
            }
        }
        catch (RegisterExtensionException exception) {
            Dbg.e("Failed to register extension", exception);
            return false;
        }
        return true;
    }

    private boolean isRegistered() {
        return ExtensionUtils.getExtensionId(this.mContext) != -1L;
    }

    private void register() throws RegisterExtensionException {
        try {
            ContentValues configurationValues = this.mRegistrationInformation.getExtensionRegistrationConfiguration();
            if (!configurationValues.containsKey("notificationApiVersion")) {
                configurationValues.put("notificationApiVersion", Integer.valueOf(this.mRegistrationInformation.getRequiredNotificationApiVersion()));
            } else if (configurationValues.getAsInteger("notificationApiVersion").intValue() != this.mRegistrationInformation.getRequiredNotificationApiVersion()) {
                throw new RegisterExtensionException("NOTIFICATION_API_VERSION did not match getRequiredNotificationApiVersion");
            }
            configurationValues.put("packageName", this.mContext.getPackageName());
            Uri uri = this.mContext.getContentResolver().insert(Registration.Extension.URI, configurationValues);
            if (uri == null) {
                throw new RegisterExtensionException("failed to insert extension");
            }
        }
        catch (SQLException exception) {
            this.logAndThrow("Failed to register", (Exception)((Object)exception));
        }
        catch (SecurityException exception) {
            this.logAndThrow("Failed to register", exception);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrow("Failed to register. Is Liveware Manager installed?", exception);
        }
    }

    private void updateRegistration() throws RegisterExtensionException {
        Dbg.d("Updating existing registration.");
        String where = "packageName = ?";
        String[] selectionArgs = new String[]{this.mContext.getPackageName()};
        try {
            this.mContext.getContentResolver().update(Registration.Extension.URI, this.mRegistrationInformation.getExtensionRegistrationConfiguration(), where, selectionArgs);
        }
        catch (SQLException exception) {
            this.logAndThrow("Failed to update registration", (Exception)((Object)exception));
        }
        catch (SecurityException exception) {
            this.logAndThrow("Failed to update registration", exception);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrow("Failed to update registration", exception);
        }
    }

    private void registerOrUpdateSources() throws RegisterExtensionException {
        ArrayList<String> oldExtensionSpecificIds = NotificationUtil.getExtensionSpecificIds(this.mContext);
        for (ContentValues sourceConfiguration : this.mRegistrationInformation.getSourceRegistrationConfigurations()) {
            String extensionSpecificId = (String)sourceConfiguration.get("extension_specific_id");
            long sourceId = NotificationUtil.getSourceId(this.mContext, extensionSpecificId);
            sourceConfiguration.put("packageName", this.mContext.getPackageName());
            if (sourceId == -1L) {
                sourceId = this.registerSource(sourceConfiguration);
            } else {
                this.updateSource(sourceConfiguration, sourceId);
            }
            Dbg.d("SourceType:" + extensionSpecificId + " SourceId:" + sourceId);
            oldExtensionSpecificIds.remove(extensionSpecificId);
        }
        for (String deletedExtensionSpecificId : oldExtensionSpecificIds) {
            this.unregisterSource(deletedExtensionSpecificId);
        }
    }

    private long registerSource(ContentValues sourceValues) throws RegisterExtensionException {
        long sourceId = -1L;
        try {
            Uri uri = this.mContext.getContentResolver().insert(Notification.Source.URI, sourceValues);
            if (uri == null) {
                throw new RegisterExtensionException("failed to insert source");
            }
            sourceId = (int)ContentUris.parseId((Uri)uri);
        }
        catch (SQLException exception) {
            this.logAndThrow("Register source failed", (Exception)((Object)exception));
        }
        catch (SecurityException exception) {
            this.logAndThrow("Register source failed", exception);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrow("Register source failed", exception);
        }
        return sourceId;
    }

    private void updateSource(ContentValues sourceValues, long sourceId) throws RegisterExtensionException {
        try {
            int result = NotificationUtil.updateSources(this.mContext, sourceValues, "_id = " + sourceId, null);
            if (result != 1) {
                Dbg.e("Failed to update source");
            }
        }
        catch (SQLException exception) {
            this.logAndThrow("Update source failed", (Exception)((Object)exception));
        }
        catch (SecurityException exception) {
            this.logAndThrow("Update source failed", exception);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrow("Update source failed", exception);
        }
    }

    private void unregisterSource(String extensionSpecificId) throws RegisterExtensionException {
        try {
            int noOfDeletedRows = NotificationUtil.deleteSources(this.mContext, "extension_specific_id='" + extensionSpecificId + "'", null);
            if (noOfDeletedRows == 0) {
                Dbg.d("Source was already unregistered: " + extensionSpecificId);
            } else {
                Dbg.d("Unregistered source: " + extensionSpecificId);
            }
        }
        catch (SQLException exception) {
            this.logAndThrow("Unregister source failed", (Exception)((Object)exception));
        }
        catch (SecurityException exception) {
            this.logAndThrow("Unregister source failed", exception);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrow("Update source failed", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithAllHostApps() {
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(Registration.HostApp.URI, new String[]{"_id", "packageName", "widgetApiVersion", "controlApiVersion", "sensorApiVersion", "notificationApiVersion", "widgetRefreshrate"}, null, null, null);
            if (cursor == null) {
                Dbg.e("checkHostAppRegistration: cursor==null");
                return;
            }
            if (cursor.getCount() == 0) {
                return;
            }
            cursor.moveToFirst();
            int packageColumnIndex = cursor.getColumnIndex("packageName");
            int hostAppIdColumnIndex = cursor.getColumnIndex("_id");
            int widgetApiColumnIndex = cursor.getColumnIndex("widgetApiVersion");
            int controlApiColumnIndex = cursor.getColumnIndex("controlApiVersion");
            int sensorApiColumnIndex = cursor.getColumnIndex("sensorApiVersion");
            int notificationApiColumnIndex = cursor.getColumnIndexOrThrow("notificationApiVersion");
            int widgetRefreshRateColumnIndex = cursor.getColumnIndexOrThrow("widgetRefreshrate");
            while (!cursor.isAfterLast()) {
                String packageName = cursor.getString(packageColumnIndex);
                long hostAppId = cursor.getLong(hostAppIdColumnIndex);
                int widgetApiVersion = cursor.getInt(widgetApiColumnIndex);
                int controlApiVersion = cursor.getInt(controlApiColumnIndex);
                int sensorApiVersion = cursor.getInt(sensorApiColumnIndex);
                int notificationApiVersion = cursor.getInt(notificationApiColumnIndex);
                int widgetRefreshRate = cursor.getInt(widgetRefreshRateColumnIndex);
                HostApplicationInfo hostApplication = new HostApplicationInfo(this.mContext, packageName, hostAppId, widgetApiVersion, controlApiVersion, sensorApiVersion, notificationApiVersion, widgetRefreshRate);
                boolean widgetSupported = this.mRegistrationInformation.isSupportedWidgetAvailable(this.mContext, hostApplication);
                boolean controlSupported = this.mRegistrationInformation.isSupportedControlAvailable(this.mContext, hostApplication);
                boolean sensorSupported = this.mRegistrationInformation.isSupportedSensorAvailable(this.mContext, hostApplication);
                if (widgetSupported || controlSupported || sensorSupported) {
                    this.registerApiRegistration(packageName, this.isHostAppRegistered(packageName), widgetSupported, controlSupported, sensorSupported);
                }
                cursor.moveToNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHostAppRegistered(String packageName) {
        Cursor cursor = null;
        boolean isRegistered = false;
        long extensionId = ExtensionUtils.getExtensionId(this.mContext);
        String selection = "extensionId = " + extensionId + " AND " + "hostAppPackageName" + " = ?";
        String[] selectionArgs = new String[]{packageName};
        try {
            cursor = this.mContext.getContentResolver().query(Registration.ApiRegistration.URI, new String[]{"hostAppPackageName"}, selection, selectionArgs, null);
            if (cursor != null) {
                isRegistered = cursor.getCount() > 0;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return isRegistered;
    }

    private boolean registerApiRegistration(String packageName, boolean isRegistered, boolean widgetApiVersionSupported, boolean controlApiVersionSupported, boolean sensorApiVersionSupported) {
        Dbg.d("Register API registration: " + packageName);
        ContentValues values = new ContentValues();
        values.put("hostAppPackageName", packageName);
        if (widgetApiVersionSupported) {
            values.put("widgetApiVersion", Integer.valueOf(this.mRegistrationInformation.getRequiredWidgetApiVersion()));
        } else {
            values.put("widgetApiVersion", Integer.valueOf(0));
        }
        if (controlApiVersionSupported) {
            values.put("controlApiVersion", Integer.valueOf(this.mRegistrationInformation.getRequiredControlApiVersion()));
        } else {
            values.put("controlApiVersion", Integer.valueOf(0));
        }
        if (sensorApiVersionSupported) {
            values.put("sensorApiVersion", Integer.valueOf(this.mRegistrationInformation.getRequiredSensorApiVersion()));
        } else {
            values.put("sensorApiVersion", Integer.valueOf(0));
        }
        boolean res = false;
        long extensionId = ExtensionUtils.getExtensionId(this.mContext);
        if (!isRegistered) {
            values.put("extensionId", Long.valueOf(extensionId));
            Uri uri = this.mContext.getContentResolver().insert(Registration.ApiRegistration.URI, values);
            res = uri != null;
        } else {
            long _id = ExtensionUtils.getRegistrationId(this.mContext, packageName, extensionId);
            int rows = this.mContext.getContentResolver().update(ContentUris.withAppendedId((Uri)Registration.ApiRegistration.URI, (long)_id), values, null, null);
            res = rows > 0;
        }
        return res;
    }

    private void logAndThrow(String text, Exception exception) throws RegisterExtensionException {
        Dbg.e(text, exception);
        throw new RegisterExtensionException(text);
    }

    private static class RegisterExtensionException
    extends Exception {
        public RegisterExtensionException(String string2) {
            super(string2);
        }
    }
}

