/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.extras.liveware.extension.util.registration;

import android.content.ContentValues;
import android.content.Context;
import com.sonyericsson.extras.liveware.extension.util.Dbg;
import com.sonyericsson.extras.liveware.extension.util.registration.DeviceInfo;
import com.sonyericsson.extras.liveware.extension.util.registration.DisplayInfo;
import com.sonyericsson.extras.liveware.extension.util.registration.HostApplicationInfo;
import com.sonyericsson.extras.liveware.extension.util.sensor.AccessorySensor;

public abstract class RegistrationInformation {
    public static int API_NOT_REQUIRED = 0;

    public abstract int getRequiredNotificationApiVersion();

    public abstract ContentValues getExtensionRegistrationConfiguration();

    public ContentValues[] getSourceRegistrationConfigurations() {
        throw new IllegalArgumentException("getSourceRegistrationConfiguration() not implemented. Notification extensions must override this method");
    }

    public boolean isWidgetSizeSupported(int width, int height) {
        throw new IllegalArgumentException("isWidgetSizeSupported() not implemented. Widget extensions must override this method");
    }

    public abstract int getRequiredWidgetApiVersion();

    public boolean isDisplaySizeSupported(int width, int height) {
        throw new IllegalArgumentException("isDisplaySizeSupported() not implemented. Control extensions must override this method");
    }

    public abstract int getRequiredControlApiVersion();

    public boolean isSensorSupported(AccessorySensor sensor) {
        throw new IllegalArgumentException("isSensorSupported() not implemented. Sensor extensions must override this method");
    }

    public abstract int getRequiredSensorApiVersion();

    public boolean isSourcesToBeUpdatedAtServiceCreation() {
        return false;
    }

    public boolean isSupportedWidgetAvailable(Context context, HostApplicationInfo hostApplication) {
        if (this.getRequiredWidgetApiVersion() == API_NOT_REQUIRED) {
            return false;
        }
        if (hostApplication.getWidgetApiVersion() == 0) {
            return false;
        }
        if (this.getRequiredWidgetApiVersion() > hostApplication.getWidgetApiVersion()) {
            Dbg.w("isSupportedWidgetAvailable: required widget API version not supported");
            return false;
        }
        for (DeviceInfo device : hostApplication.getDevices()) {
            if (!this.isWidgetSizeSupported(device.getWidgetWidth(), device.getWidgetHeight())) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedSensorAvailable(Context context, HostApplicationInfo hostApplication) {
        if (this.getRequiredSensorApiVersion() == API_NOT_REQUIRED) {
            return false;
        }
        if (hostApplication.getSensorApiVersion() == 0) {
            return false;
        }
        if (this.getRequiredSensorApiVersion() > hostApplication.getSensorApiVersion()) {
            Dbg.w("isSupportedSensorAvailable: required sensor API version not supported");
            return false;
        }
        for (DeviceInfo device : hostApplication.getDevices()) {
            for (AccessorySensor sensor : device.getSensors()) {
                if (!this.isSensorSupported(sensor)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSupportedControlAvailable(Context context, HostApplicationInfo hostApplication) {
        if (this.getRequiredControlApiVersion() == API_NOT_REQUIRED) {
            return false;
        }
        if (hostApplication.getControlApiVersion() == 0) {
            return false;
        }
        if (this.getRequiredControlApiVersion() > hostApplication.getControlApiVersion()) {
            Dbg.w("isSupportedControlAvailable: required control API version not supported");
            return false;
        }
        for (DeviceInfo device : hostApplication.getDevices()) {
            for (DisplayInfo display : device.getDisplays()) {
                if (!this.isDisplaySizeSupported(display.getWidth(), display.getHeight())) continue;
                return true;
            }
        }
        return false;
    }
}

