/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import java.util.concurrent.Executor;

public final class AndroidWatchExecutor
implements Executor {
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final Handler backgroundHandler;

    public AndroidWatchExecutor() {
        HandlerThread handlerThread = new HandlerThread("LeakCanary-Heap-Dump");
        handlerThread.start();
        this.backgroundHandler = new Handler(handlerThread.getLooper());
    }

    @Override
    public void execute(final Runnable command) {
        if (this.isOnMainThread()) {
            this.executeDelayedAfterIdleUnsafe(command);
        } else {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidWatchExecutor.this.executeDelayedAfterIdleUnsafe(command);
                }
            });
        }
    }

    private boolean isOnMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void executeDelayedAfterIdleUnsafe(final Runnable runnable) {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                AndroidWatchExecutor.this.backgroundHandler.postDelayed(runnable, 5000L);
                return false;
            }
        });
    }
}

