/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class DisplayLeakService
extends AbstractAnalysisResultService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=11)
    protected final void onHeapAnalyzed(HeapDump heapDump, AnalysisResult result) {
        Notification notification;
        String leakInfo = LeakCanary.leakInfo((Context)this, heapDump, result, true);
        if (leakInfo.length() < 4000) {
            Log.d((String)"LeakCanary", (String)leakInfo);
        } else {
            String[] lines;
            for (String line : lines = leakInfo.split("\n")) {
                Log.d((String)"LeakCanary", (String)line);
            }
        }
        if (result.failure == null && (!result.leakFound || result.excludedLeak)) {
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        int maxStoredLeaks = this.getResources().getInteger(R.integer.__leak_canary_max_stored_leaks);
        File renamedFile = LeakCanaryInternals.findNextAvailableHprofFile(maxStoredLeaks);
        if (renamedFile == null) {
            Log.e((String)"LeakCanary", (String)("Leak result dropped because we already store " + maxStoredLeaks + " leak traces."));
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        heapDump = heapDump.renameFile(renamedFile);
        File resultFile = LeakCanaryInternals.leakResultFile(renamedFile);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resultFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(heapDump);
            oos.writeObject(result);
        }
        catch (IOException e) {
            Log.e((String)"LeakCanary", (String)"Could not save leak analysis result to disk", (Throwable)e);
            this.afterDefaultHandling(heapDump, result, leakInfo);
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
        }
        PendingIntent pendingIntent = DisplayLeakActivity.createPendingIntent((Context)this, heapDump.referenceKey);
        String contentTitle = result.failure == null ? this.getString(R.string.__leak_canary_class_has_leaked, new Object[]{LeakCanaryInternals.classSimpleName(result.className)}) : this.getString(R.string.__leak_canary_analysis_failed);
        String contentText = this.getString(R.string.__leak_canary_notification_message);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT < 11) {
            notification = new Notification();
            notification.icon = R.drawable.__leak_canary_notification;
            notification.when = System.currentTimeMillis();
            notification.flags |= 0x10;
            notification.setLatestEventInfo((Context)this, (CharSequence)contentTitle, (CharSequence)contentText, pendingIntent);
        } else {
            Notification.Builder builder = new Notification.Builder((Context)this).setSmallIcon(R.drawable.__leak_canary_notification).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setAutoCancel(true).setContentIntent(pendingIntent);
            notification = Build.VERSION.SDK_INT < 16 ? builder.getNotification() : builder.build();
        }
        notificationManager.notify(-558907665, notification);
        this.afterDefaultHandling(heapDump, result, leakInfo);
    }

    protected void afterDefaultHandling(HeapDump heapDump, AnalysisResult result, String leakInfo) {
    }
}

