/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.util.Log;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.SnapshotFactory;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.PathsFromGCRootsTree;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PrettyPrinter;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.util.VoidProgressListener;

public final class HeapAnalyzer {
    private final ExcludedRefs baseExcludedRefs;
    private final ExcludedRefs excludedRefs;

    public HeapAnalyzer(ExcludedRefs baseExcludedRefs, ExcludedRefs excludedRefs) {
        this.baseExcludedRefs = baseExcludedRefs;
        this.excludedRefs = excludedRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult checkForLeak(File heapDumpFile, String referenceKey) {
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return AnalysisResult.failure(exception, this.since(analysisStartNanoTime));
        }
        ISnapshot snapshot = null;
        try {
            snapshot = this.openSnapshot(heapDumpFile);
            IObject leakingRef = this.findLeakingReference(referenceKey, snapshot);
            if (leakingRef == null) {
                AnalysisResult analysisResult = AnalysisResult.noLeak(this.since(analysisStartNanoTime));
                return analysisResult;
            }
            String className = leakingRef.getClazz().getName();
            AnalysisResult result = this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef, className, true);
            if (!result.leakFound) {
                result = this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef, className, false);
            }
            AnalysisResult analysisResult = result;
            return analysisResult;
        }
        catch (Exception e) {
            AnalysisResult analysisResult = AnalysisResult.failure(e, this.since(analysisStartNanoTime));
            return analysisResult;
        }
        finally {
            this.cleanup(heapDumpFile, snapshot);
        }
    }

    private AnalysisResult findLeakTrace(long analysisStartNanoTime, ISnapshot snapshot, IObject leakingRef, String className, boolean excludingKnownLeaks) throws SnapshotException {
        ExcludedRefs excludedRefs = excludingKnownLeaks ? this.excludedRefs : this.baseExcludedRefs;
        PathsFromGCRootsTree gcRootsTree = this.shortestPathToGcRoots(snapshot, leakingRef, excludedRefs);
        if (gcRootsTree == null) {
            return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
        }
        LeakTrace leakTrace = this.buildLeakTrace(snapshot, gcRootsTree, excludedRefs);
        return AnalysisResult.leakDetected(!excludingKnownLeaks, className, leakTrace, this.since(analysisStartNanoTime));
    }

    private ISnapshot openSnapshot(File heapDumpFile) throws SnapshotException {
        SnapshotFactory factory = new SnapshotFactory();
        Map<String, String> args = Collections.emptyMap();
        VoidProgressListener listener = new VoidProgressListener();
        return factory.openSnapshot(heapDumpFile, args, listener);
    }

    private IObject findLeakingReference(String key, ISnapshot snapshot) throws SnapshotException {
        int[] weakRefInstanceIds;
        Collection<IClass> refClasses = snapshot.getClassesByName(KeyedWeakReference.class.getName(), false);
        if (refClasses.size() != 1) {
            throw new IllegalStateException("Expecting one class for " + KeyedWeakReference.class.getName() + " in " + refClasses);
        }
        IClass refClass = refClasses.iterator().next();
        for (int weakRefInstanceId : weakRefInstanceIds = refClass.getObjectIds()) {
            IObject weakRef = snapshot.getObject(weakRefInstanceId);
            String keyCandidate = PrettyPrinter.objectAsString((IObject)weakRef.resolveValue("key"), 100);
            if (!keyCandidate.equals(key)) continue;
            return (IObject)weakRef.resolveValue("referent");
        }
        throw new IllegalStateException("Could not find weak reference with key " + key);
    }

    private PathsFromGCRootsTree shortestPathToGcRoots(ISnapshot snapshot, IObject leakingRef, ExcludedRefs excludedRefs) throws SnapshotException {
        Map<IClass, Set<String>> excludeMap = this.buildClassExcludeMap(snapshot, excludedRefs.excludeFieldMap);
        IPathsFromGCRootsComputer pathComputer = snapshot.getPathsFromGCRoots(leakingRef.getObjectId(), excludeMap);
        return this.shortestValidPath(snapshot, pathComputer, excludedRefs);
    }

    private Map<IClass, Set<String>> buildClassExcludeMap(ISnapshot snapshot, Map<String, Set<String>> excludeMap) throws SnapshotException {
        LinkedHashMap<IClass, Set<String>> classExcludeMap = new LinkedHashMap<IClass, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : excludeMap.entrySet()) {
            Collection<IClass> refClasses = snapshot.getClassesByName(entry.getKey(), false);
            if (refClasses == null || refClasses.size() != 1) continue;
            IClass refClass = refClasses.iterator().next();
            classExcludeMap.put(refClass, entry.getValue());
        }
        return classExcludeMap;
    }

    private PathsFromGCRootsTree shortestValidPath(ISnapshot snapshot, IPathsFromGCRootsComputer pathComputer, ExcludedRefs excludedRefs) throws SnapshotException {
        int[] shortestPath;
        Map<IClass, Set<String>> excludedStaticFields = this.buildClassExcludeMap(snapshot, excludedRefs.excludeStaticFieldMap);
        while ((shortestPath = pathComputer.getNextShortestPath()) != null) {
            PathsFromGCRootsTree tree = pathComputer.getTree(Collections.singletonList(shortestPath));
            if (!this.validPath(snapshot, tree, excludedStaticFields, excludedRefs)) continue;
            return tree;
        }
        return null;
    }

    private boolean validPath(ISnapshot snapshot, PathsFromGCRootsTree tree, Map<IClass, Set<String>> excludedStaticFields, ExcludedRefs excludedRefs) throws SnapshotException {
        if (excludedStaticFields.isEmpty() && excludedRefs.excludedThreads.isEmpty()) {
            return true;
        }
        IObject held = null;
        while (tree != null) {
            NamedReference ref;
            IClass childClass;
            Set<String> childClassExcludedFields;
            IObject holder = snapshot.getObject(tree.getOwnId());
            if (holder instanceof IClass ? (childClassExcludedFields = excludedStaticFields.get(childClass = (IClass)holder)) != null && (ref = this.findHeldInHolder(held, holder, excludedRefs)) != null && childClassExcludedFields.contains(ref.getName()) : holder.getClazz().doesExtend(Thread.class.getName()) && excludedRefs.excludedThreads.contains(this.getThreadName(holder))) {
                return false;
            }
            held = holder;
            int[] branchIds = tree.getObjectIds();
            tree = branchIds.length > 0 ? tree.getBranch(branchIds[0]) : null;
        }
        return true;
    }

    private String getThreadName(IObject thread) throws SnapshotException {
        return PrettyPrinter.objectAsString((IObject)thread.resolveValue("name"), Integer.MAX_VALUE);
    }

    private NamedReference findHeldInHolder(IObject held, IObject holder, ExcludedRefs excludedRefs) throws SnapshotException {
        if (held == null) {
            return null;
        }
        Set<String> excludedFields = excludedRefs.excludeFieldMap.get(holder.getClazz().getName());
        for (NamedReference holdingRef : holder.getOutboundReferences()) {
            if (holdingRef.getObjectId() != held.getObjectId() || excludedFields != null && excludedFields.contains(holdingRef.getName())) continue;
            return holdingRef;
        }
        return null;
    }

    private LeakTrace buildLeakTrace(ISnapshot snapshot, PathsFromGCRootsTree tree, ExcludedRefs excludedRefs) throws SnapshotException {
        ArrayList<LeakTraceElement> elements = new ArrayList<LeakTraceElement>();
        IObject held = null;
        while (tree != null) {
            IObject holder = snapshot.getObject(tree.getOwnId());
            elements.add(0, this.buildLeakElement(held, holder, excludedRefs));
            held = holder;
            int[] branchIds = tree.getObjectIds();
            tree = branchIds.length > 0 ? tree.getBranch(branchIds[0]) : null;
        }
        return new LeakTrace(elements);
    }

    private LeakTraceElement buildLeakElement(IObject held, IObject holder, ExcludedRefs excludedRefs) throws SnapshotException {
        String className;
        LeakTraceElement.Holder holderType;
        LeakTraceElement.Type type = null;
        String referenceName = null;
        NamedReference holdingRef = this.findHeldInHolder(held, holder, excludedRefs);
        if (holdingRef != null) {
            referenceName = holdingRef.getName();
            type = holder instanceof IClass ? LeakTraceElement.Type.STATIC_FIELD : (holdingRef instanceof ThreadToLocalReference ? LeakTraceElement.Type.LOCAL : LeakTraceElement.Type.INSTANCE_FIELD);
        }
        String extra = null;
        ArrayList<String> fields = new ArrayList<String>();
        if (holder instanceof IClass) {
            IClass clazz = (IClass)holder;
            holderType = LeakTraceElement.Holder.CLASS;
            className = clazz.getName();
            for (Field staticField : clazz.getStaticFields()) {
                fields.add("static " + this.fieldToString(staticField));
            }
        } else if (holder instanceof IArray) {
            holderType = LeakTraceElement.Holder.ARRAY;
            IClass clazz = holder.getClazz();
            className = clazz.getName();
            if (holder instanceof IObjectArray) {
                IObjectArray array2 = (IObjectArray)holder;
                int i = 0;
                ISnapshot snapshot = holder.getSnapshot();
                for (long address : array2.getReferenceArray()) {
                    if (address == 0L) {
                        fields.add("[" + i + "] = null");
                    } else {
                        int objectId = snapshot.mapAddressToId(address);
                        IObject object = snapshot.getObject(objectId);
                        fields.add("[" + i + "] = " + object);
                    }
                    ++i;
                }
            }
        } else {
            IInstance instance = (IInstance)holder;
            IClass clazz = holder.getClazz();
            for (Field staticField : clazz.getStaticFields()) {
                fields.add("static " + this.fieldToString(staticField));
            }
            for (Field field : instance.getFields()) {
                fields.add(this.fieldToString(field));
            }
            className = clazz.getName();
            if (clazz.doesExtend(Thread.class.getName())) {
                holderType = LeakTraceElement.Holder.THREAD;
                String threadName = this.getThreadName(holder);
                extra = "(named '" + threadName + "')";
            } else if (className.matches("^.+\\$\\d+$")) {
                String parentClassName = clazz.getSuperClass().getName();
                if (Object.class.getName().equals(parentClassName)) {
                    holderType = LeakTraceElement.Holder.OBJECT;
                    try {
                        Class<?> actualClass = Class.forName(clazz.getName());
                        Class<?> implementedInterface = actualClass.getInterfaces()[0];
                        extra = "(anonymous class implements " + implementedInterface.getName() + ")";
                    }
                    catch (ClassNotFoundException ignored) {}
                } else {
                    holderType = LeakTraceElement.Holder.OBJECT;
                    extra = "(anonymous class extends " + parentClassName + ")";
                }
            } else {
                holderType = LeakTraceElement.Holder.OBJECT;
            }
        }
        return new LeakTraceElement(referenceName, type, holderType, className, extra, fields);
    }

    private String fieldToString(Field field) throws SnapshotException {
        Object value = field.getValue();
        if (value instanceof ObjectReference) {
            value = ((ObjectReference)value).getObject();
        }
        return field.getName() + " = " + value;
    }

    private void cleanup(File heapDumpFile, ISnapshot snapshot) {
        if (snapshot != null) {
            snapshot.dispose();
        }
        final String heapDumpFileName = heapDumpFile.getName();
        final String prefix = heapDumpFileName.substring(0, heapDumpFile.getName().length() - ".hprof".length());
        File[] toRemove = heapDumpFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().startsWith(prefix) && !file.getName().equals(heapDumpFileName);
            }
        });
        if (toRemove != null) {
            for (File file : toRemove) {
                file.delete();
            }
        } else {
            Log.d((String)"HeapAnalyzer", (String)"Could not find HAHA files to cleanup.");
        }
    }

    private long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }
}

