/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.ActivityRefWatcher;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AndroidDebuggerControl;
import com.squareup.leakcanary.AndroidHeapDumper;
import com.squareup.leakcanary.AndroidWatchExecutor;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.ServiceHeapDumpListener;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.HeapAnalyzerService;
import com.squareup.leakcanary.internal.LeakCanaryInternals;

public final class LeakCanary {
    public static RefWatcher install(Application application, Class<? extends AbstractAnalysisResultService> listenerServiceClass, ExcludedRefs excludedRefs) {
        if (LeakCanary.isInAnalyzerProcess((Context)application)) {
            return RefWatcher.DISABLED;
        }
        LeakCanary.enableDisplayLeakActivity((Context)application);
        ServiceHeapDumpListener heapDumpListener = new ServiceHeapDumpListener((Context)application, listenerServiceClass);
        RefWatcher refWatcher = LeakCanary.androidWatcher((Context)application, heapDumpListener, excludedRefs);
        ActivityRefWatcher.installOnIcsPlus(application, refWatcher);
        return refWatcher;
    }

    public static RefWatcher androidWatcher(Context context, HeapDump.Listener heapDumpListener, ExcludedRefs excludedRefs) {
        AndroidDebuggerControl debuggerControl = new AndroidDebuggerControl();
        AndroidHeapDumper heapDumper = new AndroidHeapDumper(context);
        heapDumper.cleanup();
        return new RefWatcher(new AndroidWatchExecutor(), debuggerControl, GcTrigger.DEFAULT, heapDumper, heapDumpListener, excludedRefs);
    }

    public static void enableDisplayLeakActivity(Context context) {
        LeakCanaryInternals.setEnabled(context, DisplayLeakActivity.class, true);
    }

    public static String leakInfo(Context context, HeapDump heapDump, AnalysisResult result, boolean detailed) {
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        String versionName = packageInfo.versionName;
        int versionCode = packageInfo.versionCode;
        String info = "In " + packageName + ":" + versionName + ":" + versionCode + ".\n";
        String detailedString = "";
        if (result.leakFound) {
            if (result.excludedLeak) {
                info = info + "* LEAK CAN BE IGNORED.\n";
            }
            info = info + "* " + result.className;
            if (!heapDump.referenceName.equals("")) {
                info = info + " (" + heapDump.referenceName + ")";
            }
            info = info + " has leaked:\n" + result.leakTrace.toString() + "\n";
            if (detailed) {
                detailedString = "\n* Details:\n" + result.leakTrace.toDetailedString();
            }
        } else {
            info = result.failure != null ? info + "* FAILURE:\n" + Log.getStackTraceString((Throwable)result.failure) + "\n" : info + "* NO LEAK FOUND.\n\n";
        }
        info = info + "* Reference Key: " + heapDump.referenceKey + "\n" + "* Device: " + Build.MANUFACTURER + " " + Build.BRAND + " " + Build.MODEL + " " + Build.PRODUCT + "\n" + "* Android Version: " + Build.VERSION.RELEASE + " API: " + Build.VERSION.SDK_INT + " LeakCanary: " + "1.3.1" + "\n" + "* Durations: watch=" + heapDump.watchDurationMs + "ms, gc=" + heapDump.gcDurationMs + "ms, heap dump=" + heapDump.heapDumpDurationMs + "ms, analysis=" + result.analysisDurationMs + "ms" + "\n" + detailedString;
        return info;
    }

    public static boolean isInAnalyzerProcess(Context context) {
        return LeakCanaryInternals.isInServiceProcess(context, HeapAnalyzerService.class);
    }
}

