/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.cache;

import android.content.Context;
import io.fabric.sdk.android.services.cache.ValueCache;
import io.fabric.sdk.android.services.cache.ValueLoader;

public abstract class AbstractValueCache<T>
implements ValueCache<T> {
    private final ValueCache<T> childCache;

    public AbstractValueCache(ValueCache<T> childCache) {
        this.childCache = childCache;
    }

    @Override
    public final synchronized T get(Context context, ValueLoader<T> loader) throws Exception {
        T value = this.getCached(context);
        if (value == null) {
            value = this.childCache != null ? this.childCache.get(context, loader) : loader.load(context);
            this.cache(context, value);
        }
        return value;
    }

    protected abstract T getCached(Context var1);

    protected abstract void cacheValue(Context var1, T var2);

    private void cache(Context context, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.cacheValue(context, value);
    }
}

