/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.AdvertisingInfo;
import io.fabric.sdk.android.services.common.AdvertisingInfoStrategy;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class AdvertisingInfoServiceStrategy
implements AdvertisingInfoStrategy {
    private final Context context;

    public AdvertisingInfoServiceStrategy(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AdvertisingInfo getAdvertisingInfo() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Fabric.getLogger().d("Fabric", "AdvertisingInfoServiceStrategy cannot be called on the main thread");
            return null;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Unable to determine if Google Play Services is available", e);
            return null;
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (!this.context.bindService(intent, (ServiceConnection)connection, 1)) {
                Fabric.getLogger().d("Fabric", "Could not bind to Google Play Service to capture AdvertisingId");
                return null;
            }
            try {
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                AdvertisingInfo advertisingInfo = new AdvertisingInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled());
                return advertisingInfo;
            }
            catch (Exception e) {
                Fabric.getLogger().w("Fabric", "Exception in binding to Google Play Service to capture AdvertisingId", e);
                return null;
            }
            finally {
                this.context.unbindService((ServiceConnection)connection);
            }
        }
        catch (Throwable t) {
            Fabric.getLogger().d("Fabric", "Could not bind to Google Play Service to capture AdvertisingId", t);
        }
        return null;
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private final IBinder binder;

        public AdvertisingInterface(IBinder binder) {
            this.binder = binder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            String id2 = null;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id2 = reply.readString();
            }
            catch (Exception e) {
                Fabric.getLogger().d("Fabric", "Could not get parcel from Google Play Service to capture AdvertisingId");
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled() throws RemoteException {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            boolean limitAdTracking = false;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(1);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            catch (Exception e) {
                Fabric.getLogger().d("Fabric", "Could not get parcel from Google Play Service to capture Advertising limitAdTracking");
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        private boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            this.queue.clear();
        }

        public IBinder getBinder() {
            if (this.retrieved) {
                Fabric.getLogger().e("Fabric", "getBinder already called");
            }
            this.retrieved = true;
            try {
                return this.queue.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }
}

