/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;

public class ApiKey {
    public String getValue(Context context) {
        String apiKey = this.getApiKeyFromManifest(context);
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = this.getApiKeyFromStrings(context);
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            this.logErrorOrThrowException(context);
        }
        return apiKey;
    }

    protected String getApiKeyFromManifest(Context context) {
        String apiKey = null;
        try {
            String packageName = context.getPackageName();
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle bundle = ai.metaData;
            if (bundle != null && (apiKey = bundle.getString("io.fabric.ApiKey")) == null) {
                Fabric.getLogger().d("Fabric", "Falling back to Crashlytics key lookup from Manifest");
                apiKey = bundle.getString("com.crashlytics.ApiKey");
            }
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Caught non-fatal exception while retrieving apiKey: " + e);
        }
        return apiKey;
    }

    protected String getApiKeyFromStrings(Context context) {
        String apiKey = null;
        int id2 = CommonUtils.getResourcesIdentifier(context, "io.fabric.ApiKey", "string");
        if (id2 == 0) {
            Fabric.getLogger().d("Fabric", "Falling back to Crashlytics key lookup from Strings");
            id2 = CommonUtils.getResourcesIdentifier(context, "com.crashlytics.ApiKey", "string");
        }
        if (id2 != 0) {
            apiKey = context.getResources().getString(id2);
        }
        return apiKey;
    }

    protected void logErrorOrThrowException(Context context) {
        if (Fabric.isDebuggable() || CommonUtils.isAppDebuggable(context)) {
            throw new IllegalArgumentException(this.buildApiKeyInstructions());
        }
        Fabric.getLogger().e("Fabric", this.buildApiKeyInstructions());
    }

    protected String buildApiKeyInstructions() {
        return "Fabric could not be initialized, API key missing from AndroidManifest.xml. Add the following tag to your Application element \n\t<meta-data android:name=\"io.fabric.ApiKey\" android:value=\"YOUR_API_KEY\"/>";
    }
}

