/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Debug;
import android.os.StatFs;
import android.provider.Settings;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CommonUtils {
    private static Boolean clsTrace = null;
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static long totalRamInBytes = -1L;
    private static Boolean loggingEnabled = null;
    public static final Comparator<File> FILE_MODIFIED_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file0, File file1) {
            return (int)(file0.lastModified() - file1.lastModified());
        }
    };

    public static SharedPreferences getSharedPrefs(Context context) {
        return context.getSharedPreferences("com.crashlytics.prefs", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractFieldFromSystemFile(File file, String fieldname) {
        String toReturn = null;
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(file), 1024);
                while ((line = br.readLine()) != null) {
                    Pattern pattern = Pattern.compile("\\s*:\\s*");
                    String[] pieces = pattern.split(line, 2);
                    if (pieces.length <= 1 || !pieces[0].equals(fieldname)) continue;
                    toReturn = pieces[1];
                    break;
                }
            }
            catch (Exception e) {
                try {
                    Fabric.getLogger().e("Fabric", "Error parsing " + file, e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(br, "Failed to close system file reader.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(br, "Failed to close system file reader.");
            }
            CommonUtils.closeOrLog(br, "Failed to close system file reader.");
        }
        return toReturn;
    }

    public static int getCpuArchitectureInt() {
        return Architecture.getValue().ordinal();
    }

    public static synchronized long getTotalRamInBytes() {
        if (totalRamInBytes == -1L) {
            long bytes = 0L;
            String result = CommonUtils.extractFieldFromSystemFile(new File("/proc/meminfo"), "MemTotal");
            if (!TextUtils.isEmpty((CharSequence)result)) {
                result = result.toUpperCase(Locale.US);
                try {
                    if (result.endsWith("KB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "KB", 1024);
                    } else if (result.endsWith("MB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "MB", 0x100000);
                    } else if (result.endsWith("GB")) {
                        bytes = CommonUtils.convertMemInfoToBytes(result, "GB", 0x40000000);
                    } else {
                        Fabric.getLogger().d("Fabric", "Unexpected meminfo format while computing RAM: " + result);
                    }
                }
                catch (NumberFormatException e) {
                    Fabric.getLogger().e("Fabric", "Unexpected meminfo format while computing RAM: " + result, e);
                }
            }
            totalRamInBytes = bytes;
        }
        return totalRamInBytes;
    }

    static long convertMemInfoToBytes(String memInfo, String notation, int notationMultiplier) {
        return Long.parseLong(memInfo.split(notation)[0].trim()) * (long)notationMultiplier;
    }

    public static ActivityManager.RunningAppProcessInfo getAppProcessInfo(String packageName, Context context) {
        ActivityManager actman = (ActivityManager)context.getSystemService("activity");
        List processes = actman.getRunningAppProcesses();
        ActivityManager.RunningAppProcessInfo procInfo = null;
        if (processes != null) {
            for (ActivityManager.RunningAppProcessInfo info : processes) {
                if (!info.processName.equals(packageName)) continue;
                procInfo = info;
                break;
            }
        }
        return procInfo;
    }

    public static String streamToString(InputStream is) throws IOException {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static String sha1(String source) {
        return CommonUtils.hash(source, "SHA-1");
    }

    public static String sha1(InputStream source) {
        return CommonUtils.hash(source, "SHA-1");
    }

    private static String hash(InputStream source, String sha1Instance) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = source.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
            return CommonUtils.hexify(digest.digest());
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not calculate hash for app icon.", e);
            return "";
        }
    }

    private static String hash(byte[] bytes, String algorithm) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Fabric.getLogger().e("Fabric", "Could not create hashing algorithm: " + algorithm + ", returning empty string.", e);
            return "";
        }
        digest.update(bytes);
        return CommonUtils.hexify(digest.digest());
    }

    private static String hash(String s, String algorithm) {
        return CommonUtils.hash(s.getBytes(), algorithm);
    }

    public static String createInstanceIdFrom(String ... sliceIds) {
        if (sliceIds == null || sliceIds.length == 0) {
            return null;
        }
        ArrayList<String> sliceIdList = new ArrayList<String>();
        for (String id2 : sliceIds) {
            if (id2 == null) continue;
            sliceIdList.add(id2.replace("-", "").toLowerCase(Locale.US));
        }
        Collections.sort(sliceIdList);
        StringBuilder sb = new StringBuilder();
        for (String id3 : sliceIdList) {
            sb.append(id3);
        }
        String concatValue = sb.toString();
        return concatValue.length() > 0 ? CommonUtils.sha1(concatValue) : null;
    }

    public static long calculateFreeRamInBytes(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(mi);
        return mi.availMem;
    }

    public static long calculateUsedDiskSpaceInBytes(String path) {
        StatFs statFs = new StatFs(path);
        long blockSizeBytes = statFs.getBlockSize();
        long totalSpaceBytes = blockSizeBytes * (long)statFs.getBlockCount();
        long availableSpaceBytes = blockSizeBytes * (long)statFs.getAvailableBlocks();
        return totalSpaceBytes - availableSpaceBytes;
    }

    public static float getBatteryLevel(Context context) {
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent battery = context.registerReceiver(null, ifilter);
        int level = battery.getIntExtra("level", -1);
        int scale = battery.getIntExtra("scale", -1);
        return (float)level / (float)scale;
    }

    public static boolean getProximitySensorEnabled(Context context) {
        if (CommonUtils.isEmulator(context)) {
            return false;
        }
        SensorManager sm = (SensorManager)context.getSystemService("sensor");
        Sensor prox = sm.getDefaultSensor(8);
        return prox != null;
    }

    public static void logControlled(Context context, String msg) {
        if (CommonUtils.isClsTrace(context)) {
            Fabric.getLogger().d("Fabric", msg);
        }
    }

    public static void logControlledError(Context context, String msg, Throwable tr) {
        if (CommonUtils.isClsTrace(context)) {
            Fabric.getLogger().e("Fabric", msg);
        }
    }

    public static void logControlled(Context context, int level, String tag, String msg) {
        if (CommonUtils.isClsTrace(context)) {
            Fabric.getLogger().log(level, "Fabric", msg);
        }
    }

    public static boolean isClsTrace(Context context) {
        if (clsTrace == null) {
            clsTrace = CommonUtils.getBooleanResourceValue(context, "com.crashlytics.Trace", false);
        }
        return clsTrace;
    }

    public static boolean getBooleanResourceValue(Context context, String key, boolean defaultValue) {
        Resources resources;
        if (context != null && (resources = context.getResources()) != null) {
            int id2 = CommonUtils.getResourcesIdentifier(context, key, "bool");
            if (id2 > 0) {
                return resources.getBoolean(id2);
            }
            id2 = CommonUtils.getResourcesIdentifier(context, key, "string");
            if (id2 > 0) {
                return Boolean.parseBoolean(context.getString(id2));
            }
        }
        return defaultValue;
    }

    public static int getResourcesIdentifier(Context context, String key, String resourceType) {
        Resources resources = context.getResources();
        return resources.getIdentifier(key, resourceType, CommonUtils.getResourcePackageName(context));
    }

    public static boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return "sdk".equals(Build.PRODUCT) || "google_sdk".equals(Build.PRODUCT) || androidId == null;
    }

    public static boolean isRooted(Context context) {
        boolean isEmulator = CommonUtils.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        File file = new File("/system/app/Superuser.apk");
        if (file.exists()) {
            return true;
        }
        file = new File("/system/xbin/su");
        return !isEmulator && file.exists();
    }

    public static boolean isDebuggerAttached() {
        return Debug.isDebuggerConnected() || Debug.waitingForDebugger();
    }

    public static int getDeviceState(Context context) {
        int deviceState = 0;
        if (CommonUtils.isEmulator(context)) {
            deviceState |= 1;
        }
        if (CommonUtils.isRooted(context)) {
            deviceState |= 2;
        }
        if (CommonUtils.isDebuggerAttached()) {
            deviceState |= 4;
        }
        return deviceState;
    }

    public static int getBatteryVelocity(Context context, boolean powerConnected) {
        float batterLevel = CommonUtils.getBatteryLevel(context);
        if (!powerConnected) {
            return 1;
        }
        if (powerConnected && (double)batterLevel >= 99.0) {
            return 3;
        }
        if (powerConnected && (double)batterLevel < 99.0) {
            return 2;
        }
        return 0;
    }

    @SuppressLint(value={"GetInstance"})
    public static Cipher createCipher(int mode, String key) throws InvalidKeyException {
        if (key.length() < 32) {
            throw new InvalidKeyException("Key must be at least 32 bytes.");
        }
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), 0, 32, "AES/ECB/PKCS7Padding");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
        }
        catch (GeneralSecurityException e) {
            Fabric.getLogger().e("Fabric", "Could not create Cipher for AES/ECB/PKCS7Padding - should never happen.", e);
            throw new RuntimeException(e);
        }
        cipher.init(mode, secretKey);
        return cipher;
    }

    public static String hexify(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_VALUES[v >>> 4];
            hexChars[i * 2 + 1] = HEX_VALUES[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static String getStringsFileValue(Context context, String key) {
        int id2 = CommonUtils.getResourcesIdentifier(context, key, "string");
        if (id2 > 0) {
            return context.getString(id2);
        }
        return "";
    }

    public static void closeOrLog(Closeable c, String message) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                Fabric.getLogger().e("Fabric", message, e);
            }
        }
    }

    public static void flushOrLog(Flushable f, String message) {
        if (f != null) {
            try {
                f.flush();
            }
            catch (IOException e) {
                Fabric.getLogger().e("Fabric", message, e);
            }
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String padWithZerosToMaxIntWidth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be zero or greater");
        }
        return String.format(Locale.US, "%1$10s", value).replace(' ', '0');
    }

    public static String getResourcePackageName(Context context) {
        int iconId = context.getApplicationContext().getApplicationInfo().icon;
        if (iconId > 0) {
            return context.getResources().getResourcePackageName(iconId);
        }
        return context.getPackageName();
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int count;
        while ((count = is.read(buffer)) != -1) {
            os.write(buffer, 0, count);
        }
    }

    public static String logPriorityToString(int priority) {
        switch (priority) {
            case 7: {
                return "A";
            }
            case 3: {
                return "D";
            }
            case 6: {
                return "E";
            }
            case 4: {
                return "I";
            }
            case 2: {
                return "V";
            }
            case 5: {
                return "W";
            }
        }
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAppIconHashOrNull(Context context) {
        String string2;
        InputStream is = null;
        try {
            is = context.getResources().openRawResource(CommonUtils.getAppIconResourceId(context));
            String sha1 = CommonUtils.sha1(is);
            string2 = CommonUtils.isNullOrEmpty(sha1) ? null : sha1;
        }
        catch (Exception e) {
            try {
                Fabric.getLogger().e("Fabric", "Could not calculate hash for app icon.", e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
                throw throwable;
            }
            CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
            return null;
        }
        CommonUtils.closeOrLog(is, "Failed to close icon input stream.");
        return string2;
    }

    public static int getAppIconResourceId(Context context) {
        return context.getApplicationContext().getApplicationInfo().icon;
    }

    public static String resolveBuildId(Context context) {
        String buildId = null;
        int id2 = CommonUtils.getResourcesIdentifier(context, "io.fabric.android.build_id", "string");
        if (id2 == 0) {
            id2 = CommonUtils.getResourcesIdentifier(context, "com.crashlytics.android.build_id", "string");
        }
        if (id2 != 0) {
            buildId = context.getResources().getString(id2);
            Fabric.getLogger().d("Fabric", "Build ID is: " + buildId);
        }
        return buildId;
    }

    public static boolean checkPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    public static boolean canTryConnection(Context context) {
        if (CommonUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
        return true;
    }

    static enum Architecture {
        X86_32,
        X86_64,
        ARM_UNKNOWN,
        PPC,
        PPC64,
        ARMV6,
        ARMV7,
        UNKNOWN,
        ARMV7S,
        ARM64;

        private static final Map<String, Architecture> matcher;

        static Architecture getValue() {
            String arch = Build.CPU_ABI;
            if (TextUtils.isEmpty((CharSequence)arch)) {
                Fabric.getLogger().d("Fabric", "Architecture#getValue()::Build.CPU_ABI returned null or empty");
                return UNKNOWN;
            }
            Architecture value = matcher.get(arch = arch.toLowerCase(Locale.US));
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        static {
            matcher = new HashMap<String, Architecture>(4);
            matcher.put("armeabi-v7a", ARMV7);
            matcher.put("armeabi", ARMV6);
            matcher.put("x86", X86_32);
        }
    }
}

