/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AdvertisingInfo;
import io.fabric.sdk.android.services.common.AdvertisingInfoProvider;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeviceIdentifierProvider;
import io.fabric.sdk.android.services.common.InstallerPackageNameProvider;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import org.json.JSONObject;

public class IdManager {
    private static final Pattern ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
    private static final String FORWARD_SLASH_REGEX = Pattern.quote("/");
    private final ReentrantLock installationIdLock = new ReentrantLock();
    private final InstallerPackageNameProvider installerPackageNameProvider;
    private final boolean collectHardwareIds;
    private final boolean collectUserIds;
    private final Context appContext;
    private final String appIdentifier;
    private final String appInstallIdentifier;
    private final Collection<Kit> kits;

    public IdManager(Context appContext, String appIdentifier, String appInstallIdentifier, Collection<Kit> kits) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext must not be null");
        }
        if (appIdentifier == null) {
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        if (kits == null) {
            throw new IllegalArgumentException("kits must not be null");
        }
        this.appContext = appContext;
        this.appIdentifier = appIdentifier;
        this.appInstallIdentifier = appInstallIdentifier;
        this.kits = kits;
        this.installerPackageNameProvider = new InstallerPackageNameProvider();
        this.collectHardwareIds = CommonUtils.getBooleanResourceValue(appContext, "com.crashlytics.CollectDeviceIdentifiers", true);
        if (!this.collectHardwareIds) {
            Fabric.getLogger().d("Fabric", "Device ID collection disabled for " + appContext.getPackageName());
        }
        this.collectUserIds = CommonUtils.getBooleanResourceValue(appContext, "com.crashlytics.CollectUserIdentifiers", true);
        if (!this.collectUserIds) {
            Fabric.getLogger().d("Fabric", "User information collection disabled for " + appContext.getPackageName());
        }
    }

    public String createIdHeaderValue(String apiKey, String packageName) {
        Cipher cipher = null;
        try {
            String replacementString = new String(new char[]{'s', 'l', 'c'});
            StringBuilder replacement = new StringBuilder(replacementString);
            String obsId = packageName.replaceAll("\\.", replacement.reverse().toString());
            String hash = CommonUtils.sha1(apiKey + obsId);
            cipher = CommonUtils.createCipher(1, hash);
        }
        catch (GeneralSecurityException e) {
            Fabric.getLogger().e("Fabric", "Could not create cipher to encrypt headers.", e);
            return "";
        }
        JSONObject ids = new JSONObject();
        this.addAppInstallIdTo(ids);
        this.addDeviceIdentifiersTo(ids);
        this.addOsVersionTo(ids);
        this.addModelName(ids);
        String toReturn = "";
        if (ids.length() > 0) {
            try {
                toReturn = CommonUtils.hexify(cipher.doFinal(ids.toString().getBytes()));
            }
            catch (GeneralSecurityException e) {
                Fabric.getLogger().e("Fabric", "Could not encrypt IDs", e);
            }
        }
        return toReturn;
    }

    private void addAppInstallIdTo(JSONObject ids) {
        try {
            ids.put("APPLICATION_INSTALLATION_UUID".toLowerCase(Locale.US), (Object)this.getAppInstallIdentifier());
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not write application id to JSON", e);
        }
    }

    private void addDeviceIdentifiersTo(JSONObject ids) {
        for (Map.Entry<DeviceIdentifierType, String> id2 : this.getDeviceIdentifiers().entrySet()) {
            try {
                ids.put(id2.getKey().name().toLowerCase(Locale.US), (Object)id2.getValue());
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Could not write value to JSON: " + id2.getKey().name(), e);
            }
        }
    }

    private void addOsVersionTo(JSONObject ids) {
        try {
            ids.put("os_version", (Object)this.getOsVersionString());
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not write OS version to JSON", e);
        }
    }

    private void addModelName(JSONObject ids) {
        try {
            ids.put("model", (Object)this.getModelName());
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Could not write model to JSON", e);
        }
    }

    public boolean canCollectUserIds() {
        return this.collectUserIds;
    }

    private boolean hasPermission(String permission2) {
        boolean granted = 0 == this.appContext.checkCallingPermission(permission2);
        return granted;
    }

    private String formatId(String id2) {
        return id2 == null ? null : ID_PATTERN.matcher(id2).replaceAll("").toLowerCase(Locale.US);
    }

    public String getAppInstallIdentifier() {
        SharedPreferences prefs;
        String appInstallId = this.appInstallIdentifier;
        if (appInstallId == null && (appInstallId = (prefs = CommonUtils.getSharedPrefs(this.appContext)).getString("crashlytics.installation.id", null)) == null) {
            appInstallId = this.createInstallationUUID(prefs);
        }
        return appInstallId;
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    public String getOsVersionString() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.VERSION.RELEASE), this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL));
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    private String removeForwardSlashesIn(String s) {
        return s.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    public String getDeviceUUID() {
        SharedPreferences prefs;
        String toReturn = "";
        if (this.collectHardwareIds && (toReturn = this.getAndroidId()) == null && (toReturn = (prefs = CommonUtils.getSharedPrefs(this.appContext)).getString("crashlytics.installation.id", null)) == null) {
            toReturn = this.createInstallationUUID(prefs);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createInstallationUUID(SharedPreferences prefs) {
        this.installationIdLock.lock();
        try {
            String uuid = prefs.getString("crashlytics.installation.id", null);
            if (uuid == null) {
                uuid = this.formatId(UUID.randomUUID().toString());
                prefs.edit().putString("crashlytics.installation.id", uuid).commit();
            }
            String string2 = uuid;
            return string2;
        }
        finally {
            this.installationIdLock.unlock();
        }
    }

    public Map<DeviceIdentifierType, String> getDeviceIdentifiers() {
        HashMap<DeviceIdentifierType, String> ids = new HashMap<DeviceIdentifierType, String>();
        for (Kit kit : this.kits) {
            if (!(kit instanceof DeviceIdentifierProvider)) continue;
            DeviceIdentifierProvider idProvider = (DeviceIdentifierProvider)((Object)kit);
            Map<DeviceIdentifierType, String> kitIds = idProvider.getDeviceIdentifiers();
            for (Map.Entry<DeviceIdentifierType, String> entry : kitIds.entrySet()) {
                this.putNonNullIdInto(ids, entry.getKey(), entry.getValue());
            }
        }
        this.putNonNullIdInto(ids, DeviceIdentifierType.ANDROID_ID, this.getAndroidId());
        this.putNonNullIdInto(ids, DeviceIdentifierType.ANDROID_DEVICE_ID, this.getTelephonyId());
        this.putNonNullIdInto(ids, DeviceIdentifierType.ANDROID_SERIAL, this.getSerialNumber());
        this.putNonNullIdInto(ids, DeviceIdentifierType.WIFI_MAC_ADDRESS, this.getWifiMacAddress());
        this.putNonNullIdInto(ids, DeviceIdentifierType.BLUETOOTH_MAC_ADDRESS, this.getBluetoothMacAddress());
        this.putNonNullIdInto(ids, DeviceIdentifierType.ANDROID_ADVERTISING_ID, this.getAdvertisingId());
        return Collections.unmodifiableMap(ids);
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }

    public String getAdvertisingId() {
        AdvertisingInfo advertisingInfo;
        String toReturn = null;
        if (this.collectHardwareIds && (advertisingInfo = new AdvertisingInfoProvider(this.appContext).getAdvertisingInfo()) != null) {
            toReturn = advertisingInfo.advertisingId;
        }
        return toReturn;
    }

    private void putNonNullIdInto(Map<DeviceIdentifierType, String> idMap, DeviceIdentifierType idKey, String idValue) {
        if (idValue != null) {
            idMap.put(idKey, idValue);
        }
    }

    public String getAndroidId() {
        String androidId;
        String toReturn = null;
        if (this.collectHardwareIds && !"9774d56d682e549c".equals(androidId = Settings.Secure.getString((ContentResolver)this.appContext.getContentResolver(), (String)"android_id"))) {
            toReturn = this.formatId(androidId);
        }
        return toReturn;
    }

    public String getTelephonyId() {
        TelephonyManager tm;
        if (this.collectHardwareIds && this.hasPermission("android.permission.READ_PHONE_STATE") && (tm = (TelephonyManager)this.appContext.getSystemService("phone")) != null) {
            return this.formatId(tm.getDeviceId());
        }
        return null;
    }

    public String getWifiMacAddress() {
        WifiInfo wifiInfo;
        WifiManager wifiMgr;
        if (this.collectHardwareIds && this.hasPermission("android.permission.ACCESS_WIFI_STATE") && (wifiMgr = (WifiManager)this.appContext.getSystemService("wifi")) != null && (wifiInfo = wifiMgr.getConnectionInfo()) != null) {
            return this.formatId(wifiInfo.getMacAddress());
        }
        return null;
    }

    public String getBluetoothMacAddress() {
        if (this.collectHardwareIds && this.hasPermission("android.permission.BLUETOOTH")) {
            try {
                BluetoothAdapter bt = BluetoothAdapter.getDefaultAdapter();
                if (bt != null) {
                    this.formatId(bt.getAddress());
                }
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Utils#getBluetoothMacAddress failed, returning null. Requires prior call to BluetoothAdatpter.getDefaultAdapter() on thread that has called Looper.prepare()", e);
            }
        }
        return null;
    }

    public String getSerialNumber() {
        if (this.collectHardwareIds && Build.VERSION.SDK_INT >= 9) {
            try {
                Field field = Build.class.getField("SERIAL");
                return this.formatId((String)field.get(null));
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Could not retrieve android.os.Build.SERIAL value", e);
            }
        }
        return null;
    }

    public static enum DeviceIdentifierType {
        WIFI_MAC_ADDRESS(1),
        BLUETOOTH_MAC_ADDRESS(2),
        FONT_TOKEN(53),
        ANDROID_ID(100),
        ANDROID_DEVICE_ID(101),
        ANDROID_SERIAL(102),
        ANDROID_ADVERTISING_ID(103);

        public final int protobufIndex;

        private DeviceIdentifierType(int pbufIndex) {
            this.protobufIndex = pbufIndex;
        }
    }
}

