/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.concurrency;

import io.fabric.sdk.android.services.concurrency.Dependency;
import io.fabric.sdk.android.services.concurrency.Task;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class DependencyPriorityBlockingQueue<E extends Dependency & Task>
extends PriorityBlockingQueue<E> {
    final Queue<E> blockedQueue = new LinkedList();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public E take() throws InterruptedException {
        return this.get(0, null, null);
    }

    @Override
    public E peek() {
        try {
            return this.get(1, null, null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(3, timeout, unit);
    }

    @Override
    public E poll() {
        try {
            return this.get(2, null, null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = this.blockedQueue.size() + super.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.lock();
            T[] TArray = this.concatenate(super.toArray(a), this.blockedQueue.toArray(a));
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        try {
            this.lock.lock();
            Object[] objectArray = this.concatenate(super.toArray(), this.blockedQueue.toArray());
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        try {
            this.lock.lock();
            int numberOfItems = super.drainTo(c) + this.blockedQueue.size();
            while (!this.blockedQueue.isEmpty()) {
                c.add(this.blockedQueue.poll());
            }
            int n = numberOfItems;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        try {
            int numberOfItems;
            this.lock.lock();
            for (numberOfItems = super.drainTo(c, maxElements); !this.blockedQueue.isEmpty() && numberOfItems <= maxElements; ++numberOfItems) {
                c.add(this.blockedQueue.poll());
            }
            int n = numberOfItems;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        try {
            this.lock.lock();
            boolean bl = super.contains(o) || this.blockedQueue.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.blockedQueue.clear();
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        try {
            this.lock.lock();
            boolean bl = super.remove(o) || this.blockedQueue.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        try {
            this.lock.lock();
            boolean bl = super.removeAll(collection) | this.blockedQueue.removeAll(collection);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    E performOperation(int operation, Long time, TimeUnit unit) throws InterruptedException {
        Dependency value;
        switch (operation) {
            case 0: {
                value = (Dependency)super.take();
                break;
            }
            case 1: {
                value = (Dependency)super.peek();
                break;
            }
            case 2: {
                value = (Dependency)super.poll();
                break;
            }
            case 3: {
                value = (Dependency)super.poll(time, unit);
                break;
            }
            default: {
                return null;
            }
        }
        return (E)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean offerBlockedResult(int operation, E result) {
        try {
            this.lock.lock();
            if (operation == 1) {
                super.remove(result);
            }
            boolean bl = this.blockedQueue.offer(result);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    E get(int operation, Long time, TimeUnit unit) throws InterruptedException {
        E result;
        while ((result = this.performOperation(operation, time, unit)) != null && !this.canProcess(result)) {
            this.offerBlockedResult(operation, result);
        }
        return result;
    }

    boolean canProcess(E result) {
        return result.areDependenciesMet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleBlockedQueue() {
        try {
            this.lock.lock();
            Iterator iterator = this.blockedQueue.iterator();
            while (iterator.hasNext()) {
                Dependency blockedItem = (Dependency)iterator.next();
                if (!this.canProcess(blockedItem)) continue;
                super.offer(blockedItem);
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    <T> T[] concatenate(T[] arr1, T[] arr2) {
        int arr1Len = arr1.length;
        int arr2Len = arr2.length;
        Object[] C = (Object[])Array.newInstance(arr1.getClass().getComponentType(), arr1Len + arr2Len);
        System.arraycopy(arr1, 0, C, 0, arr1Len);
        System.arraycopy(arr2, 0, C, arr1Len, arr2Len);
        return C;
    }
}

