/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.concurrency;

import io.fabric.sdk.android.services.concurrency.Dependency;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityProvider;
import io.fabric.sdk.android.services.concurrency.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class PriorityTask
implements Dependency<Task>,
PriorityProvider,
Task {
    private final List<Task> dependencies = new ArrayList<Task>();
    private final AtomicBoolean hasRun = new AtomicBoolean(false);
    private final AtomicReference<Throwable> throwable = new AtomicReference<Object>(null);

    @Override
    public synchronized Collection<Task> getDependencies() {
        return Collections.unmodifiableCollection(this.dependencies);
    }

    @Override
    public synchronized void addDependency(Task task) {
        this.dependencies.add(task);
    }

    @Override
    public boolean areDependenciesMet() {
        for (Task task : this.getDependencies()) {
            if (task.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void setFinished(boolean finished) {
        this.hasRun.set(finished);
    }

    @Override
    public boolean isFinished() {
        return this.hasRun.get();
    }

    @Override
    public Priority getPriority() {
        return Priority.NORMAL;
    }

    @Override
    public void setError(Throwable throwable) {
        this.throwable.set(throwable);
    }

    @Override
    public int compareTo(Object other) {
        return Priority.compareTo(this, other);
    }

    public static boolean isProperDelegate(Object object) {
        try {
            Dependency dep = (Dependency)object;
            Task task = (Task)object;
            PriorityProvider provider = (PriorityProvider)object;
            return dep != null && task != null && provider != null;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }
}

