/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.events;

import android.content.Context;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.events.EventTransform;
import io.fabric.sdk.android.services.events.EventsStorage;
import io.fabric.sdk.android.services.events.EventsStorageListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class EventsFilesManager<T> {
    protected final Context context;
    protected final EventTransform<T> transform;
    protected final CurrentTimeProvider currentTimeProvider;
    protected final EventsStorage eventStorage;
    private final int defaultMaxFilesToKeep;
    protected volatile long lastRollOverTime;
    protected final List<EventsStorageListener> rollOverListeners = new CopyOnWriteArrayList<EventsStorageListener>();

    public EventsFilesManager(Context context, EventTransform<T> transform, CurrentTimeProvider currentTimeProvider, EventsStorage eventStorage, int defaultMaxFilesToKeep) throws IOException {
        this.context = context.getApplicationContext();
        this.transform = transform;
        this.eventStorage = eventStorage;
        this.currentTimeProvider = currentTimeProvider;
        this.lastRollOverTime = this.currentTimeProvider.getCurrentTimeMillis();
        this.defaultMaxFilesToKeep = defaultMaxFilesToKeep;
    }

    public void writeEvent(T event) throws IOException {
        byte[] eventBytes = this.transform.toBytes(event);
        this.rollFileOverIfNeeded(eventBytes.length);
        this.eventStorage.add(eventBytes);
    }

    public void registerRollOverListener(EventsStorageListener listener) {
        if (listener != null) {
            this.rollOverListeners.add(listener);
        }
    }

    public boolean rollFileOver() throws IOException {
        boolean fileRolledOver = false;
        String targetFileName = null;
        if (!this.eventStorage.isWorkingFileEmpty()) {
            targetFileName = this.generateUniqueRollOverFileName();
            this.eventStorage.rollOver(targetFileName);
            CommonUtils.logControlled(this.context, 4, "Fabric", String.format(Locale.US, "generated new file %s", targetFileName));
            this.lastRollOverTime = this.currentTimeProvider.getCurrentTimeMillis();
            fileRolledOver = true;
        }
        this.triggerRollOverOnListeners(targetFileName);
        return fileRolledOver;
    }

    private void rollFileOverIfNeeded(int newEventSizeInBytes) throws IOException {
        if (!this.eventStorage.canWorkingFileStore(newEventSizeInBytes, this.getMaxByteSizePerFile())) {
            String msg = String.format(Locale.US, "session analytics events file is %d bytes, new event is %d bytes, this is over flush limit of %d, rolling it over", this.eventStorage.getWorkingFileUsedSizeInBytes(), newEventSizeInBytes, this.getMaxByteSizePerFile());
            CommonUtils.logControlled(this.context, 4, "Fabric", msg);
            this.rollFileOver();
        }
    }

    protected abstract String generateUniqueRollOverFileName();

    protected int getMaxFilesToKeep() {
        return this.defaultMaxFilesToKeep;
    }

    protected int getMaxByteSizePerFile() {
        return 8000;
    }

    private void triggerRollOverOnListeners(String rolledOverFile) {
        for (EventsStorageListener eventStorageRollOverListener : this.rollOverListeners) {
            try {
                eventStorageRollOverListener.onRollOver(rolledOverFile);
            }
            catch (Exception e) {
                CommonUtils.logControlledError(this.context, "One of the roll over listeners threw an exception", e);
            }
        }
    }

    public List<File> getBatchOfFilesToSend() {
        return this.eventStorage.getBatchOfFilesToSend(1);
    }

    public void deleteSentFiles(List<File> files) {
        this.eventStorage.deleteFilesInRollOverDirectory(files);
    }

    public void deleteAllEventsFiles() {
        this.eventStorage.deleteFilesInRollOverDirectory(this.eventStorage.getAllFilesInRollOverDirectory());
        this.eventStorage.deleteWorkingFile();
    }

    public void deleteOldestInRollOverIfOverMax() {
        List<File> allFiles = this.eventStorage.getAllFilesInRollOverDirectory();
        int maxFiles = this.getMaxFilesToKeep();
        if (allFiles.size() <= maxFiles) {
            return;
        }
        int numberOfFilesToDelete = allFiles.size() - maxFiles;
        CommonUtils.logControlled(this.context, String.format(Locale.US, "Found %d files in  roll over directory, this is greater than %d, deleting %d oldest files", allFiles.size(), maxFiles, numberOfFilesToDelete));
        TreeSet<FileWithTimestamp> sortedFiles = new TreeSet<FileWithTimestamp>(new Comparator<FileWithTimestamp>(){

            @Override
            public int compare(FileWithTimestamp arg0, FileWithTimestamp arg1) {
                return (int)(arg0.timestamp - arg1.timestamp);
            }
        });
        for (File file : allFiles) {
            long creationTimestamp = this.parseCreationTimestampFromFileName(file.getName());
            sortedFiles.add(new FileWithTimestamp(file, creationTimestamp));
        }
        ArrayList<File> toDelete = new ArrayList<File>();
        for (FileWithTimestamp fileWithTimestamp : sortedFiles) {
            toDelete.add(fileWithTimestamp.file);
            if (toDelete.size() != numberOfFilesToDelete) continue;
            break;
        }
        this.eventStorage.deleteFilesInRollOverDirectory(toDelete);
    }

    public long parseCreationTimestampFromFileName(String fileName) {
        String[] fileNameParts = fileName.split("_");
        if (fileNameParts.length != 3) {
            return 0L;
        }
        try {
            return Long.valueOf(fileNameParts[2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static class FileWithTimestamp {
        final File file;
        final long timestamp;

        public FileWithTimestamp(File file, long timestamp) {
            this.file = file;
            this.timestamp = timestamp;
        }
    }
}

