/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.network;

import io.fabric.sdk.android.DefaultLogger;
import io.fabric.sdk.android.Logger;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.network.NetworkUtils;
import io.fabric.sdk.android.services.network.PinningInfoProvider;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    private final Logger logger;
    private PinningInfoProvider pinningInfo;
    private SSLSocketFactory sslSocketFactory;
    private boolean attemptedSslInit;

    public DefaultHttpRequestFactory() {
        this(new DefaultLogger());
    }

    public DefaultHttpRequestFactory(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setPinningInfoProvider(PinningInfoProvider pinningInfo) {
        if (this.pinningInfo != pinningInfo) {
            this.pinningInfo = pinningInfo;
            this.resetSSLSocketFactory();
        }
    }

    private synchronized void resetSSLSocketFactory() {
        this.attemptedSslInit = false;
        this.sslSocketFactory = null;
    }

    @Override
    public HttpRequest buildHttpRequest(HttpMethod method, String url, Map<String, String> queryParams) {
        SSLSocketFactory sslSocketFactory;
        HttpRequest httpRequest;
        switch (method) {
            case GET: {
                httpRequest = HttpRequest.get(url, queryParams, true);
                break;
            }
            case POST: {
                httpRequest = HttpRequest.post(url, queryParams, true);
                break;
            }
            case PUT: {
                httpRequest = HttpRequest.put(url);
                break;
            }
            case DELETE: {
                httpRequest = HttpRequest.delete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method!");
            }
        }
        if (this.isHttps(url) && this.pinningInfo != null && (sslSocketFactory = this.getSSLSocketFactory()) != null) {
            ((HttpsURLConnection)httpRequest.getConnection()).setSSLSocketFactory(sslSocketFactory);
        }
        return httpRequest;
    }

    private boolean isHttps(String url) {
        return url != null && url.toLowerCase(Locale.US).startsWith("https");
    }

    private synchronized SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory == null && !this.attemptedSslInit) {
            this.sslSocketFactory = this.initSSLSocketFactory();
        }
        return this.sslSocketFactory;
    }

    private synchronized SSLSocketFactory initSSLSocketFactory() {
        this.attemptedSslInit = true;
        try {
            SSLSocketFactory sslSocketFactory = NetworkUtils.getSSLSocketFactory(this.pinningInfo);
            this.logger.d("Fabric", "Custom SSL pinning enabled");
            return sslSocketFactory;
        }
        catch (Exception e) {
            this.logger.e("Fabric", "Exception while validating pinned certs", e);
            return null;
        }
    }
}

