/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import android.content.res.Resources;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ResponseParser;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AppRequestData;
import java.io.InputStream;

abstract class AbstractAppSpiCall
extends AbstractSpiCall {
    public AbstractAppSpiCall(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method) {
        super(kit, protocolAndHostOverride, url, requestFactory, method);
    }

    public boolean invoke(AppRequestData requestData) {
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = this.applyHeadersTo(httpRequest, requestData);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        Fabric.getLogger().d("Fabric", "Sending app info to " + this.getUrl());
        if (requestData.icon != null) {
            Fabric.getLogger().d("Fabric", "App icon hash is " + requestData.icon.hash);
            Fabric.getLogger().d("Fabric", "App icon size is " + requestData.icon.width + "x" + requestData.icon.height);
        }
        int statusCode = httpRequest.code();
        String kind = "POST".equals(httpRequest.method()) ? "Create" : "Update";
        Fabric.getLogger().d("Fabric", kind + " app request ID: " + httpRequest.header("X-REQUEST-ID"));
        Fabric.getLogger().d("Fabric", "Result was " + statusCode);
        return 0 == ResponseParser.parse(statusCode);
    }

    private HttpRequest applyHeadersTo(HttpRequest request, AppRequestData requestData) {
        return request.header("X-CRASHLYTICS-API-KEY", requestData.apiKey).header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.kit.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequest applyMultipartDataTo(HttpRequest request, AppRequestData requestData) {
        request = request.part("app[identifier]", requestData.appId).part("app[name]", requestData.name).part("app[display_version]", requestData.displayVersion).part("app[build_version]", requestData.buildVersion).part("app[source]", requestData.source).part("app[minimum_sdk_version]", requestData.minSdkVersion).part("app[built_sdk_version]", requestData.builtSdkVersion);
        if (!CommonUtils.isNullOrEmpty(requestData.instanceIdentifier)) {
            request.part("app[instance_identifier]", requestData.instanceIdentifier);
        }
        if (requestData.icon != null) {
            InputStream is = null;
            try {
                is = this.kit.getContext().getResources().openRawResource(requestData.icon.iconResourceId);
                request.part("app[icon][hash]", requestData.icon.hash).part("app[icon][data]", "icon.png", "application/octet-stream", is).part("app[icon][width]", requestData.icon.width).part("app[icon][height]", requestData.icon.height);
            }
            catch (Resources.NotFoundException e) {
                try {
                    Fabric.getLogger().e("Fabric", "Failed to find app icon with resource ID: " + requestData.icon.iconResourceId, e);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
                    throw throwable;
                }
                CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
            }
            CommonUtils.closeOrLog(is, "Failed to close app icon InputStream.");
        }
        if (requestData.sdkKits != null) {
            for (Kit kit : requestData.sdkKits) {
                String version = kit.getVersion() == null ? "" : kit.getVersion();
                request.part(this.sdkKitParamName(kit), version);
            }
        }
        return request;
    }

    String sdkKitParamName(Kit kit) {
        String kitIdentifier = kit.getIdentifier() == null ? "" : kit.getIdentifier();
        return "app[build][libraries][" + kitIdentifier + "]";
    }
}

