/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

public class ArrayIntCompressed {
    private byte[] data;
    private byte varyingBits;
    private byte trailingClearBits;

    public ArrayIntCompressed(byte[] bytes) {
        this.data = bytes;
        this.varyingBits = this.data[0];
        this.trailingClearBits = this.data[1];
    }

    public ArrayIntCompressed(int size, int leadingClearBits, int trailingClearBits) {
        this.init(size, 32 - leadingClearBits - trailingClearBits, trailingClearBits);
    }

    public ArrayIntCompressed(int[] ints, int offset, int length) {
        int leadingClearBits;
        int mask = 0;
        for (int i = 0; i < length; ++i) {
            mask |= ints[offset + i];
        }
        int trailingClearBits = 0;
        for (leadingClearBits = 0; (mask & 1 << 32 - leadingClearBits - 1) == 0 && leadingClearBits < 32; ++leadingClearBits) {
        }
        while ((mask & 1 << trailingClearBits) == 0 && trailingClearBits < 32 - leadingClearBits) {
            ++trailingClearBits;
        }
        this.init(length, 32 - leadingClearBits - trailingClearBits, trailingClearBits);
        for (int i = 0; i < length; ++i) {
            this.set(i, ints[offset + i]);
        }
    }

    private void init(int size, int varyingBits, int trailingClearBits) {
        this.data = new byte[2 + (int)(((long)size * (long)varyingBits - 1L) / 8L) + 1];
        this.varyingBits = this.data[0] = (byte)varyingBits;
        this.trailingClearBits = this.data[1] = (byte)trailingClearBits;
    }

    public void set(int index, int value) {
        value >>>= this.trailingClearBits;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if ((off += this.varyingBits) > 8) {
            int n = idx++;
            this.data[n] = (byte)(this.data[n] | (byte)(value >>> (off -= 8)));
            while (off > 8) {
                this.data[idx++] = (byte)(value >>> (off -= 8));
            }
        }
        int n = idx;
        this.data[n] = (byte)(this.data[n] | (byte)(value << 8 - off));
    }

    public int get(int index) {
        int value = 0;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if (off + this.varyingBits > 8) {
            value = (this.data[idx++] << off & 0xFF) >>> off;
            off += this.varyingBits - 8;
            while (off > 8) {
                value <<= 8;
                value |= this.data[idx++] & 0xFF;
                off -= 8;
            }
            value <<= off;
            value |= (this.data[idx] & 0xFF) >>> 8 - off;
        } else {
            value = (this.data[idx] << off & 0xFF) >>> 8 - this.varyingBits;
        }
        return value << this.trailingClearBits;
    }

    public byte[] toByteArray() {
        return this.data;
    }
}

