/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.util.Arrays;

public final class ArrayLong {
    long[] elements;
    int size;

    public ArrayLong() {
        this(10);
    }

    public ArrayLong(int initialCapacity) {
        this.elements = new long[initialCapacity];
        this.size = 0;
    }

    public void add(long element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = element;
    }

    public long get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.elements, 0, result, 0, this.size);
        return result;
    }

    public long lastElement() {
        return this.elements[this.size - 1];
    }

    public long firstElement() {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elements[0];
    }

    public void sort() {
        Arrays.sort(this.elements, 0, this.size);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.elements;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = new long[newCapacity];
            System.arraycopy(oldData, 0, this.elements, 0, this.size);
        }
    }
}

