/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

public class ArrayLongCompressed {
    private byte[] data;
    private byte varyingBits;
    private byte trailingClearBits;

    public ArrayLongCompressed(byte[] bytes) {
        this.data = bytes;
        this.varyingBits = this.data[0];
        this.trailingClearBits = this.data[1];
    }

    public ArrayLongCompressed(int size, int leadingClearBits, int trailingClearBits) {
        this.init(size, 64 - leadingClearBits - trailingClearBits, trailingClearBits);
    }

    public ArrayLongCompressed(long[] longs, int offset, int length) {
        int leadingClearBits;
        long mask = 0L;
        for (int i = 0; i < length; ++i) {
            mask |= longs[offset + i];
        }
        int trailingClearBits = 0;
        for (leadingClearBits = 0; (mask & (long)(1 << 64 - leadingClearBits - 1)) == 0L && leadingClearBits < 64; ++leadingClearBits) {
        }
        while ((mask & (long)(1 << trailingClearBits)) == 0L && trailingClearBits < 64 - leadingClearBits) {
            ++trailingClearBits;
        }
        this.init(length, 64 - leadingClearBits - trailingClearBits, trailingClearBits);
        for (int i = 0; i < length; ++i) {
            this.set(i, longs[offset + i]);
        }
    }

    private void init(int size, int varyingBits, int trailingClearBits) {
        this.data = new byte[2 + (int)(((long)size * (long)varyingBits - 1L) / 8L) + 1];
        this.varyingBits = this.data[0] = (byte)varyingBits;
        this.trailingClearBits = this.data[1] = (byte)trailingClearBits;
    }

    public void set(int index, long value) {
        value >>>= this.trailingClearBits;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if ((off += this.varyingBits) > 8) {
            int n = idx++;
            this.data[n] = (byte)(this.data[n] | (byte)(value >>> (off -= 8)));
            while (off > 8) {
                this.data[idx++] = (byte)(value >>> (off -= 8));
            }
        }
        int n = idx;
        this.data[n] = (byte)(this.data[n] | (byte)(value << 8 - off));
    }

    public long get(int index) {
        long value = 0L;
        long pos = (long)index * (long)this.varyingBits;
        int idx = 2 + (int)(pos >>> 3);
        int off = (int)pos & 7;
        if (off + this.varyingBits > 8) {
            value = (this.data[idx++] << off & 0xFF) >>> off;
            off += this.varyingBits - 8;
            while (off > 8) {
                value <<= 8;
                value |= (long)(this.data[idx++] & 0xFF);
                off -= 8;
            }
            value <<= off;
            value |= (long)((this.data[idx] & 0xFF) >>> 8 - off);
        } else {
            value = (this.data[idx] << off & 0xFF) >>> 8 - this.varyingBits;
        }
        return value << this.trailingClearBits;
    }

    public byte[] toByteArray() {
        return this.data;
    }
}

