/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.PrimeFinder;

public final class HashMapIntLong
implements Serializable {
    private static NoSuchElementException noSuchElementException = new NoSuchElementException("This is static exception, there is no stack trace available. It is thrown by get() method.");
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private int[] keys;
    private long[] values;

    public HashMapIntLong() {
        this(10);
    }

    public HashMapIntLong(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean put(int key, long value) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.values[hash] = value;
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
        ++this.size;
        return false;
    }

    public long get(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return this.values[hash];
            }
            hash = (hash + this.step) % this.capacity;
        }
        throw noSuchElementException;
    }

    public int[] getAllKeys() {
        int[] array2 = new int[this.size];
        int j = 0;
        for (int i = 0; i < this.used.length; ++i) {
            if (!this.used[i]) continue;
            array2[j++] = this.keys[i];
        }
        return array2;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
        this.values = new long[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.init(newCapacity);
        for (int i = 0; i < oldUsed.length; ++i) {
            if (!oldUsed[i]) continue;
            int key = oldKeys[i];
            int hash = (key & Integer.MAX_VALUE) % this.capacity;
            while (this.used[hash]) {
                hash = (hash + this.step) % this.capacity;
            }
            this.used[hash] = true;
            this.keys[hash] = key;
            this.values[hash] = oldValues[i];
        }
        this.size = oldSize;
    }
}

