/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.PrimeFinder;

public final class HashMapLongObject<E>
implements Serializable {
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private long[] keys;
    private E[] values;

    public HashMapLongObject() {
        this(10);
    }

    public HashMapLongObject(int initialCapacity) {
        this.init(initialCapacity);
    }

    public E put(long key, E value) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                E oldValue = this.values[hash];
                this.values[hash] = value;
                return oldValue;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
        ++this.size;
        return null;
    }

    private int hash(long key) {
        return (int)(key & Integer.MAX_VALUE);
    }

    public boolean containsKey(long key) {
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public E get(long key) {
        int hash = this.hash(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return this.values[hash];
            }
            hash = (hash + this.step) % this.capacity;
        }
        return null;
    }

    public <T> T[] getAllValues(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int index = 0;
        for (int ii = 0; ii < this.used.length; ++ii) {
            if (!this.used[ii]) continue;
            a[index++] = this.values[ii];
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public IteratorLong keys() {
        return new IteratorLong(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapLongObject.this.size;
            }

            @Override
            public long next() throws NoSuchElementException {
                while (++this.i < HashMapLongObject.this.used.length) {
                    if (!HashMapLongObject.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapLongObject.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<E> values() {
        return new Iterator<E>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapLongObject.this.size;
            }

            @Override
            public E next() throws NoSuchElementException {
                while (++this.i < HashMapLongObject.this.used.length) {
                    if (!HashMapLongObject.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapLongObject.this.values[this.i];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Entry<E>> entries() {
        return new Iterator<Entry<E>>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapLongObject.this.size;
            }

            @Override
            public Entry<E> next() throws NoSuchElementException {
                while (++this.i < HashMapLongObject.this.used.length) {
                    if (!HashMapLongObject.this.used[this.i]) continue;
                    ++this.n;
                    return new Entry<E>(){

                        @Override
                        public long getKey() {
                            return HashMapLongObject.this.keys[i];
                        }

                        @Override
                        public E getValue() {
                            return HashMapLongObject.this.values[i];
                        }
                    };
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        long[] oldKeys = this.keys;
        E[] oldValues = this.values;
        this.init(newCapacity);
        for (int i = 0; i < oldUsed.length; ++i) {
            if (!oldUsed[i]) continue;
            long key = oldKeys[i];
            int hash = this.hash(key) % this.capacity;
            while (this.used[hash]) {
                hash = (hash + this.step) % this.capacity;
            }
            this.used[hash] = true;
            this.keys[hash] = key;
            this.values[hash] = oldValues[i];
        }
        this.size = oldSize;
    }

    public static interface Entry<E> {
        public long getKey();

        public E getValue();
    }
}

