/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import org.eclipse.mat.collect.PrimeFinder;

public final class SetInt
implements Serializable {
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private int[] keys;

    public SetInt() {
        this(10);
    }

    public SetInt(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean add(int key) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return false;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        ++this.size;
        return true;
    }

    public boolean contains(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public int[] toArray() {
        int[] array2 = new int[this.size];
        int j = 0;
        for (int i = 0; i < this.used.length; ++i) {
            if (!this.used[i]) continue;
            array2[j++] = this.keys[i];
        }
        return array2;
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        this.init(newCapacity);
        for (int i = 0; i < oldUsed.length; ++i) {
            if (!oldUsed[i]) continue;
            int key = oldKeys[i];
            int hash = (key & Integer.MAX_VALUE) % this.capacity;
            while (this.used[hash]) {
                hash = (hash + this.step) % this.capacity;
            }
            this.used[hash] = true;
            this.keys[hash] = key;
        }
        this.size = oldSize;
    }
}

