/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.io.PositionInputStream;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.MessageUtil;

abstract class AbstractParser {
    protected PositionInputStream in;
    protected Version version;
    protected int idSize;

    AbstractParser() {
    }

    static Version readVersion(InputStream in) throws IOException {
        StringBuilder version = new StringBuilder();
        for (int bytesRead = 0; bytesRead < 20; ++bytesRead) {
            byte b = (byte)in.read();
            if (b != 0) {
                version.append((char)b);
                continue;
            }
            Version answer = Version.byLabel(version.toString());
            if (answer == null) {
                if (bytesRead <= 13) {
                    throw new IOException(Messages.AbstractParser_Error_NotHeapDump.pattern);
                }
                throw new IOException(MessageUtil.format(Messages.AbstractParser_Error_UnknownHPROFVersion, version.toString()));
            }
            if (answer == Version.JDK12BETA3) {
                throw new IOException(MessageUtil.format(Messages.AbstractParser_Error_UnsupportedHPROFVersion, answer.getLabel()));
            }
            return answer;
        }
        throw new IOException(Messages.AbstractParser_Error_InvalidHPROFHeader.pattern);
    }

    protected long readUnsignedInt() throws IOException {
        return 0xFFFFFFFFL & (long)this.in.readInt();
    }

    protected long readID() throws IOException {
        return this.idSize == 4 ? 0xFFFFFFFFL & (long)this.in.readInt() : this.in.readLong();
    }

    protected Object readValue(ISnapshot snapshot, int type) throws IOException {
        switch (type) {
            case 2: {
                long id2 = this.readID();
                return id2 == 0L ? null : new ObjectReference(snapshot, id2);
            }
            case 4: {
                return this.in.readByte() != 0;
            }
            case 5: {
                return Character.valueOf(this.in.readChar());
            }
            case 6: {
                return Float.valueOf(this.in.readFloat());
            }
            case 7: {
                return this.in.readDouble();
            }
            case 8: {
                return this.in.readByte();
            }
            case 9: {
                return this.in.readShort();
            }
            case 10: {
                return this.in.readInt();
            }
            case 11: {
                return this.in.readLong();
            }
        }
        throw new IOException(MessageUtil.format(Messages.AbstractParser_Error_IllegalType, type));
    }

    protected void skipValue() throws IOException {
        byte type = this.in.readByte();
        this.skipValue(type);
    }

    protected void skipValue(int type) throws IOException {
        if (type == 2) {
            this.in.skipBytes(this.idSize);
        } else {
            this.in.skipBytes(IPrimitiveArray.ELEMENT_SIZE[type]);
        }
    }

    protected int determineDumpNumber() {
        String dumpNr = System.getProperty("MAT_HPROF_DUMP_NR");
        return dumpNr == null ? 0 : Integer.parseInt(dumpNr);
    }

    static enum Version {
        JDK12BETA3("JAVA PROFILE 1.0"),
        JDK12BETA4("JAVA PROFILE 1.0.1"),
        JDK6("JAVA PROFILE 1.0.2"),
        ANDROID103("JAVA PROFILE 1.0.3");

        private String label;

        private Version(String label) {
            this.label = label;
        }

        public static Version byLabel(String label) {
            for (Version v : Version.values()) {
                if (!v.label.equals(label)) continue;
                return v;
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

