/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.ArrayDescription;
import org.eclipse.mat.hprof.HprofRandomAccessParser;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.model.AbstractArrayImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public class HprofHeapObjectReader
implements IObjectReader {
    private ISnapshot snapshot;
    private HprofRandomAccessParser hprofDump;
    private IIndexReader.IOne2LongIndex o2hprof;
    private List<Object> enhancers;

    @Override
    public void open(ISnapshot snapshot) throws IOException {
        this.snapshot = snapshot;
        AbstractParser.Version version = AbstractParser.Version.valueOf((String)((Object)snapshot.getSnapshotInfo().getProperty("hprof.version")));
        this.hprofDump = new HprofRandomAccessParser(new File(snapshot.getSnapshotInfo().getPath()), version, snapshot.getSnapshotInfo().getIdentifierSize());
        this.o2hprof = new IndexReader.LongIndexReader(new File(snapshot.getSnapshotInfo().getPrefix() + "o2hprof.index"));
        this.enhancers = new ArrayList<Object>();
    }

    @Override
    public long[] readObjectArrayContent(ObjectArrayImpl array2, int offset, int length) throws IOException, SnapshotException {
        Object info = array2.getInfo();
        if (info instanceof ArrayDescription.Offline) {
            ArrayDescription.Offline description = (ArrayDescription.Offline)info;
            long[] answer = (long[])description.getLazyReadContent();
            if (answer == null) {
                answer = this.hprofDump.readObjectArray(description, offset, length);
                if (offset == 0 && length == array2.getLength()) {
                    description.setLazyReadContent(answer);
                }
                return answer;
            }
            return (long[])this.fragment(array2, answer, offset, length);
        }
        if (info instanceof long[]) {
            return (long[])this.fragment(array2, info, offset, length);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object readPrimitiveArrayContent(PrimitiveArrayImpl array2, int offset, int length) throws IOException, SnapshotException {
        Object info = array2.getInfo();
        if (info instanceof ArrayDescription.Offline) {
            ArrayDescription.Offline description = (ArrayDescription.Offline)info;
            Object content = description.getLazyReadContent();
            if (content == null) {
                content = this.convert(array2, this.hprofDump.readPrimitiveArray(description, offset, length));
                if (offset == 0 && length == array2.getLength()) {
                    description.setLazyReadContent(content);
                }
                return content;
            }
            return this.fragment(array2, content, offset, length);
        }
        if (info instanceof ArrayDescription.Raw) {
            ArrayDescription.Raw description = (ArrayDescription.Raw)info;
            Object content = this.convert(array2, description.getContent());
            array2.setInfo(content);
            return this.fragment(array2, content, offset, length);
        }
        return this.fragment(array2, info, offset, length);
    }

    private Object convert(PrimitiveArrayImpl array2, byte[] content) {
        if (array2.getType() == 8) {
            return content;
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[array2.getType()];
        int length = content.length / elementSize;
        Object answer = Array.newInstance(IPrimitiveArray.COMPONENT_TYPE[array2.getType()], length);
        int index = 0;
        for (int ii = 0; ii < content.length; ii += elementSize) {
            switch (array2.getType()) {
                case 4: {
                    Array.set(answer, index, content[ii] != 0);
                    break;
                }
                case 5: {
                    Array.set(answer, index, Character.valueOf(this.readChar(content, ii)));
                    break;
                }
                case 6: {
                    Array.set(answer, index, Float.valueOf(this.readFloat(content, ii)));
                    break;
                }
                case 7: {
                    Array.set(answer, index, this.readDouble(content, ii));
                    break;
                }
                case 9: {
                    Array.set(answer, index, this.readShort(content, ii));
                    break;
                }
                case 10: {
                    Array.set(answer, index, this.readInt(content, ii));
                    break;
                }
                case 11: {
                    Array.set(answer, index, this.readLong(content, ii));
                }
            }
            ++index;
        }
        return answer;
    }

    private Object fragment(AbstractArrayImpl array2, Object content, int offset, int length) {
        if (offset == 0 && length == array2.getLength()) {
            return content;
        }
        Object answer = Array.newInstance(content.getClass().getComponentType(), length);
        System.arraycopy(content, offset, answer, 0, length);
        return answer;
    }

    @Override
    public IObject read(int objectId, ISnapshot snapshot) throws SnapshotException, IOException {
        long filePosition = this.o2hprof.get(objectId);
        return this.hprofDump.read(objectId, filePosition, snapshot);
    }

    @Override
    public void close() throws IOException {
        try {
            this.hprofDump.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.o2hprof.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private short readShort(byte[] data, int offset) {
        int b1 = data[offset] & 0xFF;
        int b2 = data[offset + 1] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    private char readChar(byte[] data, int offset) {
        int b1 = data[offset] & 0xFF;
        int b2 = data[offset + 1] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    private int readInt(byte[] data, int offset) {
        int ch1 = data[offset] & 0xFF;
        int ch2 = data[offset + 1] & 0xFF;
        int ch3 = data[offset + 2] & 0xFF;
        int ch4 = data[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private float readFloat(byte[] data, int offset) {
        return Float.intBitsToFloat(this.readInt(data, offset));
    }

    private long readLong(byte[] data, int offset) {
        return (((long)data[offset] & 0xFFL) << 56) + ((long)(data[offset + 1] & 0xFF) << 48) + ((long)(data[offset + 2] & 0xFF) << 40) + ((long)(data[offset + 3] & 0xFF) << 32) + ((long)(data[offset + 4] & 0xFF) << 24) + (long)((data[offset + 5] & 0xFF) << 16) + (long)((data[offset + 6] & 0xFF) << 8) + (long)((data[offset + 7] & 0xFF) << 0);
    }

    private double readDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(this.readLong(data, offset));
    }
}

