/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.ArrayDescription;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.io.BufferedRandomAccessInputStream;
import org.eclipse.mat.parser.io.PositionInputStream;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.MessageUtil;

public class HprofRandomAccessParser
extends AbstractParser {
    public HprofRandomAccessParser(File file, AbstractParser.Version version, int identifierSize) throws IOException {
        this.in = new PositionInputStream(new BufferedRandomAccessInputStream(new RandomAccessFile(file, "r"), 512));
        this.version = version;
        this.idSize = identifierSize;
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    public synchronized IObject read(int objectId, long position, ISnapshot dump) throws IOException, SnapshotException {
        this.in.seek(position);
        int segmentType = this.in.readUnsignedByte();
        switch (segmentType) {
            case 33: {
                return this.readInstanceDump(objectId, dump);
            }
            case 34: {
                return this.readObjectArrayDump(objectId, dump);
            }
            case 35: {
                return this.readPrimitiveArrayDump(objectId, dump);
            }
        }
        throw new IOException(MessageUtil.format(Messages.HprofRandomAccessParser_Error_IllegalDumpSegment, segmentType));
    }

    public List<IClass> resolveClassHierarchy(ISnapshot snapshot, IClass clazz) throws SnapshotException {
        ArrayList<IClass> answer = new ArrayList<IClass>();
        answer.add(clazz);
        while (clazz.hasSuperClass()) {
            if ((clazz = (IClass)snapshot.getObject(clazz.getSuperClassId())) == null) {
                return null;
            }
            answer.add(clazz);
        }
        return answer;
    }

    private IObject readInstanceDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long address = this.readID();
        if (this.in.skipBytes(8 + this.idSize) != 8 + this.idSize) {
            throw new IOException();
        }
        List<IClass> hierarchy = this.resolveClassHierarchy(dump, dump.getClassOf(objectId));
        if (hierarchy == null) {
            throw new IOException(Messages.HprofRandomAccessParser_Error_DumpIncomplete.pattern);
        }
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (IClass clazz : hierarchy) {
            List<FieldDescriptor> fields = clazz.getFieldDescriptors();
            for (int ii = 0; ii < fields.size(); ++ii) {
                FieldDescriptor field = fields.get(ii);
                int type = field.getType();
                Object value = this.readValue(dump, type);
                instanceFields.add(new Field(field.getName(), field.getType(), value));
            }
        }
        ClassImpl classImpl = (ClassImpl)hierarchy.get(0);
        if (dump.isClassLoader(objectId)) {
            return new ClassLoaderImpl(objectId, address, classImpl, instanceFields);
        }
        return new InstanceImpl(objectId, address, classImpl, instanceFields);
    }

    private IArray readObjectArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long id2 = this.readID();
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.readID();
        IClass arrayType = (IClass)dump.getObject(dump.mapAddressToId(arrayClassObjectID));
        if (arrayType == null) {
            throw new RuntimeException(Messages.HprofRandomAccessParser_Error_MissingFakeClass.pattern);
        }
        Object content = null;
        if (size * this.idSize < 256) {
            long[] data = new long[size];
            for (int ii = 0; ii < data.length; ++ii) {
                data[ii] = this.readID();
            }
            content = data;
        } else {
            content = new ArrayDescription.Offline(false, this.in.position(), 0, size);
        }
        ObjectArrayImpl array2 = new ObjectArrayImpl(objectId, id2, (ClassImpl)arrayType, size);
        array2.setInfo(content);
        return array2;
    }

    private IArray readPrimitiveArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long id2 = this.readID();
        this.in.skipBytes(4);
        int arraySize = this.in.readInt();
        long elementType = this.in.readByte();
        if (elementType < 4L || elementType > 11L) {
            throw new IOException(Messages.Pass1Parser_Error_IllegalType.pattern);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[(int)elementType];
        int len = elementSize * arraySize;
        Object content = null;
        if (len < 256) {
            Object object;
            byte[] data = new byte[len];
            this.in.readFully(data);
            if (elementType == 8L) {
                object = data;
            } else {
                ArrayDescription.Raw raw2;
                object = raw2;
                raw2 = new ArrayDescription.Raw(data);
            }
            content = object;
        } else {
            content = new ArrayDescription.Offline(true, this.in.position(), elementSize, arraySize);
        }
        IClass clazz = null;
        String name = IPrimitiveArray.TYPE[(int)elementType];
        Collection<IClass> classes = dump.getClassesByName(name, false);
        if (classes == null || classes.isEmpty()) {
            throw new IOException(MessageUtil.format(Messages.HprofRandomAccessParser_Error_MissingClass, name));
        }
        if (classes.size() > 1) {
            throw new IOException(MessageUtil.format(Messages.HprofRandomAccessParser_Error_DuplicateClass, name));
        }
        clazz = classes.iterator().next();
        PrimitiveArrayImpl array2 = new PrimitiveArrayImpl(objectId, id2, (ClassImpl)clazz, arraySize, (int)elementType);
        array2.setInfo(content);
        return array2;
    }

    public synchronized long[] readObjectArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = this.idSize;
        this.in.seek(descriptor.getPosition() + (long)(offset * elementSize));
        long[] data = new long[length];
        for (int ii = 0; ii < data.length; ++ii) {
            data[ii] = this.readID();
        }
        return data;
    }

    public synchronized byte[] readPrimitiveArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = descriptor.getElementSize();
        this.in.seek(descriptor.getPosition() + (long)(offset * elementSize));
        byte[] data = new byte[length * elementSize];
        this.in.readFully(data);
        return data;
    }
}

