/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.lang.reflect.Modifier;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.PrettyPrinter;

public class CommonNameResolver {

    @Subject(value="java.lang.reflect.Constructor")
    public static class ConstructorResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                for (int i = 0; i < orefa.getLength(); ++i) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subject(value="java.lang.reflect.Method")
    public static class MethodResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("returnType")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                for (int i = 0; i < orefa.getLength(); ++i) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subject(value="java.lang.reflect.Field")
    public static class FieldResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("type")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            return r.toString();
        }
    }

    @Subject(value="java.lang.reflect.AccessibleObject")
    public static class AccessibleObjectResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            return r.toString();
        }

        protected void addClassName(ISnapshot snapshot, long addr, StringBuilder r) throws SnapshotException {
            int id2 = snapshot.mapAddressToId(addr);
            IObject ox = snapshot.getObject(id2);
            if (ox instanceof IClass) {
                IClass cls = (IClass)ox;
                r.append(cls.getName());
            }
        }
    }

    @Subject(value="java.net.URL")
    public static class URLResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            IObject query;
            IObject path;
            StringBuilder builder = new StringBuilder();
            IObject protocol = (IObject)obj.resolveValue("protocol");
            builder.append(protocol.getClassSpecificName());
            builder.append(":");
            IObject authority = (IObject)obj.resolveValue("authority");
            if (authority != null) {
                builder.append("//");
                builder.append(authority.getClassSpecificName());
            }
            if ((path = (IObject)obj.resolveValue("path")) != null) {
                builder.append(path.getClassSpecificName());
            }
            if ((query = (IObject)obj.resolveValue("query")) != null) {
                builder.append("?");
                builder.append(query.getClassSpecificName());
            }
            if ((ref = (IObject)obj.resolveValue("ref")) != null) {
                builder.append("#");
                builder.append(ref.getClassSpecificName());
            }
            return builder.toString();
        }
    }

    @Subject(value="byte[]")
    public static class ByteArrayResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray arr = (IPrimitiveArray)heapObject;
            byte[] value = (byte[])arr.getValueArray(0, Math.min(arr.getLength(), 1024));
            if (value == null) {
                return null;
            }
            StringBuilder r = new StringBuilder(value.length);
            for (int i = 0; i < value.length; ++i) {
                if (value[i] < 32 || value[i] > 126) {
                    r.append('.');
                    continue;
                }
                r.append((char)value[i]);
            }
            return r.toString();
        }
    }

    @Subject(value="char[]")
    public static class CharArrayResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray charArray = (IPrimitiveArray)heapObject;
            return PrettyPrinter.arrayAsString(charArray, 0, charArray.getLength(), 1024);
        }
    }

    @Subjects(value={"java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean"})
    public static class ValueResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            return String.valueOf(heapObject.resolveValue("value"));
        }
    }

    @Subject(value="java.lang.ThreadGroup")
    public static class ThreadGroupResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            IObject nameString = (IObject)object.resolveValue("name");
            if (nameString == null) {
                return null;
            }
            return nameString.getClassSpecificName();
        }
    }

    @Subject(value="java.lang.Thread")
    public static class ThreadResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject name = (IObject)obj.resolveValue("name");
            return name != null ? name.getClassSpecificName() : null;
        }
    }

    @Subjects(value={"java.lang.StringBuffer", "java.lang.StringBuilder"})
    public static class StringBufferResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            Integer count = (Integer)obj.resolveValue("count");
            if (count == null) {
                return null;
            }
            if (count == 0) {
                return "";
            }
            IPrimitiveArray charArray = (IPrimitiveArray)obj.resolveValue("value");
            if (charArray == null) {
                return null;
            }
            return PrettyPrinter.arrayAsString(charArray, 0, count, 1024);
        }
    }

    @Subject(value="java.lang.String")
    public static class StringResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            return PrettyPrinter.objectAsString(obj, 1024);
        }
    }
}

