/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.File;
import java.io.IOException;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;

public class IndexManager {
    public IIndexReader.IOne2ManyObjectsIndex inbound;
    public IIndexReader.IOne2ManyIndex outbound;
    public IIndexReader.IOne2OneIndex o2c;
    public IIndexReader.IOne2LongIndex idx;
    public IIndexReader.IOne2OneIndex a2s;
    public IIndexReader.IOne2ManyIndex domOut;
    public IIndexReader.IOne2LongIndex o2ret;
    public IIndexReader.IOne2OneIndex domIn;

    public void setReader(Index index, IIndexReader reader) {
        try {
            this.getClass().getField(index.filename).set(this, reader);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IIndexReader getReader(Index index) {
        try {
            return (IIndexReader)this.getClass().getField(index.filename).get(this);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IIndexReader.IOne2ManyIndex inbound() {
        return this.inbound;
    }

    public IIndexReader.IOne2ManyIndex outbound() {
        return this.outbound;
    }

    public IIndexReader.IOne2OneIndex o2class() {
        return this.o2c;
    }

    public IIndexReader.IOne2ManyObjectsIndex c2objects() {
        return this.inbound;
    }

    public IIndexReader.IOne2LongIndex o2address() {
        return this.idx;
    }

    public IIndexReader.IOne2OneIndex a2size() {
        return this.a2s;
    }

    public IIndexReader.IOne2ManyIndex dominated() {
        return this.domOut;
    }

    public IIndexReader.IOne2LongIndex o2retained() {
        return this.o2ret;
    }

    public IIndexReader.IOne2OneIndex dominator() {
        return this.domIn;
    }

    public void close() throws IOException {
        new Visitor(){

            @Override
            void visit(Index index, IIndexReader reader) throws IOException {
                if (reader == null) {
                    return;
                }
                reader.close();
                IndexManager.this.setReader(index, null);
            }
        }.doIt();
    }

    public void delete() throws IOException {
        new Visitor(){

            @Override
            void visit(Index index, IIndexReader reader) throws IOException {
                if (reader == null) {
                    return;
                }
                reader.close();
                reader.delete();
                IndexManager.this.setReader(index, null);
            }
        }.doIt();
    }

    private abstract class Visitor {
        private Visitor() {
        }

        abstract void visit(Index var1, IIndexReader var2) throws IOException;

        void doIt() throws IOException {
            try {
                for (Index index : Index.values()) {
                    IIndexReader reader = IndexManager.this.getReader(index);
                    this.visit(index, reader);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Index {
        INBOUND("inbound", IndexReader.InboundReader.class),
        OUTBOUND("outbound", IndexReader.IntIndex1NSortedReader.class),
        O2CLASS("o2c", IndexReader.IntIndexReader.class),
        IDENTIFIER("idx", IndexReader.LongIndexReader.class),
        A2SIZE("a2s", IndexReader.IntIndexReader.class),
        DOMINATED("domOut", IndexReader.IntIndex1NReader.class),
        O2RETAINED("o2ret", IndexReader.LongIndexReader.class),
        DOMINATOR("domIn", IndexReader.IntIndexReader.class);

        public String filename;
        Class<? extends IIndexReader> impl;

        private Index(String filename, Class<? extends IIndexReader> impl) {
            this.filename = filename;
            this.impl = impl;
        }

        public File getFile(String prefix) {
            return new File(prefix + this.filename + ".index");
        }
    }
}

