/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.ArrayIntCompressed;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.ArrayLongCompressed;
import org.eclipse.mat.collect.ArrayUtils;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.io.BitInputStream;
import org.eclipse.mat.parser.io.BitOutputStream;
import org.eclipse.mat.util.IProgressListener;

public abstract class IndexWriter {
    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int mostSignificantBit(int x) {
        int length = 0;
        if ((x & 0xFFFF0000) != 0) {
            length += 16;
            x >>= 16;
        }
        if ((x & 0xFF00) != 0) {
            length += 8;
            x >>= 8;
        }
        if ((x & 0xF0) != 0) {
            length += 4;
            x >>= 4;
        }
        if ((x & 0xC) != 0) {
            length += 2;
            x >>= 2;
        }
        if ((x & 2) != 0) {
            ++length;
            x >>= 1;
        }
        if ((x & 1) != 0) {
            ++length;
        }
        return length - 1;
    }

    public static int mostSignificantBit(long x) {
        long lead = x >>> 32;
        return lead == 0L ? IndexWriter.mostSignificantBit((int)x) : 32 + IndexWriter.mostSignificantBit((int)lead);
    }

    public static class LongIndexStreamer
    extends LongIndex {
        DataOutputStream out;
        ArrayLong pageStart;
        long[] page;
        int left;

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, int size, HashMapIntObject<Object> pages, int pageSize) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            int noOfPages = size / pageSize + (size % pageSize > 0 ? 1 : 0);
            for (int ii = 0; ii < noOfPages; ++ii) {
                int len;
                ArrayLongCompressed a = (ArrayLongCompressed)pages.get(ii);
                int n = len = ii + 1 < noOfPages ? pageSize : size % pageSize;
                if (a == null) {
                    this.addAll(new long[len]);
                    continue;
                }
                for (int jj = 0; jj < len; ++jj) {
                    this.add(a.get(jj));
                }
            }
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, long[] array2) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array2);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IIndexReader.IOne2LongIndex writeTo(File indexFile, IteratorLong iterator) throws IOException {
            FileOutputStream fos = new FileOutputStream(indexFile);
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
                this.openStream(out, 0L);
                this.addAll(iterator);
                this.closeStream();
                out.flush();
                IndexReader.LongIndexReader longIndexReader = this.getReader(indexFile);
                return longIndexReader;
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 500000);
            this.page = new long[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            if (this.left < this.page.length) {
                this.addPage();
            }
            for (int jj = 0; jj < this.pageStart.size(); ++jj) {
                this.out.writeLong(this.pageStart.get(jj));
            }
            this.out.writeInt(this.pageSize);
            this.out.writeInt(this.size);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + (long)(8 * this.pageStart.size()) + 8L - this.pageStart.firstElement();
        }

        IndexReader.LongIndexReader getReader(File indexFile) throws IOException {
            return new IndexReader.LongIndexReader(indexFile, this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        public void addAll(IteratorLong iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        public void add(long value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        public void addAll(long[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        public void addAll(long[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        private void addPage() throws IOException {
            ArrayLongCompressed array2 = new ArrayLongCompressed(this.page, 0, this.page.length - this.left);
            byte[] buffer = array2.toByteArray();
            this.out.write(buffer);
            int written = buffer.length;
            this.pages.put(this.pages.size(), new SoftReference<ArrayLongCompressed>(array2));
            this.pageStart.add(this.pageStart.lastElement() + (long)written);
            this.left = this.page.length;
        }

        @Override
        protected ArrayLongCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }
    }

    public static class LongIndexCollector
    extends LongIndex {
        int mostSignificantBit;

        public LongIndexCollector(int size, int mostSignificantBit) {
            super(size);
            this.mostSignificantBit = mostSignificantBit;
        }

        @Override
        protected ArrayLongCompressed getPage(int page) {
            ArrayLongCompressed array2 = (ArrayLongCompressed)this.pages.get(page);
            if (array2 == null) {
                int ps = page < this.size / this.pageSize ? this.pageSize : this.size % this.pageSize;
                array2 = new ArrayLongCompressed(ps, 63 - this.mostSignificantBit, 0);
                this.pages.put(page, array2);
            }
            return array2;
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile) throws IOException {
            return new LongIndexStreamer().writeTo(indexFile, this.size, this.pages, this.pageSize);
        }
    }

    static abstract class LongIndex {
        int pageSize;
        int size;
        HashMapIntObject<Object> pages;
        HashMapIntLong binarySearchCache = new HashMapIntLong(1024);

        protected LongIndex() {
        }

        protected LongIndex(int size) {
            this.init(size, 500000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new HashMapIntObject(size / pageSize + 1);
        }

        public long get(int index) {
            ArrayLongCompressed array2 = this.getPage(index / this.pageSize);
            return array2.get(index % this.pageSize);
        }

        public int reverse(long value) {
            int low = 0;
            int high = this.size - 1;
            int depth = 0;
            int page = -1;
            ArrayLongCompressed array2 = null;
            while (low <= high) {
                long midVal;
                int mid = low + high >> 1;
                if (depth++ < 10) {
                    try {
                        midVal = this.binarySearchCache.get(mid);
                    }
                    catch (NoSuchElementException e) {
                        int p = mid / this.pageSize;
                        if (p != page) {
                            page = p;
                            array2 = this.getPage(page);
                        }
                        midVal = array2.get(mid % this.pageSize);
                        this.binarySearchCache.put(mid, midVal);
                    }
                } else {
                    int p = mid / this.pageSize;
                    if (p != page) {
                        page = p;
                        array2 = this.getPage(page);
                    }
                    midVal = array2.get(mid % this.pageSize);
                }
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public void set(int index, long value) {
            ArrayLongCompressed array2 = this.getPage(index / this.pageSize);
            array2.set(index % this.pageSize, value);
        }

        protected abstract ArrayLongCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new HashMapIntObject(this.size / this.pageSize + 1);
            this.binarySearchCache = new HashMapIntLong(1024);
        }

        public int size() {
            return this.size;
        }
    }

    public static class InboundWriter {
        int size;
        File indexFile;
        int bitLength;
        int pageSize;
        BitOutputStream[] segments;
        int[] segmentSizes;

        public InboundWriter(int size, File indexFile) throws IOException {
            int segments;
            this.size = size;
            this.indexFile = indexFile;
            int requiredSegments = size / 500000 + 1;
            for (segments = 1; segments < requiredSegments; segments <<= 1) {
            }
            this.bitLength = IndexWriter.mostSignificantBit(size) + 1;
            this.pageSize = size / segments + 1;
            this.segments = new BitOutputStream[segments];
            this.segmentSizes = new int[segments];
        }

        public void log(int objectIndex, int refIndex, boolean isPseudo) throws IOException {
            int segment = objectIndex / this.pageSize;
            if (this.segments[segment] == null) {
                File segmentFile = new File(this.indexFile.getAbsolutePath() + segment + ".log");
                this.segments[segment] = new BitOutputStream(new FileOutputStream(segmentFile));
            }
            this.segments[segment].writeBit(isPseudo ? 1 : 0);
            this.segments[segment].writeInt(objectIndex, this.bitLength);
            this.segments[segment].writeInt(refIndex, this.bitLength);
            int n = segment;
            this.segmentSizes[n] = this.segmentSizes[n] + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IIndexReader.IOne2ManyObjectsIndex flush(IProgressListener monitor, KeyWriter keyWriter) throws IOException {
            this.close();
            int[] header = new int[this.size];
            DataOutputStream index = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.indexFile), 262144));
            BitInputStream segmentIn = null;
            try {
                IntIndexStreamer body = new IntIndexStreamer();
                body.openStream(index, 0L);
                for (int segment = 0; segment < this.segments.length; ++segment) {
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    File segmentFile = new File(this.indexFile.getAbsolutePath() + segment + ".log");
                    if (!segmentFile.exists()) continue;
                    segmentIn = new BitInputStream(new FileInputStream(segmentFile));
                    int[] objIndex = new int[this.segmentSizes[segment]];
                    int[] refIndex = new int[this.segmentSizes[segment]];
                    for (int ii = 0; ii < this.segmentSizes[segment]; ++ii) {
                        boolean isPseudo = segmentIn.readBit() == 1;
                        objIndex[ii] = segmentIn.readInt(this.bitLength);
                        refIndex[ii] = segmentIn.readInt(this.bitLength);
                        if (!isPseudo) continue;
                        refIndex[ii] = -1 - refIndex[ii];
                    }
                    segmentIn.close();
                    segmentIn = null;
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    segmentFile.delete();
                    segmentFile = null;
                    this.processSegment(monitor, keyWriter, header, body, objIndex, refIndex);
                }
                long divider = body.closeStream();
                IIndexReader.IOne2OneIndex headerIndex = new IntIndexStreamer().writeTo(index, divider, header);
                index.writeLong(divider);
                index.flush();
                index.close();
                index = null;
                IndexReader.InboundReader inboundReader = new IndexReader.InboundReader(this.indexFile, headerIndex, body.getReader(null));
                return inboundReader;
            }
            finally {
                try {
                    if (index != null) {
                        index.close();
                    }
                }
                catch (IOException ignore) {}
                try {
                    if (segmentIn != null) {
                        segmentIn.close();
                    }
                }
                catch (IOException ignore) {}
                if (monitor.isCanceled()) {
                    this.cancel();
                }
            }
        }

        private void processSegment(IProgressListener monitor, KeyWriter keyWriter, int[] header, IntIndexStreamer body, int[] objIndex, int[] refIndex) throws IOException {
            ArrayUtils.sort(objIndex, refIndex);
            int start = 0;
            int previous = -1;
            for (int ii = 0; ii <= objIndex.length; ++ii) {
                if (ii == 0) {
                    start = ii;
                    previous = objIndex[ii];
                    continue;
                }
                if (ii != objIndex.length && previous == objIndex[ii]) continue;
                if (monitor.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                header[previous] = body.size() + 1;
                this.processObject(keyWriter, header, body, previous, refIndex, start, ii);
                if (ii >= objIndex.length) continue;
                previous = objIndex[ii];
                start = ii;
            }
        }

        private void processObject(KeyWriter keyWriter, int[] header, IntIndexStreamer body, int objectId, int[] refIndex, int fromIndex, int toIndex) throws IOException {
            Arrays.sort(refIndex, fromIndex, toIndex);
            int endPseudo = fromIndex;
            if (toIndex - fromIndex > 100000) {
                int jj;
                BitField duplicates = new BitField(this.size);
                for (jj = fromIndex; jj < toIndex && refIndex[jj] < 0; ++jj) {
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    if (duplicates.get(refIndex[jj])) continue;
                    body.add(refIndex[jj]);
                    duplicates.set(refIndex[jj]);
                }
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.get(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            } else {
                int jj;
                SetInt duplicates = new SetInt(toIndex - fromIndex);
                for (jj = fromIndex; jj < toIndex && refIndex[jj] < 0; ++jj) {
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    if (!duplicates.add(refIndex[jj])) continue;
                    body.add(refIndex[jj]);
                }
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.contains(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            }
            if (endPseudo > fromIndex) {
                keyWriter.storeKey(objectId, (Serializable)new int[]{header[objectId] - 1, endPseudo - fromIndex});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void cancel() {
            try {
                this.close();
                if (this.segments != null) {
                    for (int ii = 0; ii < this.segments.length; ++ii) {
                        new File(this.indexFile.getAbsolutePath() + ii + ".log").delete();
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.indexFile.delete();
            }
        }

        public synchronized void close() throws IOException {
            if (this.segments != null) {
                for (int ii = 0; ii < this.segments.length; ++ii) {
                    if (this.segments[ii] == null) continue;
                    this.segments[ii].flush();
                    this.segments[ii].close();
                    this.segments[ii] = null;
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    public static class IntArray1NSortedWriter
    extends IntArray1NWriter {
        public IntArray1NSortedWriter(int size, File indexFile) throws IOException {
            super(size, indexFile);
        }

        @Override
        protected void set(int index, int[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size() + 1;
            this.body.addAll(values, offset, length);
        }

        @Override
        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NSortedReader(this.indexFile, headerIndex, bodyIndex);
        }
    }

    public static class IntArray1NWriter {
        int[] header;
        File indexFile;
        DataOutputStream out;
        IntIndexStreamer body;

        public IntArray1NWriter(int size, File indexFile) throws IOException {
            this.header = new int[size];
            this.indexFile = indexFile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.body = new IntIndexStreamer();
            this.body.openStream(this.out, 0L);
        }

        public void log(Identifier identifer, int index, ArrayLong references) throws IOException {
            long pseudo = references.firstElement();
            references.sort();
            int[] objectIds = new int[references.size()];
            int length = 1;
            long current = 0L;
            long last = references.firstElement() - 1L;
            for (int ii = 0; ii < objectIds.length; ++ii) {
                int objectId;
                current = references.get(ii);
                if (last != current && (objectId = identifer.reverse(current)) >= 0) {
                    int jj = current == pseudo ? 0 : length++;
                    objectIds[jj] = objectId;
                }
                last = current;
            }
            this.set(index, objectIds, 0, length);
        }

        public void log(int index, int[] values) throws IOException {
            this.set(index, values, 0, values.length);
        }

        protected void set(int index, int[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size();
            this.body.add(length);
            this.body.addAll(values, offset, length);
        }

        public IIndexReader.IOne2ManyIndex flush() throws IOException {
            long divider = this.body.closeStream();
            IIndexReader.IOne2OneIndex headerIndex = new IntIndexStreamer().writeTo(this.out, divider, this.header);
            this.out.writeLong(divider);
            this.out.close();
            this.out = null;
            return this.createReader(headerIndex, this.body.getReader(null));
        }

        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NReader(this.indexFile, headerIndex, bodyIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                if (this.out != null) {
                    this.out.close();
                    this.body = null;
                    this.out = null;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.indexFile.exists()) {
                    this.indexFile.delete();
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    public static class IntIndexStreamer
    extends IntIndex<SoftReference<ArrayIntCompressed>> {
        DataOutputStream out;
        ArrayLong pageStart;
        int[] page;
        int left;

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, IteratorInt iterator) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(iterator);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, int[] array2) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array2);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position, int[] array2) throws IOException {
            this.openStream(out, position);
            this.addAll(array2);
            this.closeStream();
            return this.getReader(null);
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 1000000);
            this.page = new int[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            if (this.left < this.page.length) {
                this.addPage();
            }
            for (int jj = 0; jj < this.pageStart.size(); ++jj) {
                this.out.writeLong(this.pageStart.get(jj));
            }
            this.out.writeInt(this.pageSize);
            this.out.writeInt(this.size);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + (long)(8 * this.pageStart.size()) + 8L - this.pageStart.firstElement();
        }

        IndexReader.IntIndexReader getReader(File indexFile) {
            return new IndexReader.IntIndexReader(indexFile, this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        void addAll(IteratorInt iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        void add(int value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        void addAll(int[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        void addAll(int[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        private void addPage() throws IOException {
            ArrayIntCompressed array2 = new ArrayIntCompressed(this.page, 0, this.page.length - this.left);
            byte[] buffer = array2.toByteArray();
            this.out.write(buffer);
            int written = buffer.length;
            this.pages.put(this.pages.size(), new SoftReference<ArrayIntCompressed>(array2));
            this.pageStart.add(this.pageStart.lastElement() + (long)written);
            this.left = this.page.length;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }
    }

    public static class IntIndexCollector
    extends IntIndex<ArrayIntCompressed>
    implements IIndexReader.IOne2OneIndex {
        int mostSignificantBit;

        public IntIndexCollector(int size, int mostSignificantBit) {
            super(size);
            this.mostSignificantBit = mostSignificantBit;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            ArrayIntCompressed array2 = (ArrayIntCompressed)this.pages.get(page);
            if (array2 == null) {
                int ps = page < this.size / this.pageSize ? this.pageSize : this.size % this.pageSize;
                array2 = new ArrayIntCompressed(ps, 31 - this.mostSignificantBit, 0);
                this.pages.put(page, array2);
            }
            return array2;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void delete() {
            this.pages = null;
        }
    }

    static abstract class IntIndex<V> {
        int pageSize;
        int size;
        Pages<V> pages;

        protected IntIndex() {
        }

        protected IntIndex(int size) {
            this.init(size, 1000000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new Pages(size / pageSize + 1);
        }

        public int get(int index) {
            ArrayIntCompressed array2 = this.getPage(index / this.pageSize);
            return array2.get(index % this.pageSize);
        }

        public int[] getNext(int index, int length) {
            int[] answer = new int[length];
            int page = index / this.pageSize;
            int pageIndex = index % this.pageSize;
            ArrayIntCompressed array2 = this.getPage(page);
            for (int ii = 0; ii < length; ++ii) {
                answer[ii] = array2.get(pageIndex++);
                if (pageIndex < this.pageSize) continue;
                array2 = this.getPage(++page);
                pageIndex = 0;
            }
            return answer;
        }

        public void set(int index, int value) {
            ArrayIntCompressed array2 = this.getPage(index / this.pageSize);
            array2.set(index % this.pageSize, value);
        }

        protected abstract ArrayIntCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new Pages(this.size / this.pageSize + 1);
        }

        public int size() {
            return this.size;
        }
    }

    static class Pages<V> {
        int size;
        Object[] elements;

        public Pages(int initialSize) {
            this.elements = new Object[initialSize];
            this.size = 0;
        }

        private void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elements.length;
            if (minCapacity > oldCapacity) {
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object[] copy = new Object[newCapacity];
                System.arraycopy(this.elements, 0, copy, 0, Math.min(this.elements.length, newCapacity));
                this.elements = copy;
            }
        }

        public V get(int key) {
            return (V)(key >= this.elements.length ? null : this.elements[key]);
        }

        public void put(int key, V value) {
            this.ensureCapacity(key + 1);
            this.elements[key] = value;
            this.size = Math.max(this.size, key + 1);
        }

        public int size() {
            return this.size;
        }
    }

    public static class IntIndexCollectorUncompressed {
        int[] dataElements;

        public IntIndexCollectorUncompressed(int size) {
            this.dataElements = new int[size];
        }

        public void set(int index, int value) {
            this.dataElements[index] = value;
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile) throws IOException {
            return new IntIndexStreamer().writeTo(indexFile, this.dataElements);
        }
    }

    public static class Identifier
    implements IIndexReader.IOne2LongIndex {
        long[] identifiers;
        int size;

        public void add(long id2) {
            if (this.identifiers == null) {
                this.identifiers = new long[10000];
                this.size = 0;
            }
            if (this.size + 1 > this.identifiers.length) {
                int newCapacity = this.identifiers.length * 3 / 2 + 1;
                if (newCapacity < this.size + 1) {
                    newCapacity = this.size + 1;
                }
                this.identifiers = IndexWriter.copyOf(this.identifiers, newCapacity);
            }
            this.identifiers[this.size++] = id2;
        }

        public void sort() {
            Arrays.sort(this.identifiers, 0, this.size);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.identifiers[index];
        }

        @Override
        public int reverse(long val) {
            int a = 0;
            int c = this.size;
            while (a < c) {
                int b = a + c >>> 1;
                long probeVal = this.get(b);
                if (val < probeVal) {
                    c = b;
                    continue;
                }
                if (probeVal < val) {
                    a = b + 1;
                    continue;
                }
                return b;
            }
            return -1 - a;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void delete() {
            this.identifiers = null;
        }

        @Override
        public void unload() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface KeyWriter {
        public void storeKey(int var1, Serializable var2);
    }
}

